/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.base.BaseDialog;
import com.baijiayun.livebase.utils.ThemeDataUtil;

public class CommonDialog
extends BaseDialog {
    private final Context context;
    private ChoiceMode choiceMode;
    private NegativeType negativeType = NegativeType.Gray;
    private String mainDisplayText;
    private Integer mainTextColor;
    private Integer mainTextSize;
    private String subtitleDisplayText;
    private Integer subtitleTextColor;
    private String positiveText;
    private String negativeText;
    private int iconDrawableId;
    boolean showStudyReport;
    private Drawable windowBg;
    private DialogInterface.OnClickListener onPositiveClickListener;
    private DialogInterface.OnClickListener onNegativeClickListener;
    private DialogInterface.OnClickListener onStudyReportClickListener;
    private int windowWidth;
    private int windowHeight;
    private boolean isShowTitleBar;
    private String titleText;
    private Drawable customConfirmButtonBg;
    private Drawable customNegativeButtonBg;
    private Integer confirmButtonTextColor;
    private Integer negativeButtonTextColor;
    private TextView positive;

    public CommonDialog(@NonNull Context context, ChoiceMode choiceMode) {
        this(context, choiceMode, 0x1030011);
    }

    public CommonDialog(@NonNull Context context, ChoiceMode choiceMode, @StyleRes int themeResId) {
        super(context, themeResId);
        this.context = context;
        this.choiceMode = choiceMode;
        this.windowWidth = context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_dialog_container_width);
        this.windowHeight = -2;
    }

    public CommonDialog setMainDisplayText(String mainDisplayText) {
        this.mainDisplayText = mainDisplayText;
        return this;
    }

    public CommonDialog setMainTextColor(int mainColor) {
        this.mainTextColor = mainColor;
        return this;
    }

    public CommonDialog setMainTextSize(int sp) {
        this.mainTextSize = sp;
        return this;
    }

    public CommonDialog setSubtitleDisplayText(String subtitleDisplayText) {
        this.subtitleDisplayText = subtitleDisplayText;
        return this;
    }

    public CommonDialog setSubtitleTextColor(int textColor) {
        this.subtitleTextColor = textColor;
        return this;
    }

    public CommonDialog setIconDrawableId(int iconDrawableId) {
        this.iconDrawableId = iconDrawableId;
        return this;
    }

    public CommonDialog setNegative(String negativeText, DialogInterface.OnClickListener onNegativeClickListener) {
        this.negativeText = negativeText;
        this.onNegativeClickListener = onNegativeClickListener;
        return this;
    }

    public CommonDialog setNegativeType(NegativeType negativeType) {
        this.negativeType = negativeType;
        return this;
    }

    public CommonDialog setPositive(String positiveText, DialogInterface.OnClickListener onPositiveClickListener) {
        this.positiveText = positiveText;
        this.onPositiveClickListener = onPositiveClickListener;
        return this;
    }

    public CommonDialog refreshPositive(String positiveText) {
        this.positiveText = positiveText;
        if (this.positive != null) {
            this.positive.setText((CharSequence)positiveText);
        }
        return this;
    }

    public CommonDialog setDisplayMode(ChoiceMode choiceMode) {
        this.choiceMode = choiceMode;
        return this;
    }

    public CommonDialog setCustomButtonBg(Drawable customConfirmButtonBg, Drawable customNegativeButtonBg) {
        this.customConfirmButtonBg = customConfirmButtonBg;
        this.customNegativeButtonBg = customNegativeButtonBg;
        return this;
    }

    public CommonDialog setConfirmButtonTextColor(@ColorInt int confirmButtonTextColor) {
        this.confirmButtonTextColor = confirmButtonTextColor;
        return this;
    }

    public CommonDialog setNegativeButtonTextColor(@ColorInt int negativeButtonTextColor) {
        this.negativeButtonTextColor = negativeButtonTextColor;
        return this;
    }

    public CommonDialog setCancelOnPressBack(boolean cancel) {
        super.setCancelable(cancel);
        return this;
    }

    public CommonDialog setStudyReportBtn(boolean showStudyReport, DialogInterface.OnClickListener onStudyReportClickListener) {
        this.showStudyReport = showStudyReport;
        this.onStudyReportClickListener = onStudyReportClickListener;
        return this;
    }

    public CommonDialog setWindowBackground(Drawable windowBackground) {
        this.windowBg = windowBackground;
        return this;
    }

    public CommonDialog setWindowSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
        return this;
    }

    public CommonDialog setTitleBarVisible(boolean shouldShow) {
        this.isShowTitleBar = shouldShow;
        return this;
    }

    public CommonDialog setTitle(String title) {
        this.titleText = title;
        return this;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Drawable iconDrawable;
        super.onCreate(savedInstanceState);
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        LinearLayout container = new LinearLayout(this.context);
        container.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        container.setGravity(17);
        View layout2 = inflater.inflate(R.layout.uibase_base_dialog_layout, (ViewGroup)container);
        this.setContentView(layout2);
        ImageView ivIcon = (ImageView)layout2.findViewById(R.id.bjysc_base_dialog_icon);
        TextView tvMain = (TextView)layout2.findViewById(R.id.bjysc_base_dialog_main_display);
        TextView subtitleTv = (TextView)layout2.findViewById(R.id.bjysc_base_dialog_subtitle);
        TextView tvNegative = (TextView)layout2.findViewById(R.id.bjysc_base_dialog_negative);
        TextView tvPositiveBlue = (TextView)layout2.findViewById(R.id.bjysc_base_dialog_positive_blue);
        TextView tvPositiveRed = (TextView)layout2.findViewById(R.id.bjysc_base_dialog_positive_red);
        TextView studyReportTv = (TextView)layout2.findViewById(R.id.bjysc_base_dialog_show_study_report);
        RelativeLayout titleBarRl = (RelativeLayout)layout2.findViewById(R.id.rl_title_container);
        try {
            iconDrawable = ContextCompat.getDrawable((Context)this.context, (int)this.iconDrawableId);
        }
        catch (Exception e) {
            iconDrawable = null;
            LPLogger.e((String)"CommonDialog", (String)("iconDrawableId:(" + this.iconDrawableId + ") not found!!"));
        }
        if (iconDrawable != null) {
            ivIcon.setImageDrawable(iconDrawable);
            ivIcon.setVisibility(0);
        } else {
            ivIcon.setVisibility(8);
        }
        tvMain.setText((CharSequence)this.mainDisplayText);
        if (TextUtils.isEmpty((CharSequence)this.subtitleDisplayText)) {
            subtitleTv.setVisibility(8);
        } else {
            subtitleTv.setText((CharSequence)this.subtitleDisplayText);
            subtitleTv.setVisibility(0);
        }
        if (TextUtils.isEmpty((CharSequence)this.negativeText) || this.choiceMode.mode >= 0 && this.choiceMode.mode != ChoiceMode.Single_Negative.mode) {
            tvNegative.setVisibility(8);
        } else {
            tvNegative.setText((CharSequence)this.negativeText);
            tvNegative.setTextColor(this.negativeButtonTextColor != null ? this.negativeButtonTextColor : (this.negativeType == NegativeType.Gray ? ThemeDataUtil.getColorFromThemeConfigByAttrId(this.context, R.attr.base_theme_dialog_negative_text_color) : this.getContext().getResources().getColor(R.color.base_warning_color)));
            tvNegative.setOnClickListener(v -> {
                if (this.onNegativeClickListener != null) {
                    this.onNegativeClickListener.onClick((DialogInterface)this, -2);
                }
                this.dismiss();
            });
            if (this.customNegativeButtonBg != null) {
                tvNegative.setBackground(this.customNegativeButtonBg);
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.positiveText)) {
            tvPositiveBlue.setVisibility(8);
            tvPositiveRed.setVisibility(8);
        } else {
            if (Math.abs(this.choiceMode.mode) == ChoiceMode.Single_Blue.mode) {
                this.positive = tvPositiveBlue;
                tvPositiveRed.setVisibility(8);
            } else if (Math.abs(this.choiceMode.mode) == ChoiceMode.Single_Red.mode) {
                this.positive = tvPositiveRed;
                tvPositiveBlue.setVisibility(8);
            }
            if (this.positive != null) {
                this.positive.setVisibility(0);
                this.positive.setText((CharSequence)this.positiveText);
                this.positive.setOnClickListener(v -> {
                    if (this.onPositiveClickListener != null) {
                        this.onPositiveClickListener.onClick((DialogInterface)this, -1);
                    }
                    this.dismiss();
                });
                if (this.customConfirmButtonBg != null) {
                    this.positive.setBackground(this.customConfirmButtonBg);
                }
                if (this.confirmButtonTextColor != null) {
                    this.positive.setTextColor(this.confirmButtonTextColor.intValue());
                }
            } else {
                tvPositiveBlue.setVisibility(8);
                tvPositiveRed.setVisibility(8);
            }
        }
        if (this.showStudyReport) {
            studyReportTv.setVisibility(0);
            studyReportTv.setOnClickListener(v -> {
                if (this.onStudyReportClickListener != null) {
                    this.onStudyReportClickListener.onClick((DialogInterface)this, -3);
                }
                this.dismiss();
            });
        }
        if (this.isShowTitleBar) {
            titleBarRl.setVisibility(0);
            TextView title = (TextView)titleBarRl.findViewById(R.id.tv_title);
            title.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.titleText) ? this.context.getString(R.string.live_exit_hint_title) : this.titleText));
            ImageView image = (ImageView)titleBarRl.findViewById(R.id.iv_close);
            image.setOnClickListener(v -> this.dismiss());
        } else {
            titleBarRl.setVisibility(8);
        }
        if (this.mainTextColor != null) {
            tvMain.setTextColor(this.mainTextColor.intValue());
        }
        if (this.mainTextSize != null) {
            tvMain.setTextSize((float)this.mainTextSize.intValue());
        }
        if (this.subtitleTextColor != null) {
            subtitleTv.setTextColor(this.subtitleTextColor.intValue());
        }
    }

    protected void onStart() {
        super.onStart();
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        layoutParams.width = this.windowWidth;
        layoutParams.height = this.windowHeight;
        this.getWindow().setAttributes(layoutParams);
        this.getWindow().setBackgroundDrawable(this.windowBg == null ? new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(this.context, R.attr.base_theme_window_bg_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).strokeWidth(UtilsKt.getDp((int)1)).strokeColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_bg_stroke)).build() : this.windowBg);
    }

    public static enum ChoiceMode {
        None(0),
        Single_Negative(3),
        Single_Blue(1),
        Single_Red(2),
        Double_Blue(-1),
        Double_Red(-2);

        final int mode;

        private ChoiceMode(int mode) {
            this.mode = mode;
        }
    }

    public static enum NegativeType {
        Gray,
        Red;

    }
}

