/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.emoji;

import com.baijiayun.livebase.models.LPExpressionModel;
import com.baijiayun.livebase.widgets.emoji.EmojiContract;
import java.util.List;

public class EmojiPresenter
implements EmojiContract.Presenter {
    private EmojiContract.View view;
    private int PAGE_SIZE;
    private List<LPExpressionModel> emojiList;
    private int currentPageFirstItem;

    public EmojiPresenter(EmojiContract.View view, List<LPExpressionModel> list) {
        this.view = view;
        this.emojiList = list;
        this.PAGE_SIZE = view.getRowCount() * view.getSpanCount();
    }

    @Override
    public void subscribe() {
    }

    @Override
    public void unSubscribe() {
    }

    @Override
    public void destroy() {
        this.view = null;
    }

    @Override
    public void setExpressions(List<LPExpressionModel> expressions) {
        this.emojiList = expressions;
    }

    @Override
    public LPExpressionModel getItem(int page, int position) {
        return this.emojiList == null ? null : this.emojiList.get(page * this.PAGE_SIZE + position);
    }

    @Override
    public int getCount(int page) {
        return this.emojiList == null ? 0 : this.getRealCount(page);
    }

    private int getRealCount(int page) {
        return this.emojiList.size() < this.PAGE_SIZE * (page + 1) ? this.emojiList.size() % this.PAGE_SIZE : this.PAGE_SIZE;
    }

    @Override
    public int getPageCount() {
        return this.emojiList == null ? 0 : this.getRealPageCount();
    }

    private int getRealPageCount() {
        return this.emojiList.size() % this.PAGE_SIZE == 0 ? this.emojiList.size() / this.PAGE_SIZE : this.emojiList.size() / this.PAGE_SIZE + 1;
    }

    @Override
    public void onSizeChanged() {
        this.PAGE_SIZE = this.view.getRowCount() * this.view.getSpanCount();
    }

    @Override
    public int getPageOfCurrentFirstItem() {
        return this.currentPageFirstItem / this.PAGE_SIZE;
    }

    @Override
    public void onPageSelected(int page) {
        this.currentPageFirstItem = page * this.PAGE_SIZE + 1;
    }
}

