/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.dialog.preview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.PagerAdapter;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.DataSource;
import com.baijiayun.glide.load.engine.GlideException;
import com.baijiayun.glide.load.resource.gif.GifDrawable;
import com.baijiayun.glide.request.RequestListener;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.utils.AliCloudImageUtil;
import com.baijiayun.livebase.widgets.dialog.preview.PreviewViewpager;
import com.baijiayun.livebase.widgets.view.photoview.PhotoView;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class ChatPictureViewFragment
extends BaseDialogFragment {
    private Callback callback;

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.layout_chat_image_preview;
    }

    @Override
    protected int getContentBackgroundColor() {
        return ContextCompat.getColor((Context)this.contextReference, (int)R.color.base_transparent);
    }

    @Override
    protected void init(Bundle savedInstanceState, Bundle arguments) {
        this.hideTitleBar();
        PreviewViewpager viewPager = (PreviewViewpager)this.$.id(R.id.chat_preview_viewpager).view();
        ChatPicturePagerAdapter pagerAdapter = null;
        if (this.getArguments() != null) {
            pagerAdapter = new ChatPicturePagerAdapter(this.getArguments().getStringArrayList("url"));
        }
        viewPager.setAdapter(pagerAdapter);
        viewPager.setCurrentItem(this.getArguments().getInt("pos"));
    }

    @Override
    protected void setWindowParams(@NonNull WindowManager.LayoutParams windowParams) {
        windowParams.width = -1;
        windowParams.height = -1;
        windowParams.dimAmount = 0.85f;
        windowParams.gravity = 17;
        windowParams.windowAnimations = R.style.BJYViewBigPicAnim;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.callback = null;
    }

    public static ChatPictureViewFragment newInstance(ArrayList<String> urls, int position, boolean isTeacherOrAssistant) {
        Bundle args = new Bundle();
        args.putStringArrayList("url", urls);
        args.putInt("pos", position);
        args.putBoolean("isTeacherOrAssistant", isTeacherOrAssistant);
        ChatPictureViewFragment fragment = new ChatPictureViewFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public static ChatPictureViewFragment newInstance(ArrayList<String> urls) {
        Bundle args = new Bundle();
        args.putStringArrayList("url", urls);
        ChatPictureViewFragment fragment = new ChatPictureViewFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public static interface Callback {
        public void save(String var1);

        public void toCourseware(String var1);
    }

    class ChatPicturePagerAdapter
    extends PagerAdapter {
        List<String> data;

        ChatPicturePagerAdapter(List<String> data) {
            this.data = data;
        }

        public int getCount() {
            return this.data == null ? 0 : this.data.size();
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == ((ViewHolder)object).rootView;
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            String url;
            boolean isGif;
            Context context = container.getContext();
            View itemView = LayoutInflater.from((Context)context).inflate(R.layout.item_chat_image_preview, container, false);
            PhotoView photoView = (PhotoView)itemView.findViewById(R.id.lp_dialog_big_picture_img);
            final TextView tvLoading = (TextView)itemView.findViewById(R.id.lp_dialog_big_picture_loading_label);
            ImageView toCoursewareIv = (ImageView)itemView.findViewById(R.id.picture_to_courseware_btn);
            if (ChatPictureViewFragment.this.getArguments() != null) {
                toCoursewareIv.setVisibility(ChatPictureViewFragment.this.getArguments().getBoolean("isTeacherOrAssistant") ? 0 : 8);
            }
            if (isGif = (url = this.data.get(position)).endsWith(".gif")) {
                Glide.with((Fragment)ChatPictureViewFragment.this).asGif().load(url).listener((RequestListener)new RequestListener<GifDrawable>(){

                    public boolean onLoadFailed(@androidx.annotation.Nullable @Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                        if (ChatPictureViewFragment.this.getActivity() != null) {
                            tvLoading.setText((CharSequence)ChatPictureViewFragment.this.getString(R.string.live_image_loading_fail));
                        }
                        return false;
                    }

                    public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                        tvLoading.setVisibility(8);
                        return false;
                    }
                }).into((ImageView)photoView);
            } else {
                Glide.with((Fragment)ChatPictureViewFragment.this).load(AliCloudImageUtil.getScaledUrl(url, "m_mfit", DisplayUtils.getScreenWidthPixels((Context)context), DisplayUtils.getScreenHeightPixels((Context)context))).listener((RequestListener)new RequestListener<Drawable>(){

                    public boolean onLoadFailed(@androidx.annotation.Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        if (ChatPictureViewFragment.this.getActivity() != null) {
                            tvLoading.setText((CharSequence)ChatPictureViewFragment.this.getString(R.string.live_image_loading_fail));
                        }
                        return false;
                    }

                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        tvLoading.setVisibility(8);
                        return false;
                    }
                }).into((ImageView)photoView);
            }
            ViewHolder viewHolder = new ViewHolder();
            viewHolder.photoView = photoView;
            viewHolder.rootView = itemView;
            photoView.setOnLongClickListener(v -> {
                if (ChatPictureViewFragment.this.callback != null) {
                    ChatPictureViewFragment.this.callback.save(url);
                }
                return true;
            });
            this.setDismissListener(photoView);
            toCoursewareIv.setOnClickListener(v -> {
                if (photoView.getDrawable() == null) {
                    return;
                }
                toCoursewareIv.setEnabled(false);
                if (ChatPictureViewFragment.this.callback != null) {
                    ChatPictureViewFragment.this.callback.toCourseware(url);
                }
                viewHolder.disposableOfClicked = Observable.timer((long)2L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(time -> toCoursewareIv.setEnabled(true));
            });
            container.addView(itemView);
            return viewHolder;
        }

        private void setDismissListener(PhotoView photoView) {
            photoView.setOnViewTapListener((imageView, x, y) -> ChatPictureViewFragment.this.dismissAllowingStateLoss());
        }

        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            ViewHolder viewHolder = (ViewHolder)object;
            RxUtils.dispose((Disposable)((ViewHolder)object).disposableOfClicked);
            Glide.with((View)container).clear((View)viewHolder.photoView);
            container.removeView(viewHolder.rootView);
        }
    }

    public static class SimpleChatPicCallback
    implements Callback {
        @Override
        public void save(String url) {
        }

        @Override
        public void toCourseware(String url) {
        }
    }

    static class ViewHolder {
        Disposable disposableOfClicked;
        PhotoView photoView;
        View rootView;

        ViewHolder() {
        }
    }
}

