/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.dialog.custom_webpage;

import android.content.Context;
import android.view.WindowManager;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.widgets.dialog.custom_webpage.BaseWebViewDialogFragment;
import com.tencent.smtt.sdk.WebView;

public class CustomWebPageDialogFragment
extends BaseWebViewDialogFragment {
    private Callback listener;

    @Override
    public void loadUrl(String url) {
        super.loadUrl(url);
        if (this.listener != null) {
            this.listener.onShow(this.mWebView, url);
        }
    }

    @Override
    protected void closeDialogFragment() {
        super.closeDialogFragment();
        if (this.listener != null) {
            this.listener.onClose(this.mWebView);
        }
    }

    public void setListener(Callback listener) {
        this.listener = listener;
    }

    @Override
    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        int y;
        int x;
        int height;
        int width;
        if (this.getArguments() == null) {
            width = -1;
            height = -1;
            x = 0;
            y = 0;
        } else {
            width = this.getArguments().getFloat("width") > 0.0f && this.getArguments().getFloat("width") < 1.0f ? (int)((float)DisplayUtils.getScreenWidthPixels((Context)this.getContext()) * this.getArguments().getFloat("width")) : -1;
            height = this.getArguments().getFloat("height") > 0.0f && this.getArguments().getFloat("height") < 1.0f ? (int)((float)DisplayUtils.getScreenHeightPixels((Context)this.getContext()) * this.getArguments().getFloat("height")) : -1;
            x = (int)((float)DisplayUtils.getScreenWidthPixels((Context)this.getContext()) * this.getArguments().getFloat("x"));
            y = (int)((float)DisplayUtils.getScreenHeightPixels((Context)this.getContext()) * this.getArguments().getFloat("y"));
        }
        windowParams.width = width;
        windowParams.height = height;
        windowParams.gravity = 51;
        windowParams.x = x;
        windowParams.y = y;
        windowParams.windowAnimations = R.style.BJYLiveBaseSendMsgDialogAnim;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.listener = null;
    }

    public static interface Callback {
        public void onShow(WebView var1, String var2);

        public void onClose(WebView var1);
    }
}

