/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.dialog;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.glide.Glide;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.databinding.DialogCustomUserBinding;
import com.baijiayun.livebase.models.CustomUserModel;
import java.io.Serializable;
import java.util.Objects;

public class CustomUserDialog
extends BaseDialogFragment {
    protected DialogCustomUserBinding binding;
    private View.OnClickListener onPositiveClickListener;
    private View.OnClickListener onNegativeClickListener;
    protected CustomUserModel customUserModel;

    @Override
    protected int getLayoutId() {
        return R.layout.dialog_custom_user;
    }

    @Override
    protected void init(@Nullable Bundle savedInstanceState, @Nullable Bundle arguments) {
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        Serializable serializable;
        super.onViewCreated(view, savedInstanceState);
        this.hideTitleBar();
        this.binding = DialogCustomUserBinding.bind(view);
        this.binding.navigateTv.setBackground(new DrawableBuilder().cornerRadius(UtilsKt.getDp((int)4)).strokeWidth(UtilsKt.getDp((int)1)).strokeColor(-2302238).build());
        this.binding.positiveTv.setBackground(new DrawableBuilder().cornerRadius(UtilsKt.getDp((int)4)).solidColor(-14786817).build());
        if (this.getArguments() != null && (serializable = this.getArguments().getSerializable(CustomUserDialog.class.getSimpleName())) instanceof CustomUserModel) {
            this.customUserModel = (CustomUserModel)serializable;
            if (this.customUserModel.logoResId != 0) {
                this.binding.logoIv.setImageResource(this.customUserModel.logoResId);
            } else if (!TextUtils.isEmpty((CharSequence)this.customUserModel.logoUrl) && this.customUserModel.logoUrl.startsWith("http")) {
                Glide.with((Context)view.getContext()).load(this.customUserModel.logoUrl).into(this.binding.logoIv);
            }
            if (!TextUtils.isEmpty((CharSequence)this.customUserModel.title)) {
                this.binding.titleTv.setText((CharSequence)this.customUserModel.title);
            }
            if (!TextUtils.isEmpty((CharSequence)this.customUserModel.content)) {
                this.binding.contentTv.setText((CharSequence)this.customUserModel.content);
            }
            if (!TextUtils.isEmpty((CharSequence)this.customUserModel.positiveText)) {
                this.binding.positiveTv.setText((CharSequence)this.customUserModel.positiveText);
            }
            if (!TextUtils.isEmpty((CharSequence)this.customUserModel.navigateText)) {
                this.binding.navigateTv.setText((CharSequence)this.customUserModel.navigateText);
            }
        }
        this.binding.positiveTv.setOnClickListener(v -> {
            if (this.onPositiveClickListener != null) {
                this.onPositiveClickListener.onClick(v);
            }
        });
        this.binding.navigateTv.setOnClickListener(v -> {
            if (this.onNegativeClickListener != null) {
                this.onNegativeClickListener.onClick(v);
            }
        });
    }

    @Override
    protected boolean isCanceled() {
        return false;
    }

    @Override
    protected boolean isCanceledOnTouchOutside() {
        return false;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.getDialog().getWindow().setBackgroundDrawable(new DrawableBuilder().baseDrawable(Objects.requireNonNull(ResourcesCompat.getDrawable((Resources)this.getContext().getResources(), (int)R.drawable.bjy_base_bg_custom_dialog, null))).cornerRadius(UtilsKt.getDp((int)4)).build());
    }

    @Override
    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        windowParams.dimAmount = 0.5f;
        windowParams.flags |= 2;
        windowParams.width = UtilsKt.getDp((int)320);
        windowParams.height = -2;
        windowParams.gravity = 17;
    }

    public void setOnPositiveClickListener(View.OnClickListener onPositiveClickListener) {
        this.onPositiveClickListener = onPositiveClickListener;
    }

    public void setOnNegativeClickListener(View.OnClickListener onNegativeClickListener) {
        this.onNegativeClickListener = onNegativeClickListener;
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.binding = null;
    }
}

