/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.graphics.ColorUtils;
import androidx.core.widget.TextViewCompat;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.models.LPHorseLamp;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class HorseLampView
extends RelativeLayout {
    private LPHorseLamp horseLamp;
    private Disposable disposeOfMarquee;
    private Disposable disposeOfMarqueeDouble;
    ObservableEmitter<Boolean> marqueeEmitter;
    ObservableEmitter<Boolean> secondMarqueeEmitter;
    private ObjectAnimator objectAnimator;
    private ObjectAnimator objectAnimatorDouble;
    private TextView textViewBlink;
    private TextView textViewBlinkDouble;
    private final Random random = new Random();

    public HorseLampView(Context context) {
        this(context, null);
    }

    public HorseLampView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HorseLampView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public HorseLampView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void startHorseLamp(LPHorseLamp lpHorseLamp) {
        this.horseLamp = lpHorseLamp;
        if (this.horseLamp != null) {
            this.startMarqueeTape();
        }
    }

    private void startMarqueeTape() {
        RxUtils.dispose((Disposable)this.disposeOfMarquee);
        RxUtils.dispose((Disposable)this.disposeOfMarqueeDouble);
        if ("roll".equals(this.horseLamp.displayMode)) {
            this.cancelMarqueeTapeAnimation();
            this.disposeOfMarquee = Observable.create(emitter -> {
                this.marqueeEmitter = emitter;
            }).delay((long)this.horseLamp.displayRollDuration, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(isSecondRoll -> this.showMarqueeTapeRoll(this.horseLamp, (boolean)isSecondRoll));
            if (this.horseLamp.count == 2) {
                this.disposeOfMarqueeDouble = Observable.create(emitter -> {
                    this.secondMarqueeEmitter = emitter;
                }).delay(2L, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> this.showMarqueeTapeRoll(this.horseLamp, true));
            }
            this.showMarqueeTapeRoll(this.horseLamp, false);
        } else {
            if (this.textViewBlink != null) {
                this.removeView((View)this.textViewBlink);
            }
            int maxHeight = this.getMeasuredHeight();
            if (this.horseLamp.count == 1) {
                this.disposeOfMarquee = this.startMarqueeBlinkAnimator(this.horseLamp, maxHeight, false);
            } else {
                if (this.textViewBlinkDouble != null) {
                    this.removeView((View)this.textViewBlinkDouble);
                }
                this.disposeOfMarquee = this.startMarqueeBlinkAnimator(this.horseLamp, maxHeight / 2, false);
                this.disposeOfMarqueeDouble = this.startMarqueeBlinkAnimator(this.horseLamp, maxHeight / 2, true);
            }
        }
    }

    private void showMarqueeTapeRoll(final LPHorseLamp lamp, final boolean isSecondRoll) {
        final TextView textView = this.getTextView(lamp, isSecondRoll);
        int[] textViewSize = DisplayUtils.getUnDisplayViewSize((View)textView);
        int width = this.getMeasuredWidth();
        int translationX = width + textViewSize[0];
        int duration = translationX / 30;
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)textView, (String)"translationX", (float[])new float[]{-translationX});
        animator.setDuration((long)duration * 1000L);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                HorseLampView.this.removeView((View)textView);
                if (lamp.count == 1) {
                    HorseLampView.this.marqueeEmitter.onNext((Object)false);
                } else if (isSecondRoll) {
                    HorseLampView.this.marqueeEmitter.onNext((Object)false);
                }
            }
        });
        animator.start();
        if (isSecondRoll) {
            this.objectAnimatorDouble = animator;
        } else {
            this.objectAnimator = animator;
            if (lamp.count == 2) {
                this.secondMarqueeEmitter.onNext((Object)false);
            }
        }
    }

    private Disposable startMarqueeBlinkAnimator(LPHorseLamp lamp, int maxHeight, boolean isSecondBlinkTextView) {
        TextView textView = this.getTextView(lamp, isSecondBlinkTextView);
        int[] textViewSize = DisplayUtils.getUnDisplayViewSize((View)textView);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (isSecondBlinkTextView) {
            this.textViewBlinkDouble = textView;
        } else {
            this.textViewBlink = textView;
        }
        return Observable.interval((long)0L, (long)lamp.displayBlinkDuration, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(v -> {
            int topMargin = isSecondBlinkTextView ? maxHeight : 0;
            layoutParams.topMargin = textViewSize[1] >= maxHeight ? topMargin : this.random.nextInt(Math.abs(maxHeight - textViewSize[1])) + topMargin;
            layoutParams.leftMargin = this.getMeasuredWidth() <= textViewSize[0] ? -this.random.nextInt(Math.abs(textViewSize[0])) / 4 * 3 + textViewSize[0] / 4 : this.random.nextInt(Math.abs(this.getWidth() - textViewSize[0]));
            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            textView.invalidate();
        });
    }

    private TextView getTextView(LPHorseLamp lamp, boolean lastAnimator) {
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)lamp.value);
        textView.setTextColor(ColorUtils.setAlphaComponent((int)Color.parseColor((String)lamp.color), (int)Math.round(lamp.opacity * 255.0f)));
        textView.setTextSize((float)lamp.fontSize);
        textView.setSingleLine(true);
        textView.setPadding(20, 10, 20, 10);
        textView.setGravity(17);
        textView.setBackgroundColor(ColorUtils.setAlphaComponent((int)Color.parseColor((String)lamp.backgroundColor), (int)Math.round(lamp.backgroundOpacity * 255.0f)));
        boolean isBold = lamp.fontBold == 1;
        textView.getPaint().setFakeBoldText(isBold);
        int[] textViewSize = DisplayUtils.getUnDisplayViewSize((View)textView);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
        int maxHalfHeight = this.getHeight() / 2;
        if (lamp.count == 1) {
            if (textViewSize[1] >= this.getHeight()) {
                textView.setHeight(this.getHeight());
                textViewSize[1] = this.getHeight();
                TextViewCompat.setAutoSizeTextTypeWithDefaults((TextView)textView, (int)1);
                lp.topMargin = 0;
            } else {
                lp.topMargin = this.random.nextInt(Math.abs(this.getHeight() - textViewSize[1]));
            }
        } else if (textViewSize[1] >= maxHalfHeight) {
            textView.setHeight(maxHalfHeight);
            textViewSize[1] = maxHalfHeight;
            TextViewCompat.setAutoSizeTextTypeWithDefaults((TextView)textView, (int)1);
            lp.topMargin = lastAnimator ? maxHalfHeight : 0;
        } else {
            lp.topMargin = this.random.nextInt(Math.abs(maxHalfHeight - textViewSize[1])) + (lastAnimator ? maxHalfHeight : 0);
        }
        lp.addRule(21);
        lp.rightMargin = -textViewSize[0];
        this.addView((View)textView, (ViewGroup.LayoutParams)lp);
        return textView;
    }

    private void cancelMarqueeTapeAnimation() {
        if (this.objectAnimator != null) {
            this.objectAnimator.cancel();
            this.objectAnimator.removeAllListeners();
        }
        if (this.objectAnimatorDouble != null) {
            this.objectAnimatorDouble.cancel();
            this.objectAnimatorDouble.removeAllListeners();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.post(() -> {
            if (this.horseLamp != null) {
                this.startMarqueeTape();
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelMarqueeTapeAnimation();
        RxUtils.dispose((Disposable)this.disposeOfMarquee);
        RxUtils.dispose((Disposable)this.disposeOfMarqueeDouble);
    }
}

