/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.widgets.CustomColor;
import java.util.HashMap;
import java.util.Map;

public class ThemeDataUtil {
    private static HashMap<Integer, Integer> themeConfig;

    public static HashMap<Integer, Integer> getThemeConfig() {
        return themeConfig;
    }

    public static void initThemeConfig(CustomColor customColor) {
        if (customColor == null) {
            return;
        }
        if (themeConfig == null) {
            themeConfig = new HashMap();
        } else {
            themeConfig.clear();
        }
        ThemeDataUtil.putColor2ThemeConfig(R.attr.base_theme_live_product_color, "#1e5eff");
        ThemeDataUtil.putColor2ThemeConfig(R.attr.base_theme_window_bg_color, customColor.windowBgColor);
        customColor.brandContainerColor = customColor.windowBgColor.replace("#", "#E6");
        ThemeDataUtil.putColor2ThemeConfig(R.attr.base_theme_brand_container_color, customColor.brandContainerColor);
        ThemeDataUtil.putColor2ThemeConfig(R.attr.base_theme_room_bg_color, customColor.roomBgColor);
        ThemeDataUtil.putColor2ThemeConfig(R.attr.base_theme_blackboard_color, customColor.blackboardColor);
        ThemeDataUtil.putColor2ThemeConfig(R.attr.base_theme_bottom_menu_text_color, customColor.bottomMenuTextColor);
        ThemeDataUtil.putColor2ThemeConfig(R.attr.base_theme_window_main_text_color, customColor.mainTextColor);
        ThemeDataUtil.putColor2ThemeConfig(R.attr.base_theme_window_assistant_text_color, customColor.assistantTextColor);
        ThemeDataUtil.putColor2ThemeConfig(R.attr.base_theme_dialog_negative_bg_color, customColor.negativeBgColor);
        ThemeDataUtil.putColor2ThemeConfig(R.attr.base_theme_dialog_negative_text_color, customColor.negativeTextColor);
        ThemeDataUtil.putColor2ThemeConfig(R.attr.base_theme_dialog_positive_text_color, customColor.positiveTextColor);
    }

    public static void clearConfig() {
        if (themeConfig != null) {
            themeConfig.clear();
        }
    }

    private static void putColor2ThemeConfig(@AttrRes int attrId, String colorString) {
        if (TextUtils.isEmpty((CharSequence)colorString) || !colorString.contains("#")) {
            return;
        }
        themeConfig.put(attrId, Color.parseColor((String)colorString));
    }

    public static int getColorFromThemeConfigByAttrId(Context context, int attrId) {
        int defaultColor = ThemeDataUtil.getColorByAttributeId(context, attrId);
        if (themeConfig == null) {
            return defaultColor;
        }
        Integer color2 = themeConfig.get(attrId);
        return color2 == null ? defaultColor : color2;
    }

    public static int getColorFromThemeConfigByAttrIdWithAlpha(Context context, int attrId, float a) {
        int color2 = ThemeDataUtil.getColorFromThemeConfigByAttrId(context, attrId);
        float r = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(color2 & 0xFF) / 255.0f;
        a = Math.max(0.0f, Math.min(1.0f, a));
        return (int)(a * 255.0f + 0.5f) << 24 | (int)(r * 255.0f + 0.5f) << 16 | (int)(g * 255.0f + 0.5f) << 8 | (int)(b * 255.0f + 0.5f);
    }

    public static int getColorByAttributeId(Context context, int attrId) {
        try {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = context.getTheme();
            theme.resolveAttribute(attrId, typedValue, true);
            return typedValue.data;
        }
        catch (Exception e) {
            LPLogger.e((String)("\u989c\u8272\u6ca1\u627e\u5230\uff01" + attrId));
            return 0;
        }
    }

    @ColorInt
    public static int getColorFromThemConfigByColorId(Context context, int colorId) {
        if (themeConfig == null) {
            return ContextCompat.getColor((Context)context, (int)colorId);
        }
        for (Map.Entry<Integer, Integer> entry : themeConfig.entrySet()) {
            int value;
            int key = entry.getKey() == null ? 0 : entry.getKey();
            int n = value = entry.getValue() == null ? 0 : entry.getValue();
            if (colorId != ThemeDataUtil.getResIdByAttributeId(context, key)) continue;
            return value;
        }
        int color2 = -65536;
        try {
            color2 = ContextCompat.getColor((Context)context, (int)colorId);
        }
        catch (Exception e) {
            LPLogger.e((String)("(" + colorId + ") \u4e0d\u662f color res id"));
            e.printStackTrace();
        }
        return color2;
    }

    public static int getResIdByAttributeId(Context context, int attrId) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(attrId, typedValue, true);
        return typedValue.resourceId;
    }

    public static Drawable getCommonWindowBg(Context context) {
        return context == null ? null : new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_window_bg_color)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
    }

    public static Drawable getBiggerHalfCornerWindowBg(Context context) {
        return context == null ? null : new DrawableBuilder().rectangle().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_window_bg_color)).cornerRadii(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bigger_bg_radius), context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bigger_bg_radius), 0, 0).build();
    }

    public static Drawable getBiggerHalfCornerWindowBg(Context context, boolean showRightToLeft) {
        int topLeftRadius = 0;
        int topRightRadius = 0;
        int bottomRightRadius = 0;
        int bottomLeftRadius = 0;
        if (showRightToLeft) {
            bottomLeftRadius = topLeftRadius = context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bigger_bg_radius);
        } else {
            topRightRadius = topLeftRadius = context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bigger_bg_radius);
        }
        return new DrawableBuilder().rectangle().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_window_bg_color)).cornerRadii(topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius).build();
    }

    public static Drawable getPopWindowBg(Context context) {
        return context == null ? null : new DrawableBuilder().rectangle().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_window_bg_color)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bigger_bg_radius)).strokeWidth(1).strokeColor(ContextCompat.getColor((Context)context, (int)R.color.base_bg_stroke)).build();
    }

    public static Drawable getCommonWindowBgWithBorder(Context context) {
        return context == null ? null : new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_window_bg_color)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).strokeWidth(1).strokeColor(ContextCompat.getColor((Context)context, (int)R.color.base_bg_stroke)).build();
    }

    public static Drawable getDrawableProductButtonBg(Context context) {
        return context == null ? null : new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_live_product_color)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
    }

    public static Drawable getDrawableNegativeButtonBg(Context context) {
        return context == null ? null : new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_dialog_negative_bg_color)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
    }

    public static Drawable getUserTagBg(Context context) {
        return context == null ? null : new DrawableBuilder().cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).strokeColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_live_product_color)).strokeWidth(UtilsKt.getDp((int)1)).build();
    }

    public static Drawable getCustomLabelBg(Context context, int color2) {
        return context == null ? null : new DrawableBuilder().cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).solidColor(color2).build();
    }

    public static Drawable getEnableProductBgWithCorner(Context context) {
        return context == null ? null : new DrawableBuilder().solidColorStateList(ThemeDataUtil.getColorEnableProduct2NegativeBG(context)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
    }

    public static ColorStateList getColorCheckWhite2MainText(Context context) {
        if (context == null) {
            return new ColorStateList((int[][])new int[0][], new int[]{0});
        }
        return new ColorStateList((int[][])new int[][]{{0x10100A0}, {-16842912}}, new int[]{ContextCompat.getColor((Context)context, (int)R.color.base_white), ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_window_main_text_color)});
    }

    public static ColorStateList getColorSelectProduct2MainText(Context context) {
        if (context == null) {
            return new ColorStateList((int[][])new int[0][], new int[]{0});
        }
        return new ColorStateList((int[][])new int[][]{{0x10100A1}, {-16842913}}, new int[]{ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_live_product_color), ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_window_main_text_color)});
    }

    public static ColorStateList getColorSelectWhite2MainText(Context context) {
        if (context == null) {
            return new ColorStateList((int[][])new int[0][], new int[]{0});
        }
        return new ColorStateList((int[][])new int[][]{{0x10100A1}, {-16842913}}, new int[]{ContextCompat.getColor((Context)context, (int)R.color.base_white), ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_window_main_text_color)});
    }

    public static ColorStateList getColorSelectMainText2Warning(Context context) {
        if (context == null) {
            return new ColorStateList((int[][])new int[0][], new int[]{0});
        }
        return new ColorStateList((int[][])new int[][]{{0x10100A1}, {-16842913}}, new int[]{ContextCompat.getColor((Context)context, (int)R.color.base_warning_color), ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_window_main_text_color)});
    }

    public static ColorStateList getColorEnableProduct2NegativeBG(Context context) {
        if (context == null) {
            return new ColorStateList((int[][])new int[0][], new int[]{0});
        }
        return new ColorStateList((int[][])new int[][]{{16842910}, {-16842910}}, new int[]{ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_live_product_color), ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_dialog_negative_bg_color)});
    }

    public static ColorStateList getColorEnableWhite2NegativeText(Context context) {
        if (context == null) {
            return new ColorStateList((int[][])new int[0][], new int[]{0});
        }
        return new ColorStateList((int[][])new int[][]{{16842910}, {-16842910}}, new int[]{ContextCompat.getColor((Context)context, (int)R.color.base_white), ThemeDataUtil.getColorFromThemeConfigByAttrId(context, R.attr.base_theme_dialog_negative_text_color)});
    }
}

