/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.livebase.utils.ScreenshotService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ScreenshotUtil {
    private static final String TAG = ScreenshotUtil.class.getSimpleName();
    private final SoftReference<Context> mRefContext;
    private final ImageReader mImageReader;
    private final MediaProjection mMediaProjection;
    private VirtualDisplay mVirtualDisplay;
    private OnShotListener mOnShotListener;
    private final int mHeight;
    private final int mWidth;
    private String mLocalUrl = "";
    private boolean isSaveToGallery;
    private MediaProjection.Callback mMediaProjectionCallback = new MediaProjection.Callback(){

        public void onStop() {
            super.onStop();
            LPLogger.e((String)"Screenshot onStop");
        }
    };

    private String getSavedPath() {
        if (TextUtils.isEmpty((CharSequence)this.mLocalUrl)) {
            this.mLocalUrl = this.getContext().getExternalFilesDir("screenshot").getAbsoluteFile() + "/" + System.currentTimeMillis() + ".png";
        }
        return this.mLocalUrl;
    }

    public ScreenshotUtil(Context context, int reqCode, Intent data) {
        this.mRefContext = new SoftReference<Context>(context);
        this.mMediaProjection = this.getMediaProjectionManager().getMediaProjection(reqCode, data);
        this.mMediaProjection.registerCallback(this.mMediaProjectionCallback, null);
        WindowManager window = (WindowManager)context.getSystemService("window");
        Display mDisplay = window.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        mDisplay.getRealMetrics(metrics);
        this.mWidth = metrics.widthPixels;
        this.mHeight = metrics.heightPixels;
        this.mImageReader = ImageReader.newInstance((int)this.mWidth, (int)this.mHeight, (int)1, (int)1);
    }

    public static void startService(Context context) {
        Intent intent = new Intent(context, ScreenshotService.class);
        if (Build.VERSION.SDK_INT > 26) {
            context.startForegroundService(intent);
        } else {
            context.startService(intent);
        }
    }

    private void stopService(Context context) {
        context.stopService(new Intent(context, ScreenshotService.class));
    }

    public void setSaveToGallery(boolean saveToGallery) {
        this.isSaveToGallery = saveToGallery;
    }

    private void virtualDisplay() {
        this.mVirtualDisplay = this.mMediaProjection.createVirtualDisplay("screen-mirror", this.mWidth, this.mHeight, Resources.getSystem().getDisplayMetrics().densityDpi, 16, this.mImageReader.getSurface(), null, null);
    }

    public void startScreenShot(String savedPath, OnShotListener onShotListener) {
        this.mLocalUrl = savedPath;
        this.startScreenShot(onShotListener);
    }

    public void startScreenShot(OnShotListener onShotListener) {
        this.mOnShotListener = onShotListener;
        this.virtualDisplay();
        Handler handler = new Handler();
        handler.postDelayed(() -> {
            Image image = this.mImageReader.acquireLatestImage();
            new SaveTask().doInBackground(image);
        }, 300L);
    }

    public void release() {
        this.stopService(this.getContext());
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
        }
        if (this.mMediaProjection != null) {
            this.mMediaProjection.stop();
        }
    }

    private MediaProjectionManager getMediaProjectionManager() {
        return (MediaProjectionManager)this.getContext().getSystemService("media_projection");
    }

    private Context getContext() {
        return this.mRefContext.get();
    }

    public static interface OnShotListener {
        public void onFinish(String var1);

        public void onError();
    }

    public class SaveTask
    extends AsyncTask<Image, Void, Bitmap> {
        protected Bitmap doInBackground(Image ... params) {
            if (params == null || params.length < 1 || params[0] == null) {
                return null;
            }
            Image image = params[0];
            int width = image.getWidth();
            int height = image.getHeight();
            Image.Plane[] planes = image.getPlanes();
            ByteBuffer buffer = planes[0].getBuffer();
            int pixelStride = planes[0].getPixelStride();
            int rowStride = planes[0].getRowStride();
            int rowPadding = rowStride - pixelStride * width;
            Bitmap bitmap = Bitmap.createBitmap((int)(width + rowPadding / pixelStride), (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)buffer);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height);
            image.close();
            if (bitmap != null) {
                try {
                    File fileImage = new File(ScreenshotUtil.this.getSavedPath());
                    if (!fileImage.exists()) {
                        fileImage.createNewFile();
                    }
                    FileOutputStream out = new FileOutputStream(fileImage);
                    bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)out);
                    out.flush();
                    out.close();
                    if (ScreenshotUtil.this.isSaveToGallery) {
                        MediaStore.Images.Media.insertImage((ContentResolver)ScreenshotUtil.this.getContext().getContentResolver(), (String)ScreenshotUtil.this.getSavedPath(), (String)fileImage.getName(), null);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (ScreenshotUtil.this.mOnShotListener != null) {
                        ScreenshotUtil.this.mOnShotListener.onError();
                    }
                    ScreenshotUtil.this.release();
                    return null;
                }
            }
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            if (ScreenshotUtil.this.mVirtualDisplay != null) {
                ScreenshotUtil.this.mVirtualDisplay.release();
            }
            if (ScreenshotUtil.this.mMediaProjection != null) {
                ScreenshotUtil.this.mMediaProjection.stop();
            }
            if (ScreenshotUtil.this.mOnShotListener != null) {
                ScreenshotUtil.this.mOnShotListener.onFinish(ScreenshotUtil.this.getSavedPath());
            }
            ScreenshotUtil.this.stopService(ScreenshotUtil.this.getContext());
            return null;
        }

        protected void onPostExecute(Bitmap bitmap) {
            super.onPostExecute((Object)bitmap);
        }
    }
}

