/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils;

import java.util.LinkedList;

public class LimitedQueue<E>
extends LinkedList<E> {
    private int limit;

    public LimitedQueue(int limit) {
        this.limit = limit;
    }

    @Override
    public boolean add(E e) {
        boolean isAdded = super.add(e);
        while (isAdded && this.size() > this.limit) {
            super.poll();
        }
        return isAdded;
    }

    public double getAverage() {
        double sum = 0.0;
        for (Object element : this) {
            if (!(element instanceof Double)) continue;
            sum += ((Double)element).doubleValue();
        }
        return sum / (double)this.size();
    }
}

