/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils;

import com.baijiayun.livebase.network.BJYWSServer;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import java.util.ArrayList;

public class LPWSResponseEmitterFlowable<T>
implements FlowableOnSubscribe<T> {
    private BJYWSServer server;
    private String responseKey;
    private Class<T> clazz;
    private boolean supportSmallBlackboard;
    private ArrayList<FlowableEmitter<T>> flowableEmitterList;

    public LPWSResponseEmitterFlowable(BJYWSServer server, Class clazz, String responseKey) {
        this(server, clazz, responseKey, false);
    }

    public LPWSResponseEmitterFlowable(BJYWSServer server, Class clazz, String responseKey, boolean supportSmallBlackboard) {
        this.server = server;
        this.responseKey = responseKey;
        this.clazz = clazz;
        this.supportSmallBlackboard = supportSmallBlackboard;
        this.flowableEmitterList = new ArrayList();
    }

    public void subscribe(FlowableEmitter<T> flowableEmitter) {
        this.flowableEmitterList.add(flowableEmitter);
        BJYWSServer.OnResponseModelListener listener = new BJYWSServer.OnResponseModelListener<T>(){

            @Override
            public void onResponseModel(T model) {
                for (FlowableEmitter fe : LPWSResponseEmitterFlowable.this.flowableEmitterList) {
                    fe.onNext(model);
                }
            }

            @Override
            public void onError(Exception e) {
                for (FlowableEmitter fe : LPWSResponseEmitterFlowable.this.flowableEmitterList) {
                    fe.onError((Throwable)e);
                }
            }
        };
        this.server.registerResponseListenerAndModel(this.clazz, listener, this.responseKey);
        if (this.supportSmallBlackboard) {
            this.server.registerResponseListenerAndModel(this.clazz, listener, "s_" + this.responseKey);
        }
        flowableEmitter.setCancellable(() -> {
            flowableEmitter.onComplete();
            this.flowableEmitterList.remove(flowableEmitter);
            if (this.flowableEmitterList.isEmpty()) {
                this.server.unregisterResponseListener(this.responseKey);
                if (this.supportSmallBlackboard) {
                    this.server.unregisterResponseListener("s_" + this.responseKey);
                }
            }
        });
    }
}

