/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils;

import java.net.URLDecoder;
import java.util.HashMap;

public class LPBJUrl {
    private String mProtocol;
    private String mHost;
    private String mPath;
    private HashMap<String, String> mParameter;

    private static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static LPBJUrl parse(String urlString) {
        return LPBJUrl.parse(urlString, false);
    }

    public static LPBJUrl parse(String urlString, boolean needDecode) {
        int param_index;
        int protocol_index;
        if (LPBJUrl.isEmpty(urlString)) {
            return null;
        }
        if (!urlString.contains("://")) {
            urlString = "http://" + urlString;
        }
        if ((protocol_index = urlString.indexOf("://")) <= 0) {
            throw new IllegalArgumentException();
        }
        LPBJUrl url = new LPBJUrl();
        url.mProtocol = urlString.substring(0, protocol_index);
        int host_index = urlString.indexOf("/", protocol_index + 3);
        String host = host_index < 0 ? ((param_index = urlString.indexOf("?", protocol_index + 3)) < 0 ? urlString.substring(protocol_index + 3) : urlString.substring(protocol_index + 3, param_index)) : urlString.substring(protocol_index + 3, host_index);
        host_index = protocol_index + 3 + host.length() - 1;
        url.mHost = host;
        int path_index = urlString.indexOf("?");
        if (path_index < 0 || path_index < host_index) {
            path_index = urlString.length();
        }
        url.mPath = urlString.substring(host_index + 1, path_index);
        if (path_index < 0 || path_index >= urlString.length()) {
            return url;
        }
        url.mParameter = LPBJUrl.anaylizeUrlParameters(urlString.substring(path_index + 1), needDecode);
        return url;
    }

    private static HashMap<String, String> anaylizeUrlParameters(String parameterString, boolean needDecode) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (LPBJUrl.isEmpty(parameterString) || parameterString.length() < 1) {
            return parameters;
        }
        if (needDecode) {
            parameterString = URLDecoder.decode(parameterString);
        }
        if (parameterString.startsWith("&")) {
            parameterString = parameterString.substring(1);
        }
        int start_index = 0;
        int end_index = parameterString.indexOf("=");
        while (end_index > 0 && end_index < parameterString.length()) {
            String value;
            String key = parameterString.substring(start_index, end_index);
            start_index = end_index + 1;
            if ((end_index = parameterString.indexOf("&", start_index)) < 0) {
                value = parameterString.substring(start_index);
            } else {
                value = parameterString.substring(start_index, end_index);
                start_index = end_index + 1;
                end_index = parameterString.indexOf("=", start_index);
            }
            parameters.put(key, value);
        }
        return parameters;
    }

    public static LPBJUrl parseQuery(String query) {
        return LPBJUrl.parseQuery(query, false);
    }

    public static LPBJUrl parseQuery(String query, boolean needDecode) {
        LPBJUrl url = new LPBJUrl();
        url.mParameter = LPBJUrl.anaylizeUrlParameters(query, needDecode);
        return url;
    }

    public String getProtocol() {
        return this.mProtocol;
    }

    public String getHost() {
        return this.mHost;
    }

    public String getPath() {
        return this.mPath;
    }

    public HashMap<String, String> getParameters() {
        return this.mParameter;
    }

    public String toString() {
        return "[PROTOCOL:" + this.mProtocol + " HOST:" + this.mHost + " PATH:" + this.mPath + " PARAMETERS:" + this.mParameter + "]";
    }
}

