/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.baijiayun.bjyutils.log.LPLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;

public class FileUtils {
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int GB = 0x40000000;
    private static final String[][] MIME_MapTable = new String[][]{{".3gp", "video/3gpp"}, {".asf", "video/x-ms-asf"}, {".avi", "video/x-msvideo"}, {".bin", "application/octet-stream"}, {".bmp", "image/bmp"}, {".c", "text/plain"}, {".class", "application/octet-stream"}, {".conf", "text/plain"}, {".cpp", "text/plain"}, {".doc", "application/msword"}, {".docx", "application/msword"}, {".exe", "application/octet-stream"}, {".gif", "image/gif"}, {".gtar", "application/x-gtar"}, {".gz", "application/x-gzip"}, {".h", "text/plain"}, {".htm", "text/html"}, {".html", "text/html"}, {".jar", "application/java-archive"}, {".java", "text/plain"}, {".jpeg", "image/jpeg"}, {".JPEG", "image/jpeg"}, {".jpg", "image/jpeg"}, {".js", "application/x-javascript"}, {".log", "text/plain"}, {".m3u", "audio/x-mpegurl"}, {".m4a", "audio/mp4a-latm"}, {".m4b", "audio/mp4a-latm"}, {".m4p", "audio/mp4a-latm"}, {".m4u", "video/vnd.mpegurl"}, {".m4v", "video/x-m4v"}, {".mov", "video/quicktime"}, {".mp2", "audio/x-mpeg"}, {".mp3", "audio/x-mpeg"}, {".mp4", "video/mp4"}, {".mpc", "application/vnd.mpohun.certificate"}, {".mpe", "video/mpeg"}, {".mpeg", "video/mpeg"}, {".mpg", "video/mpeg"}, {".mpg4", "video/mp4"}, {".mpga", "audio/mpeg"}, {".msg", "application/vnd.ms-outlook"}, {".ogg", "audio/ogg"}, {".pdf", "application/pdf"}, {".png", "image/png"}, {".pps", "application/vnd.ms-powerpoint"}, {".ppt", "application/vnd.ms-powerpoint"}, {".pptx", "application/vnd.ms-powerpoint"}, {".prop", "text/plain"}, {".rar", "application/x-rar-compressed"}, {".rc", "text/plain"}, {".rmvb", "audio/x-pn-realaudio"}, {".rtf", "application/rtf"}, {".sh", "text/plain"}, {".tar", "application/x-tar"}, {".tgz", "application/x-compressed"}, {".txt", "text/plain"}, {".wav", "audio/x-wav"}, {".wma", "audio/x-ms-wma"}, {".wmv", "audio/x-ms-wmv"}, {".wps", "application/vnd.ms-works"}, {".xml", "text/plain"}, {".z", "application/x-compress"}, {".zip", "application/zip"}, {"", "*/*"}};

    public static String getPath(Context context, Uri uri) {
        if (Build.VERSION.SDK_INT < 29 && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (FileUtils.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    if (id2.contains(":")) {
                        return id2.split(":")[1];
                    }
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.parseLong(id2));
                    return FileUtils.getFileFromContentUri(context, contentUri, null, null).getAbsolutePath();
                }
                if (FileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileUtils.getFileFromContentUri(context, contentUri, "_id=?", selectionArgs).getAbsolutePath();
                }
            }
        } else {
            if (Build.VERSION.SDK_INT > 29) {
                return FileUtils.getFileFromContentUriApiQ(context, uri);
            }
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                return FileUtils.getFileFromContentUri(context, uri, null, null).getAbsolutePath();
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileFromContentUriApiQ(Context context, Uri uri) {
        ContentResolver contentResolver;
        Cursor cursor;
        File file = null;
        if (uri.getScheme().equals("file")) {
            file = new File(uri.getPath());
        } else if (uri.getScheme().equals("content") && (cursor = (contentResolver = context.getContentResolver()).query(uri, null, null, null, null)) != null && cursor.moveToFirst()) {
            String displayName = cursor.getString(cursor.getColumnIndex("_display_name"));
            try {
                InputStream is = contentResolver.openInputStream(uri);
                File file1 = new File(context.getExternalCacheDir().getAbsolutePath() + "/" + System.currentTimeMillis());
                if (!file1.exists()) {
                    file1.mkdir();
                }
                File cache = new File(file1.getPath(), displayName);
                FileOutputStream fos = new FileOutputStream(cache);
                android.os.FileUtils.copy((InputStream)is, (OutputStream)fos);
                file = cache;
                fos.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                cursor.close();
            }
        }
        if (file == null) {
            return "";
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    private static File getFileFromContentUri(Context context, Uri contentUri, String selection, String[] selectionArgs) {
        if (contentUri == null) {
            return null;
        }
        File file = null;
        String filePath = "";
        String fileName = "unkown";
        String[] filePathColumn = new String[]{"_data", "_display_name"};
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(contentUri, filePathColumn, selection, selectionArgs, null);
        if (cursor != null) {
            cursor.moveToFirst();
            int pathIndex = cursor.getColumnIndex(filePathColumn[0]);
            int fileNameIndex = cursor.getColumnIndex(filePathColumn[1]);
            if (pathIndex >= 0) {
                filePath = cursor.getString(pathIndex);
            }
            if (fileNameIndex >= 0) {
                fileName = cursor.getString(fileNameIndex);
            }
            cursor.close();
            if (!TextUtils.isEmpty((CharSequence)filePath)) {
                file = new File(filePath);
            }
            if (file == null || !file.exists() || file.length() <= 0L || TextUtils.isEmpty((CharSequence)filePath)) {
                filePath = FileUtils.getPathFromInputStreamUri(context, contentUri, fileName);
            }
            if (!TextUtils.isEmpty((CharSequence)filePath)) {
                file = new File(filePath);
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPathFromInputStreamUri(Context context, Uri uri, String fileName) {
        InputStream inputStream = null;
        String filePath = null;
        if (uri.getAuthority() != null) {
            try {
                inputStream = context.getContentResolver().openInputStream(uri);
                File file = FileUtils.createTemporalFileFrom(context, inputStream, fileName);
                filePath = file.getPath();
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return filePath;
    }

    private static File createTemporalFileFrom(Context context, InputStream inputStream, String fileName) {
        File targetFile = null;
        File cacheDir = FileUtils.getFileUploadDir(context);
        cacheDir.mkdirs();
        if (inputStream != null) {
            byte[] buffer = new byte[8192];
            targetFile = new File(cacheDir, fileName);
            if (targetFile.exists()) {
                targetFile.delete();
            }
            try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
                int read;
                while ((read = inputStream.read(buffer)) != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, read);
                }
                outputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return targetFile;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static File getFileUploadDir(Context context) {
        return new File(context.getCacheDir(), "bjy_upload_temp");
    }

    public static void safeDeleteFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        File renameFile = new File(file.getAbsolutePath() + System.currentTimeMillis());
        if (file.renameTo(renameFile)) {
            FileUtils.deleteFile(renameFile);
        } else {
            FileUtils.deleteFile(file);
        }
    }

    private static void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                FileUtils.deleteFile(f);
            }
            file.delete();
        } else if (file.exists()) {
            file.delete();
        }
    }

    public static boolean checkAnimFilePathValid(String pathOrName) {
        return FileUtils.checkPathContainsSuffix(pathOrName, new String[]{"ppt", "pptx"});
    }

    public static boolean checkStaticFilePathValid(String pathOrName) {
        return FileUtils.checkPathContainsSuffix(pathOrName, new String[]{"ppt", "doc", "pptx", "pdf", "docx", "png", "jpg", "jpeg", "webp", "bmp", "zip", "bjon", "bds"});
    }

    public static boolean checkPreviewFileValid(String pathOrName) {
        return FileUtils.checkPathContainsSuffix(pathOrName, new String[]{"ppt", "pptx", "doc", "docx", "pdf"});
    }

    private static boolean checkPathContainsSuffix(String pathOrName, String[] canPlayTypes) {
        if (TextUtils.isEmpty((CharSequence)pathOrName) || !pathOrName.contains(".")) {
            return false;
        }
        for (String canPlayType : canPlayTypes) {
            if (!pathOrName.endsWith(canPlayType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImageFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return path.endsWith("png") || path.endsWith("jpg") || path.endsWith("jpeg") || path.endsWith("gif") || path.endsWith("webp");
    }

    public static String getMimeType(String fileName) {
        for (int i = 0; i < MIME_MapTable.length; ++i) {
            if (!fileName.endsWith(MIME_MapTable[i][0])) continue;
            return MIME_MapTable[i][1];
        }
        return "*/*";
    }

    public static void copy(String filename, byte[] bytes) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            try (FileOutputStream output = new FileOutputStream(filename);){
                output.write(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            LPLogger.i((String)("copy:fail, " + filename));
        }
    }

    public static void copy(File source, File target) {
        try (FileInputStream fileInputStream = new FileInputStream(source);
             FileOutputStream fileOutputStream = new FileOutputStream(target);){
            byte[] buffer = new byte[1024];
            while (fileInputStream.read(buffer) > 0) {
                fileOutputStream.write(buffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String fileName, long pos, String insertContent) throws IOException {
        RandomAccessFile raf = null;
        File tmp = File.createTempFile("tmp", null);
        FileOutputStream tmpOut = null;
        FileInputStream tmpIn = null;
        tmp.deleteOnExit();
        try {
            raf = new RandomAccessFile(fileName, "rw");
            tmpOut = new FileOutputStream(tmp);
            tmpIn = new FileInputStream(tmp);
            raf.seek(pos);
            byte[] bbuf = new byte[64];
            int hasRead = 0;
            while ((hasRead = raf.read(bbuf)) > 0) {
                tmpOut.write(bbuf, 0, hasRead);
            }
            raf.seek(pos);
            raf.write(insertContent.getBytes());
            while ((hasRead = tmpIn.read(bbuf)) > 0) {
                raf.write(bbuf, 0, hasRead);
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    public static long sizeOfDirectory(File directory) {
        FileUtils.checkDirectory(directory);
        return FileUtils.sizeOfDirectory0(directory);
    }

    private static boolean checkDirectory(File directory) {
        if (!directory.exists()) {
            return false;
        }
        return directory.isDirectory();
    }

    private static long sizeOfDirectory0(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return 0L;
        }
        long size = 0L;
        for (File file : files) {
            if (!FileUtils.isSymlink(file) && (size += FileUtils.sizeOf0(file)) < 0L) break;
        }
        return size;
    }

    private static boolean isSymlink(File file) {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return Files.isSymbolicLink(file.toPath());
        }
        return false;
    }

    private static long sizeOf0(File file) {
        return file.isDirectory() ? FileUtils.sizeOfDirectory0(file) : file.length();
    }

    public static String byte2FitMemorySize(long byteNum) {
        if (byteNum < 0L) {
            return "";
        }
        if (byteNum < 1024L) {
            return String.format("%.1fB", byteNum);
        }
        if (byteNum < 0x100000L) {
            return String.format("%.1fKB", (double)byteNum / 1024.0);
        }
        if (byteNum < 0x40000000L) {
            return String.format("%.1fMB", (double)byteNum / 1048576.0);
        }
        return String.format("%.1fGB", (double)byteNum / 1.073741824E9);
    }
}

