/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils;

import android.content.Context;
import android.text.TextUtils;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.utils.LPBJUrl;
import java.util.HashMap;

public class AliCloudImageUtil {
    public static final String SCALED_MFIT = "m_mfit";
    public static final String SCALED_LFIT = "m_lfit";
    public static final String SCALED_FILL = "m_fill";
    public static final String SCALED_FIXED = "m_fixed";

    private static String _getScaledUrl(String url, String model, int width, int height) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        String urlSplit = url.split("\\?")[0];
        if (urlSplit.endsWith(".jpg") || urlSplit.endsWith(".jpeg") || urlSplit.endsWith(".png") || urlSplit.endsWith(".webp") || urlSplit.endsWith(".bmp") || urlSplit.endsWith(".gif")) {
            if (!url.contains("?")) {
                url = url + "?x-oss-process=image/resize," + model + ",h_" + height + ",w_" + width + "/format" + AliCloudImageUtil.imageUrlSuffix();
                return url;
            }
            if (url.contains("x-oss-process")) {
                HashMap<String, String> hashMap = LPBJUrl.parse(url).getParameters();
                return url.replace(hashMap.get("x-oss-process"), "image/resize," + model + ",h_" + height + ",w_" + width + "/format" + AliCloudImageUtil.imageUrlSuffix());
            }
            StringBuilder stringBuilder = new StringBuilder(url);
            stringBuilder.insert(url.indexOf("?") + 1, "x-oss-process=image/resize," + model + ",h_" + height + ",w_" + width + "/format" + AliCloudImageUtil.imageUrlSuffix() + "&");
            return stringBuilder.toString();
        }
        return url;
    }

    public static String getScaledUrl(String url, String model, int width, int height) {
        switch (model) {
            case "m_mfit": {
                return AliCloudImageUtil._getScaledUrl(url, SCALED_MFIT, width, height);
            }
            case "m_lfit": {
                return AliCloudImageUtil._getScaledUrl(url, SCALED_LFIT, width, height);
            }
            case "m_fill": {
                return AliCloudImageUtil._getScaledUrl(url, SCALED_FILL, width, height);
            }
            case "m_fixed": {
                return AliCloudImageUtil._getScaledUrl(url, SCALED_FIXED, width, height);
            }
        }
        return url;
    }

    public static String getRectScaledUrl(Context context, String url, int dp) {
        int px = UtilsKt.getDp((int)dp);
        String urlSplit = url.split("\\?")[0];
        if (urlSplit.endsWith(".jpg") || urlSplit.endsWith(".jpeg") || urlSplit.endsWith(".png") || urlSplit.endsWith(".webp") || urlSplit.endsWith(".bmp") || urlSplit.endsWith(".gif")) {
            if (!url.contains("?")) {
                url = url + "?x-oss-process=image/crop,w_" + px + ",h_" + px + "/format" + AliCloudImageUtil.imageUrlSuffix();
                return url;
            }
            if (url.contains("x-oss-process")) {
                HashMap<String, String> hashMap = LPBJUrl.parse(url).getParameters();
                return url.replace(hashMap.get("x-oss-process"), "image/crop,w_" + px + ",h_" + px + "/format" + AliCloudImageUtil.imageUrlSuffix());
            }
            StringBuilder stringBuilder = new StringBuilder(url);
            stringBuilder.insert(url.indexOf("?") + 1, "x-oss-process=image/crop,w_" + px + ",h_" + px + "/format" + AliCloudImageUtil.imageUrlSuffix() + "&");
            return stringBuilder.toString();
        }
        return url;
    }

    public static String getScreenScaledUrl(Context context, String url) {
        String urlSplit = url.split("\\?")[0];
        if (urlSplit.endsWith(".jpg") || urlSplit.endsWith(".jpeg") || urlSplit.endsWith(".png") || urlSplit.endsWith(".webp") || urlSplit.endsWith(".bmp") || urlSplit.endsWith(".gif")) {
            if (!url.contains("?")) {
                url = url + "?x-oss-process=image/crop,w_" + DisplayUtils.getScreenWidthPixels((Context)context) + ",h_" + DisplayUtils.getScreenHeightPixels((Context)context) + "/format" + AliCloudImageUtil.imageUrlSuffix();
                return url;
            }
            if (url.contains("x-oss-process")) {
                HashMap<String, String> hashMap = LPBJUrl.parse(url).getParameters();
                return url.replace(hashMap.get("x-oss-process"), "image/crop,w_" + DisplayUtils.getScreenWidthPixels((Context)context) + ",h_" + DisplayUtils.getScreenHeightPixels((Context)context) + "/format" + AliCloudImageUtil.imageUrlSuffix());
            }
            StringBuilder stringBuilder = new StringBuilder(url);
            stringBuilder.insert(url.indexOf("?") + 1, "x-oss-process=image/crop,w_" + DisplayUtils.getScreenWidthPixels((Context)context) + ",h_" + DisplayUtils.getScreenHeightPixels((Context)context) + "/format" + AliCloudImageUtil.imageUrlSuffix() + "&");
            return stringBuilder.toString();
        }
        return url;
    }

    @Deprecated
    public static String getRoundedAvatarUrl(String url, int radius) {
        String urlSplit = url.split("\\?")[0];
        if (urlSplit.endsWith(".jpg") || urlSplit.endsWith(".jpeg") || urlSplit.endsWith(".png") || urlSplit.endsWith(".webp") || urlSplit.endsWith(".bmp") || urlSplit.endsWith(".gif")) {
            if (!url.contains("?")) {
                url = url + "?x-oss-process=image/circle,r_" + radius + "/format" + AliCloudImageUtil.imageUrlSuffix();
                return url;
            }
            if (url.contains("x-oss-process")) {
                HashMap<String, String> hashMap = LPBJUrl.parse(url).getParameters();
                return url.replace(hashMap.get("x-oss-process"), "image/circle,r_" + radius + "/format" + AliCloudImageUtil.imageUrlSuffix());
            }
            StringBuilder stringBuilder = new StringBuilder(url);
            stringBuilder.insert(url.indexOf("?") + 1, "x-oss-process=image/circle,r_" + radius + "/format" + AliCloudImageUtil.imageUrlSuffix() + "&");
            return stringBuilder.toString();
        }
        return url;
    }

    public static String getCropRoundedAvatarUrl(String url, int width, int height, int radius) {
        String urlSplit = url.split("\\?")[0];
        if (urlSplit.endsWith(".jpg") || urlSplit.endsWith(".jpeg") || urlSplit.endsWith(".png") || urlSplit.endsWith(".webp") || urlSplit.endsWith(".bmp") || urlSplit.endsWith(".gif")) {
            if (!url.contains("?")) {
                url = url + "?x-oss-process=image/resize,m_fixed,h_" + height + ",w_" + width + "/crop,w_" + width + ",h_" + height + "/rounded-corners,r_" + radius + "/format" + AliCloudImageUtil.imageUrlSuffix();
                return url;
            }
            if (url.contains("x-oss-process")) {
                HashMap<String, String> hashMap = LPBJUrl.parse(url).getParameters();
                return url.replace(hashMap.get("x-oss-process"), "image/resize,m_fixed,h_" + height + ",w_" + width + "/crop,w_" + width + ",h_" + height + "/rounded-corners,r_" + radius + "/format" + AliCloudImageUtil.imageUrlSuffix());
            }
            StringBuilder stringBuilder = new StringBuilder(url);
            stringBuilder.insert(url.indexOf("?") + 1, "x-oss-process=image/resize,m_fixed,h_" + height + ",w_" + width + "crop,w_" + width + ",h_" + height + "/rounded-corners,r_" + radius + "/format" + AliCloudImageUtil.imageUrlSuffix() + "&");
            return stringBuilder.toString();
        }
        return url;
    }

    private static String imageUrlSuffix() {
        return ",png";
    }
}

