/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.models;

import android.text.TextUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.GroupItem;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.google.gson.annotations.SerializedName;
import java.util.Date;

public class LPUserModel
implements IUserModel {
    @SerializedName(value="id")
    public String userId;
    @SerializedName(value="number")
    public String number;
    @SerializedName(value="replace_user_number")
    public String replaceUserNumber;
    @SerializedName(value="user_number_replace_me")
    public String userNumberReplaceMe;
    @SerializedName(value="type")
    public LPConstants.LPUserType type;
    @SerializedName(value="name")
    public String name;
    @SerializedName(value="camera_cover")
    public String cameraCover;
    @SerializedName(value="avatar")
    public String avatar;
    @SerializedName(value="end_type", alternate={"endType"})
    public LPConstants.LPEndType endType;
    @SerializedName(value="status")
    public LPConstants.LPUserState status;
    @SerializedName(value="group")
    public int groupId;
    @SerializedName(value="session_id", alternate={"sessionId"})
    public String session;
    @SerializedName(value="is_audition", alternate={"isAudition"})
    public boolean isAudition;
    @SerializedName(value="audition_duration", alternate={"auditionDuration"})
    public int audition_duration;
    public GroupItem groupItem;
    public String ip;
    public Date joinTime;
    public transient boolean isForbidChat;
    @SerializedName(value="audio_state", alternate={"audioState"})
    public LPConstants.MediaState audioState;
    @SerializedName(value="video_state", alternate={"videoState"})
    public LPConstants.MediaState videoState;
    @SerializedName(value="video_fit")
    public int videoFit;
    public transient String extraInfo;
    public transient String customStr;

    public LPUserModel() {
    }

    public LPUserModel(String name, String avatar, LPConstants.LPUserType type) {
        this.name = LPUserModel.checkNull(name);
        this.avatar = LPUserModel.checkNull(avatar);
        this.type = type;
    }

    public void setUser(LPUserModel user) {
        this.userId = LPUserModel.checkNull(user.userId);
        this.number = LPUserModel.checkNull(user.number);
        this.type = user.type;
        this.name = LPUserModel.checkNull(user.name);
        this.avatar = LPUserModel.checkNull(user.avatar);
        this.endType = user.endType;
        this.status = user.status;
        this.videoFit = user.videoFit;
        this.cameraCover = LPUserModel.checkNull(user.cameraCover);
    }

    private static String checkNull(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        return value;
    }

    public LPUserModel(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LPUserModel) {
            LPUserModel temp = (LPUserModel)o;
            return TextUtils.equals((CharSequence)this.userId, (CharSequence)temp.userId) || TextUtils.equals((CharSequence)this.number, (CharSequence)temp.number);
        }
        return false;
    }

    public static LPUserModel newLPUserModel(IUserModel iUserModel) {
        LPUserModel model = new LPUserModel(iUserModel.getUserId());
        model.type = iUserModel.getType();
        model.name = LPUserModel.checkNull(iUserModel.getName());
        model.number = LPUserModel.checkNull(iUserModel.getNumber());
        model.avatar = LPUserModel.checkNull(iUserModel.getAvatar());
        model.endType = iUserModel.getEndType();
        return model;
    }

    public int hashCode() {
        return 31 * this.userId.hashCode();
    }

    public LPUserModel getUser() {
        return this;
    }

    public String toString() {
        return "LPUserModel{userId='" + this.userId + '\'' + ", number='" + this.number + '\'' + ", type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", avatar='" + this.avatar + '\'' + ", endType=" + (Object)((Object)this.endType) + ", status=" + (Object)((Object)this.status) + ", groupId=" + this.groupId + ", isForbidChat=" + this.isForbidChat + '}';
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getNumber() {
        return this.number;
    }

    @Override
    public String getReplaceNumber() {
        return this.replaceUserNumber;
    }

    @Override
    public String getUserNumberReplaceMe() {
        return this.userNumberReplaceMe;
    }

    @Override
    public boolean canReplaceOtherUser(IUserModel OtherUser) {
        return TextUtils.equals((CharSequence)this.getReplaceNumber(), (CharSequence)OtherUser.getNumber()) && TextUtils.equals((CharSequence)this.getNumber(), (CharSequence)OtherUser.getUserNumberReplaceMe());
    }

    @Override
    public LPConstants.LPUserType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAvatar() {
        return this.avatar;
    }

    @Override
    public int getGroup() {
        return this.groupId;
    }

    @Override
    public LPConstants.LPEndType getEndType() {
        return this.endType;
    }
}

