/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.base;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.baijiayun.bjyutils.query.QueryPlus;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.livebase.base.BasePresenter;

public abstract class BaseFragment
extends Fragment
implements View.OnTouchListener {
    private final String TAG = BaseFragment.class.getCanonicalName();
    protected View view;
    protected QueryPlus $;
    private BasePresenter basePresenter;

    @NonNull
    public LayoutInflater onGetLayoutInflater(@Nullable Bundle savedInstanceState) {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            return activity.getLayoutInflater();
        }
        return super.onGetLayoutInflater(savedInstanceState);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int res = this.getLayoutId();
        this.view = res == 0 ? this.getContentView() : inflater.inflate(res, container, false);
        this.$ = QueryPlus.with((View)this.view);
        this.init(savedInstanceState);
        if (this.basePresenter != null) {
            this.basePresenter.subscribe();
        }
        return this.view;
    }

    public abstract int getLayoutId();

    protected void init(Bundle savedInstanceState) {
    }

    protected View getContentView() {
        return null;
    }

    public void setBasePresenter(BasePresenter presenter) {
        this.basePresenter = presenter;
    }

    public boolean onTouch(View v, MotionEvent event) {
        return false;
    }

    protected void showToast(String msg) {
        if (this.getActivity() == null || this.getActivity().isDestroyed()) {
            return;
        }
        ToastCompat.showToastCenter((Context)this.getContext(), (CharSequence)msg, (int)0);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.basePresenter != null) {
            this.basePresenter.unSubscribe();
            this.basePresenter.destroy();
            this.basePresenter = null;
        }
        this.$ = null;
    }
}

