/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.util.UUID;

public class DeviceUuidFactory {
    private static final String PREFS_FILE = "device_id.xml";
    private static final String PREFS_DEVICE_ID = "device_id";
    private static UUID uuid;

    public static DeviceUuidFactory getInstance() {
        return SingletonHolder.instance;
    }

    private DeviceUuidFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getDeviceUuid(Context context) {
        Class<DeviceUuidFactory> clazz = DeviceUuidFactory.class;
        synchronized (DeviceUuidFactory.class) {
            if (uuid == null) {
                SharedPreferences prefs = context.getSharedPreferences(PREFS_FILE, 0);
                String id2 = prefs.getString(PREFS_DEVICE_ID, null);
                if (!TextUtils.isEmpty((CharSequence)id2)) {
                    uuid = UUID.fromString(id2);
                } else {
                    uuid = UUID.randomUUID();
                    prefs.edit().putString(PREFS_DEVICE_ID, uuid.toString()).apply();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return uuid;
        }
    }

    public static final class SingletonHolder {
        private static final DeviceUuidFactory instance = new DeviceUuidFactory();

        private SingletonHolder() {
        }
    }
}

