/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyutils.kt;

import android.app.Activity;
import android.app.ActivityManager;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.media.AudioManager;
import android.media.SoundPool;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.Editable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.EditText;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00132\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0013\u001a\u0012\u0010\u0015\u001a\u00020\u00112\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017\u001a\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0004\u001a\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007\u001a\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!\u001a\u0018\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010\u0007\u001a\u0010\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010\u0007\u001a\u0010\u0010'\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010\u0007\u001a\u000e\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0004\u001a\u0012\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-\u001a\u000e\u0010.\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u000e\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u000201\u001a\u0010\u00102\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u001a\u0010\u00103\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u001a\u001c\u00104\u001a\u00020\u0011\"\u0004\b\u0000\u001052\u000e\u00106\u001a\n\u0012\u0004\u0012\u0002H5\u0018\u00010\u0013\u001a\u001c\u00107\u001a\u00020\u0011\"\u0004\b\u0000\u001052\u000e\u00108\u001a\n\u0012\u0004\u0012\u0002H5\u0018\u000109\u001a\u0010\u0010:\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u001a\u000e\u0010;\u001a\u00020\u00112\u0006\u0010<\u001a\u00020=\u001a\u0010\u0010>\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u001a\u0010\u0010?\u001a\u00020\u00112\b\u0010@\u001a\u0004\u0018\u00010\u0007\u001a\u0010\u0010A\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u001a\u000e\u0010B\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0007\u001a\u000e\u0010C\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0010\u0010D\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u001a\u0016\u0010E\u001a\u00020F2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010G\u001a\u00020\u0004\u001a\u0010\u0010H\u001a\u00020\u001f2\b\u0010,\u001a\u0004\u0018\u00010-\u001a\u0018\u0010I\u001a\u00020\u001f2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010J\u001a\u00020\u0004\u001a\u0018\u0010K\u001a\u00020\u001f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010L\u001a\u00020\u0007\u001a\n\u0010M\u001a\u00020\u0011*\u00020N\u001a\u0012\u0010O\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040P*\u00020-\u001a\u0012\u0010Q\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0000\u001a\u00020\u0004*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0004*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0003\u00a8\u0006R"}, d2={"dp", "", "getDp", "(F)F", "", "(I)I", "int", "", "getInt", "(Ljava/lang/String;)I", "long", "", "getLong", "(Ljava/lang/String;)J", "two", "getTwo", "areListsEqual", "", "list1", "", "list2", "checkMainThread", "observer", "Lio/reactivex/Observer;", "convertLikeCount", "likeCount", "copy", "context", "Landroid/content/Context;", "copyStr", "deleteLastChar", "", "editText", "Landroid/widget/EditText;", "filterEmoji", "source", "slipStr", "getEncodeName", "originName", "getEncodePhoneNumber", "getFormatterTime", "timeSeconds", "getParentViewGroup", "Landroid/view/ViewGroup;", "view", "Landroid/view/View;", "getTotalMemory", "immersiveStatusBar", "window", "Landroid/view/Window;", "isAppForeground", "isBluetoothEnable", "isEmptyList", "V", "sourceList", "isEmptySet", "sourceSet", "", "isFocus", "isInMultiMode", "activity", "Landroid/app/Activity;", "isMobileData", "isMobileNumber", "mobiles", "isNetworkAvailable", "isOnlyEmojis", "isOrientationLandscape", "isWifiConnected", "playAudio", "Landroid/media/SoundPool;", "resId", "removeViewFromParent", "setStatusBarWithTheme", "attrColor", "startActivityByUrl", "url1", "canShowDialog", "Landroidx/fragment/app/Fragment;", "clicks", "Lio/reactivex/Observable;", "sp", "android-utils_release"})
public final class UtilsKt {
    public static final float getDp(float $this$dp) {
        return TypedValue.applyDimension((int)1, (float)$this$dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static final int getDp(int $this$dp) {
        return (int)TypedValue.applyDimension((int)1, (float)$this$dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static final int sp(int $this$sp, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)((float)$this$sp * fontScale + 0.5f);
    }

    public static final float getTwo(float $this$two) {
        return (float)((int)($this$two * (float)100)) / 100.0f;
    }

    public static final int getInt(@NotNull String $this$int) {
        Intrinsics.checkNotNullParameter((Object)$this$int, (String)"<this>");
        return TextUtils.isEmpty((CharSequence)$this$int) ? 0 : Integer.parseInt($this$int);
    }

    public static final long getLong(@NotNull String $this$long) {
        Intrinsics.checkNotNullParameter((Object)$this$long, (String)"<this>");
        return TextUtils.isEmpty((CharSequence)$this$long) ? 0L : Long.parseLong($this$long);
    }

    public static final void removeViewFromParent(@Nullable View view) {
        View view2 = view;
        Object object = view2 != null ? view2.getParent() : null;
        if (object == null) {
            return;
        }
        ViewParent viewParent = object;
        if (viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(view);
        }
    }

    @Nullable
    public static final ViewGroup getParentViewGroup(@Nullable View view) {
        ViewGroup viewGroup;
        View view2 = view;
        if ((view2 != null ? view2.getParent() : null) != null && view.getParent() instanceof ViewGroup) {
            ViewParent viewParent = view.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            viewGroup = (ViewGroup)viewParent;
        } else {
            viewGroup = null;
        }
        return viewGroup;
    }

    public static final boolean canShowDialog(@NotNull Fragment $this$canShowDialog) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$canShowDialog, (String)"<this>");
        FragmentActivity fragmentActivity = $this$canShowDialog.getActivity();
        if (fragmentActivity != null) {
            FragmentActivity $this$canShowDialog_u24lambda_u240 = fragmentActivity;
            boolean bl2 = false;
            bl = !$this$canShowDialog_u24lambda_u240.isFinishing() && !$this$canShowDialog_u24lambda_u240.isDestroyed();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isMobileNumber(@Nullable String mobiles) {
        Matcher m;
        Matcher matcher;
        Pattern p = Pattern.compile("((\\d{11})|^((\\d{7,8})|(\\d{4}|\\d{3})-(\\d{7,8})|(\\d{4}|\\d{3})-(\\d{7,8})-(\\d{4}|\\d{3}|\\d{2}|\\d{1})|(\\d{7,8})-(\\d{4}|\\d{3}|\\d{2}|\\d{1}))$)");
        String string = mobiles;
        if (string != null) {
            String it = string;
            boolean bl = false;
            matcher = p.matcher(it);
        } else {
            matcher = null;
        }
        Matcher matcher2 = m = matcher;
        return matcher2 != null ? matcher2.matches() : false;
    }

    @NotNull
    public static final String filterEmoji(@NotNull String source, @Nullable String slipStr) {
        String string;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!StringsKt.isBlank((CharSequence)source)) {
            CharSequence charSequence = source;
            Regex regex = new Regex("[\\ud800\\udc00-\\udbff\\udfff\\ud800-\\udfff]");
            String string2 = slipStr;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string2;
            string = regex.replace(charSequence, string3);
        } else {
            string = source;
        }
        return string;
    }

    public static final boolean isOnlyEmojis(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        CharSequence charSequence = UtilsKt.filterEmoji(source, "");
        return charSequence == null || charSequence.length() == 0;
    }

    @NotNull
    public static final String getFormatterTime(int timeSeconds) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "%02d";
        Object[] objectArray = new Object[]{timeSeconds / 3600};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(':');
        string = "%02d";
        objectArray = new Object[]{timeSeconds / 60 % 60};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(':');
        string = "%02d";
        objectArray = new Object[]{timeSeconds % 60};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        return stringBuilder3.append(string4).toString();
    }

    public static final boolean isNetworkAvailable(@Nullable Context context) {
        if (context == null) {
            return false;
        }
        Object object = context.getApplicationContext().getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager manager = (ConnectivityManager)object;
        if (Build.VERSION.SDK_INT >= 23) {
            NetworkCapabilities networkCapabilities = manager.getNetworkCapabilities(manager.getActiveNetwork());
            if (networkCapabilities != null) {
                return networkCapabilities.hasTransport(1) || networkCapabilities.hasTransport(0) || networkCapabilities.hasTransport(3);
            }
        } else {
            NetworkInfo networkInfo = manager.getActiveNetworkInfo();
            Intrinsics.checkNotNull((Object)networkInfo);
            networkInfo.isConnected();
        }
        return false;
    }

    public static final boolean isWifiConnected(@Nullable Context context) {
        if (context == null) {
            return false;
        }
        Object object = context.getApplicationContext().getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager manager = (ConnectivityManager)object;
        if (Build.VERSION.SDK_INT >= 23) {
            NetworkCapabilities networkCapabilities = manager.getNetworkCapabilities(manager.getActiveNetwork());
            if (networkCapabilities != null) {
                return networkCapabilities.hasTransport(1);
            }
        } else {
            NetworkInfo networkInfo = manager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 1;
        }
        return false;
    }

    public static final boolean isMobileData(@Nullable Context context) {
        if (context == null) {
            return false;
        }
        Object object = context.getApplicationContext().getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager manager = (ConnectivityManager)object;
        if (Build.VERSION.SDK_INT >= 23) {
            NetworkCapabilities networkCapabilities = manager.getNetworkCapabilities(manager.getActiveNetwork());
            if (networkCapabilities != null) {
                return networkCapabilities.hasTransport(0);
            }
        } else {
            NetworkInfo networkInfo = manager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 0;
        }
        return false;
    }

    @NotNull
    public static final String convertLikeCount(int likeCount) {
        String result = String.valueOf(likeCount);
        if (likeCount > 1000000000) {
            result = "" + likeCount / 100000000 + '\u4ebf';
        } else if (likeCount > 100000000) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "%.1f";
            Object[] objectArray = new Object[]{Float.valueOf((float)likeCount * 1.0f / (float)100000000)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            result = stringBuilder.append(string2).append('\u4ebf').toString();
        } else if (likeCount > 10000000) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "%.1f";
            Object[] objectArray = new Object[]{Float.valueOf((float)likeCount * 1.0f / (float)10000000)};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            result = stringBuilder.append(string3).append("kw").toString();
        } else if (likeCount > 1000000) {
            result = "" + likeCount / 10000 + 'w';
        } else if (likeCount > 100000) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "%.1f";
            Object[] objectArray = new Object[]{Float.valueOf((float)likeCount * 1.0f / (float)10000)};
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
            result = stringBuilder.append(string4).append('w').toString();
        } else if (likeCount > 10000) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "%.2f";
            Object[] objectArray = new Object[]{Float.valueOf((float)likeCount * 1.0f / (float)10000)};
            String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
            result = stringBuilder.append(string5).append('w').toString();
        }
        return result;
    }

    public static final boolean isBluetoothEnable(@Nullable Context context) {
        Context context2 = context;
        Object object = context2 != null ? context2.getSystemService("bluetooth") : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.bluetooth.BluetoothManager");
        BluetoothAdapter bluetoothAdapter = ((BluetoothManager)object).getAdapter();
        return bluetoothAdapter != null && bluetoothAdapter.isEnabled();
    }

    public static final void deleteLastChar(@NotNull EditText editText) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        int index = editText.getSelectionStart();
        Editable editable = editText.getText();
        editable.delete(index - 1, index);
    }

    public static final boolean copy(@NotNull Context context, @NotNull String copyStr) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)copyStr, (String)"copyStr");
        try {
            Object object = context.getSystemService("clipboard");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
            ClipboardManager cm = (ClipboardManager)object;
            ClipData mClipData = ClipData.newPlainText((CharSequence)"Label", (CharSequence)copyStr);
            cm.setPrimaryClip(mClipData);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public static final boolean isOrientationLandscape(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getConfiguration().orientation == 2;
    }

    public static final boolean checkMainThread(@NotNull Observer<?> observer) {
        Intrinsics.checkNotNullParameter(observer, (String)"observer");
        if (!Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            observer.onError((Throwable)new IllegalStateException("Expected to be called on the main thread but was " + Thread.currentThread().getName()));
            return false;
        }
        return true;
    }

    @NotNull
    public static final Observable<Integer> clicks(@NotNull View $this$clicks) {
        Intrinsics.checkNotNullParameter((Object)$this$clicks, (String)"<this>");
        return RxUtils.Companion.clicks($this$clicks);
    }

    public static final void startActivityByUrl(@Nullable Context context, @NotNull String url1) {
        Intrinsics.checkNotNullParameter((Object)url1, (String)"url1");
        String url = url1;
        if (context != null && !TextUtils.isEmpty((CharSequence)url1)) {
            if (!(StringsKt.startsWith$default((String)url1, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url1, (String)"https://", (boolean)false, (int)2, null) || TextUtils.isEmpty((CharSequence)url1))) {
                url = "http://" + url1;
            }
            try {
                Intent intent = new Intent();
                intent.setAction("android.intent.action.VIEW");
                Uri uri = Uri.parse((String)url);
                intent.setData(uri);
                context.startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final boolean isFocus(@Nullable Context context) {
        if (context instanceof Activity && Build.VERSION.SDK_INT >= 24 && ((Activity)context).isInMultiWindowMode()) {
            return false;
        }
        return UtilsKt.isAppForeground(context);
    }

    public static final boolean isAppForeground(@Nullable Context context) {
        List info;
        ActivityManager am;
        Context context2 = context;
        ActivityManager activityManager = am = (ActivityManager)(context2 != null ? context2.getSystemService("activity") : null);
        List list = info = activityManager != null ? activityManager.getRunningAppProcesses() : null;
        if (info == null || info.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (aInfo.importance != 100) continue;
            Context context3 = context;
            if (!Intrinsics.areEqual((Object)aInfo.processName, (Object)(context3 != null ? context3.getPackageName() : null))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final String getEncodePhoneNumber(@Nullable String originName) {
        if (originName != null) {
            String string;
            String $this$getEncodePhoneNumber_u24lambda_u242 = originName;
            boolean bl = false;
            if (UtilsKt.isMobileNumber(originName)) {
                CharSequence charSequence = originName;
                Regex regex = new Regex("^(\\d{3})\\d{4}(\\d{4})$");
                String string2 = "$1****$2";
                string = regex.replace(charSequence, string2);
            } else {
                string = originName;
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static final String getEncodeName(@Nullable String originName) {
        if (TextUtils.isEmpty((CharSequence)originName)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = originName;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return stringBuilder.append(string2).append("***").toString();
    }

    public static final <V> boolean isEmptyList(@Nullable List<? extends V> sourceList) {
        return sourceList == null || sourceList.isEmpty();
    }

    public static final <V> boolean isEmptySet(@Nullable Set<? extends V> sourceSet) {
        return sourceSet == null || sourceSet.isEmpty();
    }

    public static final long getTotalMemory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager activityManager = (ActivityManager)object;
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo.totalMem;
    }

    @NotNull
    public static final SoundPool playAudio(@NotNull Context context, int resId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("audio");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
        AudioManager am = (AudioManager)object;
        int volumeCurrent = am.getStreamVolume(3);
        SoundPool soundPool = new SoundPool(1, 3, 0);
        int soundId = soundPool.load(context, resId, 1);
        soundPool.setOnLoadCompleteListener((arg_0, arg_1, arg_2) -> UtilsKt.playAudio$lambda$3(soundPool, soundId, volumeCurrent, arg_0, arg_1, arg_2));
        return soundPool;
    }

    public static final void immersiveStatusBar(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(0);
        window.getDecorView().setSystemUiVisibility(1024);
    }

    public static final void setStatusBarWithTheme(@Nullable Activity activity, int attrColor) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (activity != null) {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(attrColor);
            window.getDecorView().setSystemUiVisibility(8448);
        }
    }

    public static final boolean isInMultiMode(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return Build.VERSION.SDK_INT >= 24 && activity.isInMultiWindowMode();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean areListsEqual(@Nullable List<String> list1, @Nullable List<String> list2) {
        boolean bl;
        if (list1 == null && list2 == null) {
            bl = false;
        } else if (list1 == null || list2 == null) {
            bl = false;
        } else if (list1.size() != list2.size()) {
            bl = false;
        } else if (list1.isEmpty() && list2.isEmpty()) {
            bl = false;
        } else {
            Integer n;
            void it;
            Map map;
            Object object;
            void it$iv$iv;
            boolean bl2;
            Iterable $this$mapValuesTo$iv$iv;
            Object list$iv$iv;
            Object value$iv$iv$iv;
            boolean $i$f$getOrPut;
            Map $this$getOrPut$iv$iv$iv;
            Object key$iv$iv;
            String it2;
            Object $this$groupByTo$iv$iv;
            Object $this$groupBy$iv = list1;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object element$iv$iv = iterator.next();
                it2 = (String)element$iv$iv;
                boolean bl3 = false;
                key$iv$iv = it2;
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Object $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Object $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            list$iv$iv = $this$associateByTo$iv$iv$iv.iterator();
            while (list$iv$iv.hasNext()) {
                Object element$iv$iv$iv = list$iv$iv.next();
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                bl2 = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                object = it$iv$iv.getKey();
                map = $this$getOrPut$iv$iv$iv;
                boolean bl5 = false;
                n = ((List)it.getValue()).size();
                map.put(object, n);
            }
            $this$mapValues$iv = list2;
            map = destination$iv$iv;
            $i$f$groupBy = false;
            $this$mapValuesTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$groupByTo = false;
            $this$associateByTo$iv$iv$iv = $this$groupByTo$iv$iv.iterator();
            while ($this$associateByTo$iv$iv$iv.hasNext()) {
                Object object3;
                Object element$iv$iv = $this$associateByTo$iv$iv$iv.next();
                it2 = (String)element$iv$iv;
                boolean bl6 = false;
                key$iv$iv = it2;
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl7 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            Iterator iterator2 = $this$associateByTo$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv$iv = iterator2.next();
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                bl2 = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                n = it$iv$iv.getKey();
                object = map2;
                boolean bl8 = false;
                Integer n2 = ((List)it.getValue()).size();
                object.put((Integer)n, (Integer)n2);
            }
            bl = Intrinsics.areEqual((Object)map, (Object)destination$iv$iv);
        }
        return bl;
    }

    private static final void playAudio$lambda$3(SoundPool $soundPool, int $soundId, int $volumeCurrent, SoundPool soundPool1, int sampleId, int status) {
        Intrinsics.checkNotNullParameter((Object)$soundPool, (String)"$soundPool");
        $soundPool.play($soundId, (float)$volumeCurrent, (float)$volumeCurrent, 0, 0, 1.0f);
    }
}

