/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyutils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import java.lang.reflect.Method;

public class PackageInfoUtils {
    private PackageInfoUtils() {
    }

    public static synchronized String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized String getVersionName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized int getVersionCode(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static synchronized String getPackageName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.packageName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCellularOperatorType(Context context) {
        if (!PackageInfoUtils.hasSim(context) || !PackageInfoUtils.isMobileDataEnabled(context)) {
            return "Unknown";
        }
        String opeType = "";
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String operator = tm.getSimOperator();
        opeType = "46001".equals(operator) || "46006".equals(operator) || "46009".equals(operator) ? "\u4e2d\u56fd\u8054\u901a" : ("46000".equals(operator) || "46002".equals(operator) || "46004".equals(operator) || "46007".equals(operator) ? "\u4e2d\u56fd\u79fb\u52a8" : ("46003".equals(operator) || "46005".equals(operator) || "46011".equals(operator) ? "\u4e2d\u56fd\u7535\u4fe1" : "\u672a\u77e5\u8fd0\u8425\u5546"));
        return opeType;
    }

    @SuppressLint(value={"DiscouragedPrivateApi"})
    public static boolean isMobileDataEnabled(Context context) {
        try {
            Method method = ConnectivityManager.class.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
            method.setAccessible(true);
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            return (Boolean)method.invoke((Object)connectivityManager, new Object[0]);
        }
        catch (Exception t) {
            Log.d((String)"isMobileDataEnabled", (String)"Check mobile data encountered exception");
            return false;
        }
    }

    private static boolean hasSim(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String operator = tm.getSimOperator();
        return !TextUtils.isEmpty((CharSequence)operator);
    }

    public static String getScreenResolution(Context context) {
        return DisplayUtils.getScreenWidthPixels(context) + "*" + DisplayUtils.getScreenHeightPixels(context);
    }

    public static String getScreenPointSize(Context context) {
        if (!(context instanceof Activity)) {
            return "";
        }
        try {
            Display display = ((Activity)context).getWindowManager().getDefaultDisplay();
            Point outSize = new Point();
            display.getSize(outSize);
            return outSize.x + "*" + outSize.y;
        }
        catch (Exception ignore) {
            return "";
        }
    }
}

