/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyutils.text;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.view.View;
import android.widget.TextView;
import com.baijiayun.bjyutils.text.HyperLinkHelper;
import com.baijiayun.bjyutils.toast.ToastCompat;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/baijiayun/bjyutils/text/HyperLinkHelper;", "", "()V", "REGEX", "", "applyUrlSpan", "Landroid/widget/TextView;", "textView", "setClickListener", "", "spanned", "Landroid/text/Spanned;", "listener", "Lkotlin/Function2;", "Landroid/view/View;", "UrlLinkSpan", "android-utils_release"})
public final class HyperLinkHelper {
    @NotNull
    public static final HyperLinkHelper INSTANCE = new HyperLinkHelper();
    @NotNull
    private static final String REGEX = "(((http[s]?|ftp?|file?)://)?[a-zA-Z0-9.\\-]+\\.([a-zA-Z]{2,4})(:\\d+)?(/[a-zA-Z0-9.\\-~!@#$%^&*+?:_/=<>]*)?)|(www.[a-zA-Z0-9.\\-]+\\.([a-zA-Z]{2,4})(:\\d+)?(/[a-zA-Z0-9.\\-~!@#$%^&*+?:_/=<>]*)?)";

    private HyperLinkHelper() {
    }

    @NotNull
    public final TextView applyUrlSpan(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        SpannableString spannableString = SpannableString.valueOf((CharSequence)textView.getText());
        Linkify.addLinks((Spannable)((Spannable)spannableString), (Pattern)Pattern.compile(REGEX), (String)"");
        URLSpan[] uRLSpanArray = (URLSpan[])spannableString.getSpans(0, spannableString.length(), URLSpan.class);
        if (uRLSpanArray == null) {
            return textView;
        }
        for (URLSpan sp : uRLSpanArray) {
            int start = spannableString.getSpanStart((Object)sp);
            int end = spannableString.getSpanEnd((Object)sp);
            spannableString.removeSpan((Object)sp);
            String string = sp.getURL();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sp.url");
            spannableString.setSpan((Object)new UrlLinkSpan(string), start, end, 17);
        }
        textView.setText((CharSequence)spannableString);
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        return textView;
    }

    public final void setClickListener(@NotNull Spanned spanned, @NotNull Function2<? super View, ? super String, Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)spanned, (String)"spanned");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Object[] objectArray = spanned.getSpans(0, spanned.length(), UrlLinkSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"spanned.getSpans(0, span\u2026 UrlLinkSpan::class.java)");
        Object[] $this$forEach$iv = objectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UrlLinkSpan it = (UrlLinkSpan)((Object)element$iv);
            boolean bl = false;
            it.setListener(listener2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R,\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/baijiayun/bjyutils/text/HyperLinkHelper$UrlLinkSpan;", "Landroid/text/style/ClickableSpan;", "url", "", "(Ljava/lang/String;)V", "listener", "Lkotlin/Function2;", "Landroid/view/View;", "", "getListener", "()Lkotlin/jvm/functions/Function2;", "setListener", "(Lkotlin/jvm/functions/Function2;)V", "getUrl", "()Ljava/lang/String;", "onClick", "widget", "android-utils_release"})
    public static final class UrlLinkSpan
    extends ClickableSpan {
        @NotNull
        private final String url;
        @NotNull
        private Function2<? super View, ? super String, Unit> listener;

        public UrlLinkSpan(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            this.listener = listener.1.INSTANCE;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final Function2<View, String, Unit> getListener() {
            return this.listener;
        }

        public final void setListener(@NotNull Function2<? super View, ? super String, Unit> function2) {
            Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
            this.listener = function2;
        }

        public void onClick(@NotNull View widget) {
            Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
            Uri uri = Uri.parse((String)this.url);
            Context context = widget.getContext();
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.putExtra("com.android.browser.application_id", context.getPackageName());
            try {
                context.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                ToastCompat.showToast(widget.getContext(), "\u4e0d\u652f\u6301\u6253\u5f00\u6b64\u94fe\u63a5");
            }
            this.listener.invoke((Object)widget, (Object)this.url);
        }
    }
}

