/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyutils.log;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.baijiayun.bjyutils.log.LogLevel;
import com.baijiayun.log.BJFileLog;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class LogUtil {
    private static final String TAG = "LogUtil";
    private static int currentLevel = 2;
    private static boolean isWriteToLogcat = true;
    private static boolean isWriteToFile = true;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.getDefault());
    private static volatile boolean IS_INITIALED = false;
    private static final Object LOCK = new Object();

    private LogUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context, int level, boolean out2logcat, boolean isWrite2File) {
        Object object = LOCK;
        synchronized (object) {
            if (IS_INITIALED) {
                return;
            }
            IS_INITIALED = true;
            currentLevel = level > 8 ? 8 : (level < 2 ? 2 : level);
            isWriteToLogcat = out2logcat;
            isWriteToFile = isWrite2File;
            if (isWrite2File) {
                File logDir = new File(context.getExternalFilesDir(null), "bjyLogFile");
                if (!logDir.exists()) {
                    logDir.mkdirs();
                }
                BJFileLog.setLogDirPath((String)logDir.getAbsolutePath());
                BJFileLog.setLogNamePrefix((String)"live_");
                BJFileLog.start((Context)context);
            }
        }
    }

    public static void i(Object tag, String msg, boolean is2Write) {
        if (currentLevel > LogLevel.INFO.val) {
            return;
        }
        String strTAG = tag instanceof String ? tag.toString() : (tag instanceof Class ? ((Class)tag).getSimpleName() : tag.getClass().getName());
        if (isWriteToLogcat) {
            Log.i((String)strTAG, (String)msg);
        }
        if (is2Write) {
            BJFileLog.i(null, (String)strTAG, (String)msg);
        }
    }

    public static void i(Object tag, String msg, boolean is2Write, Exception throwable) {
        if (currentLevel > LogLevel.INFO.val) {
            return;
        }
        String strTAG = tag instanceof String ? tag.toString() : (tag instanceof Class ? ((Class)tag).getSimpleName() : tag.getClass().getName());
        if (isWriteToLogcat) {
            Log.i((String)strTAG, (String)msg);
        }
        if (is2Write) {
            BJFileLog.i(null, (String)strTAG, (String)msg);
            BJFileLog.i(null, (String)strTAG, (String)throwable.getMessage());
        }
    }

    public static void v(Object tag, String msg, boolean is2Write, Exception throwable) {
        if (currentLevel > LogLevel.VERBOSE.val) {
            return;
        }
        String strTAG = tag instanceof String ? tag.toString() : (tag instanceof Class ? ((Class)tag).getSimpleName() : tag.getClass().getName());
        if (isWriteToLogcat) {
            Log.v((String)strTAG, (String)msg);
        }
        if (is2Write) {
            BJFileLog.d(null, (String)strTAG, (String)msg);
            BJFileLog.d(null, (String)strTAG, (String)throwable.getMessage());
        }
    }

    public static void v(Object tag, String msg, boolean is2Write) {
        if (currentLevel > LogLevel.VERBOSE.val) {
            return;
        }
        String strTAG = tag instanceof String ? tag.toString() : (tag instanceof Class ? ((Class)tag).getSimpleName() : tag.getClass().getName());
        if (isWriteToLogcat) {
            Log.v((String)strTAG, (String)msg);
        }
        if (is2Write) {
            BJFileLog.d(null, (String)strTAG, (String)msg);
        }
    }

    public static void d(Object tag, String msg, boolean is2Write, Exception throwable) {
        if (currentLevel > LogLevel.DEBUG.val) {
            return;
        }
        String strTAG = tag instanceof String ? tag.toString() : (tag instanceof Class ? ((Class)tag).getSimpleName() : tag.getClass().getName());
        if (isWriteToLogcat) {
            Log.d((String)strTAG, (String)msg);
        }
        if (is2Write) {
            BJFileLog.d(null, (String)strTAG, (String)msg);
            BJFileLog.d(null, (String)strTAG, (String)throwable.getMessage());
        }
    }

    public static void d(Object tag, String msg, boolean is2Write) {
        if (currentLevel > LogLevel.DEBUG.val) {
            return;
        }
        String strTAG = tag instanceof String ? tag.toString() : (tag instanceof Class ? ((Class)tag).getSimpleName() : tag.getClass().getName());
        if (isWriteToLogcat) {
            Log.d((String)strTAG, (String)msg);
        }
        if (is2Write) {
            BJFileLog.d(null, (String)strTAG, (String)msg);
        }
    }

    public static void w(Object tag, String msg, boolean is2Write, Exception throwable) {
        if (currentLevel > LogLevel.WARN.val) {
            return;
        }
        String strTAG = tag instanceof String ? tag.toString() : (tag instanceof Class ? ((Class)tag).getSimpleName() : tag.getClass().getName());
        if (isWriteToLogcat) {
            Log.w((String)strTAG, (String)msg);
        }
        if (is2Write) {
            BJFileLog.w(null, (String)strTAG, (String)msg);
            BJFileLog.w(null, (String)strTAG, (String)throwable.getMessage());
        }
    }

    public static void w(Object tag, String msg, boolean is2Write) {
        if (currentLevel > LogLevel.WARN.val) {
            return;
        }
        String strTAG = tag instanceof String ? tag.toString() : (tag instanceof Class ? ((Class)tag).getSimpleName() : tag.getClass().getName());
        if (isWriteToLogcat) {
            Log.w((String)strTAG, (String)msg);
        }
        if (is2Write) {
            BJFileLog.w(null, (String)strTAG, (String)msg);
        }
    }

    public static void e(Object tag, String msg, boolean is2Write, Exception throwable) {
        if (currentLevel > LogLevel.ERROR.val) {
            return;
        }
        String strTAG = tag instanceof String ? tag.toString() : (tag instanceof Class ? ((Class)tag).getSimpleName() : tag.getClass().getName());
        if (isWriteToLogcat) {
            Log.e((String)strTAG, (String)msg);
        }
        if (is2Write) {
            BJFileLog.e(null, (String)strTAG, (String)msg);
            BJFileLog.e(null, (String)strTAG, (String)throwable.getMessage());
        }
    }

    public static void e(Object tag, String msg, boolean is2Write) {
        if (currentLevel > LogLevel.ERROR.val) {
            return;
        }
        String strTAG = tag instanceof String ? tag.toString() : (tag instanceof Class ? ((Class)tag).getSimpleName() : tag.getClass().getName());
        if (isWriteToLogcat) {
            Log.e((String)strTAG, (String)msg);
        }
        if (is2Write) {
            BJFileLog.e(null, (String)strTAG, (String)msg);
        }
    }

    public static void i(Object tag, String msg) {
        LogUtil.i(tag, msg, isWriteToFile);
    }

    public static void v(Object tag, String msg) {
        LogUtil.v(tag, msg, isWriteToFile);
    }

    public static void e(Object tag, String msg) {
        LogUtil.e(tag, msg, isWriteToFile);
    }

    public static void w(Object tag, String msg) {
        LogUtil.w(tag, msg, isWriteToFile);
    }

    public static void d(Object tag, String msg) {
        LogUtil.d(tag, msg, isWriteToFile);
    }

    public static void setCurrentLevel(int currentLevel) {
        LogUtil.currentLevel = currentLevel;
    }

    public static void setOut2logcat(boolean out2logcat) {
        isWriteToLogcat = out2logcat;
    }

    public static void setIs2Write(boolean is2Write) {
        isWriteToFile = is2Write;
    }

    public static void write(String tag, String msg, int level) {
        if (isWriteToFile) {
            BJFileLog.d(null, (String)tag, (String)msg);
        }
    }

    public static void dispose() {
        IS_INITIALED = false;
        BJFileLog.stop();
    }

    public static void getZipLogFile(Context context, BJFileLog.IZipCallback zipCallback) {
        String model = Build.MODEL.replace(" ", "");
        String zipFileName = DATE_FORMAT.format(new Date(System.currentTimeMillis())) + "_" + model + ".zip";
        File logDir = new File(context.getExternalFilesDir(null), "bjyLogFile");
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        BJFileLog.zipLogFiles((String)logDir.getAbsolutePath(), (String)zipFileName, (BJFileLog.IZipCallback)zipCallback);
    }

    public static boolean deleteFile(String filePath) {
        File zipLogFile = new File(filePath);
        return zipLogFile.exists() && zipLogFile.delete();
    }
}

