/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyutils.toast;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Toast;
import java.lang.reflect.Field;

public class ToastCompat {
    private static Field sField_TN;
    private static Field sField_TN_Handler;

    private ToastCompat() {
    }

    public static void hook(Toast toast) {
        try {
            Object tn = sField_TN.get(toast);
            Handler preHandler = (Handler)sField_TN_Handler.get(tn);
            sField_TN_Handler.set(tn, (Object)new SafelyHandlerWrapper(preHandler));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showToastCenter(Context context, CharSequence cs) {
        ToastCompat.showToastCenter(context, cs, 0);
    }

    public static void showToastCenter(Context context, CharSequence cs, int length) {
        if (context == null) {
            return;
        }
        Toast toast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)cs, (int)length);
        toast.setGravity(17, 0, 0);
        if (Build.VERSION.SDK_INT == 25) {
            ToastCompat.hook(toast);
        }
        toast.show();
    }

    public static void showToast(Context context, CharSequence cs) {
        ToastCompat.showToast(context, cs, 0);
    }

    public static void showToast(Context context, CharSequence cs, int length) {
        if (context == null) {
            return;
        }
        Toast toast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)cs, (int)length);
        if (Build.VERSION.SDK_INT == 25) {
            ToastCompat.hook(toast);
        }
        toast.show();
    }

    public static void showCustomToast(Context context, View view, int gravity, int xOffset, int yOffset, int length) {
        if (context == null) {
            return;
        }
        Toast toast = new Toast(context.getApplicationContext());
        toast.setView(view);
        toast.setGravity(gravity, xOffset, yOffset);
        toast.setDuration(length);
        if (Build.VERSION.SDK_INT == 25) {
            ToastCompat.hook(toast);
        }
        toast.show();
    }

    static {
        if (Build.VERSION.SDK_INT == 25) {
            try {
                sField_TN = Toast.class.getDeclaredField("mTN");
                sField_TN.setAccessible(true);
                sField_TN_Handler = sField_TN.getType().getDeclaredField("mHandler");
                sField_TN_Handler.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class SafelyHandlerWrapper
    extends Handler {
        private Handler impl;

        public SafelyHandlerWrapper(Handler impl) {
            this.impl = impl;
        }

        public void dispatchMessage(Message msg) {
            try {
                super.dispatchMessage(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void handleMessage(Message msg) {
            try {
                this.impl.handleMessage(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

