/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyutils.screen;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.R;
import com.baijiayun.bjyutils.enums.ResStateType;
import com.baijiayun.bjyutils.kt.UtilsKt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayUtils {
    public static final Double ASPECT_RATIO_16_9 = 1.7777777777777777;
    public static final Double ASPECT_RATIO_16_10 = 1.6;

    public static int getScreenHeightPixels(@NotNull Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getScreenWidthPixels(@NotNull Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static boolean isAspectRatioNormal(Context context) {
        return ASPECT_RATIO_16_9.equals(DisplayUtils.getScreenAspectRatio(context));
    }

    public static boolean isAspectRatioSmall(Context context) {
        return DisplayUtils.getScreenAspectRatio(context) < ASPECT_RATIO_16_9;
    }

    public static boolean isAspectRatioLarge(Context context) {
        return DisplayUtils.getScreenAspectRatio(context) > ASPECT_RATIO_16_9;
    }

    public static double getScreenAspectRatio(Context context) {
        return 1.0 * (double)DisplayUtils.getScreenWidthPixels(context) / (double)DisplayUtils.getScreenHeightPixels(context);
    }

    @Deprecated
    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static float getScreenDensity(@NotNull Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        return dm.density;
    }

    public static void hideBottomUIMenu(Window window) {
        View decorView = window.getDecorView();
        int uiOptions = 4102;
        decorView.setSystemUiVisibility(uiOptions);
    }

    public static void hideKeyboard(@NotNull View v) {
        InputMethodManager inputMethodManager = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (inputMethodManager.isActive()) {
            inputMethodManager.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }

    public static int getStatusBarHeight(Activity context) {
        int statusBarHeight = DisplayUtils.getStatusBarHeightFromDecorView(context);
        if (statusBarHeight != 0) {
            return statusBarHeight;
        }
        return DisplayUtils.getStatusBarHeightByReflect((Context)context);
    }

    private static int getStatusBarHeightFromDecorView(Activity context) {
        Rect frame = new Rect();
        context.getWindow().getDecorView().getWindowVisibleDisplayFrame(frame);
        return frame.top;
    }

    private static int getStatusBarHeightByReflect(Context context) {
        int statusBarHeight = UtilsKt.getDp(25);
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object obj = c.newInstance();
            Field field = c.getField("status_bar_height");
            int x = Integer.parseInt(field.get(obj).toString());
            statusBarHeight = context.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return statusBarHeight;
    }

    public static boolean isValidContextForGlide(Context context) {
        if (context == null) {
            return false;
        }
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            return !activity.isDestroyed() && !activity.isFinishing();
        }
        return true;
    }

    public static boolean isPad(@NotNull Context context) {
        return "pad".equals(context.getResources().getString(R.string.bjy_util_screen_type));
    }

    public static boolean isNavigationBarShow(@NotNull Activity context) {
        Display display = context.getWindowManager().getDefaultDisplay();
        Point size = new Point();
        Point realSize = new Point();
        display.getSize(size);
        display.getRealSize(realSize);
        return realSize.y != size.y;
    }

    public static int getNavigationBarHeight(Activity activity) {
        if (!DisplayUtils.isNavigationBarShow(activity)) {
            return 0;
        }
        Resources resources = activity.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    public static boolean isPortrait(Context context) {
        Configuration configuration = context.getResources().getConfiguration();
        int orientation = configuration.orientation;
        return orientation == 1;
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public static ColorStateList getColorStateList(int stateColor, int unStateColor, @NotNull ResStateType stateType) {
        return new ColorStateList((int[][])new int[][]{{stateType.getState()}, {-stateType.getState()}}, new int[]{stateColor, unStateColor});
    }

    @Nullable
    public static Drawable getDrawableById(Context context, int resId) {
        try {
            return ContextCompat.getDrawable((Context)context, (int)resId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isLightColor(int color) {
        double darkness = 1.0 - (0.299 * (double)Color.red((int)color) + 0.587 * (double)Color.green((int)color) + 0.114 * (double)Color.blue((int)color)) / 255.0;
        return darkness < 0.5;
    }

    public static int[] getUnDisplayViewSize(View view) {
        int[] size = new int[2];
        if (view == null) {
            return size;
        }
        int width = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int height = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(width, height);
        size[0] = view.getMeasuredWidth();
        size[1] = view.getMeasuredHeight();
        return size;
    }

    public static int[] atMostViewSize(View view) {
        int[] size = new int[2];
        int width = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
        int height = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
        view.measure(width, height);
        size[0] = view.getMeasuredWidth();
        size[1] = view.getMeasuredHeight();
        return size;
    }

    public static Bitmap zoomImage(Bitmap srcBitmap, double newWidth, double newHeight) {
        float width = srcBitmap.getWidth();
        float height = srcBitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)newWidth / width;
        float scaleHeight = (float)newHeight / height;
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)srcBitmap, (int)0, (int)0, (int)((int)width), (int)((int)height), (Matrix)matrix, (boolean)true);
    }

    public static void setRoundCorner(View destView, final float radius) {
        destView.setOutlineProvider(new ViewOutlineProvider(){

            public void getOutline(View view, Outline outline) {
                if (view.getContext() == null) {
                    return;
                }
                outline.setRoundRect(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight(), radius);
            }
        });
        destView.setClipToOutline(true);
    }

    public static void saveViewCapture(View view, String dir) {
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        view.draw(canvas);
        File f = new File(dir, "bjy_capture_" + System.currentTimeMillis() + ".png");
        try {
            FileOutputStream out = new FileOutputStream(f);
            bitmap.compress(Bitmap.CompressFormat.PNG, 80, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isAutoRotationEnabled(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        try {
            int rotationSetting = Settings.System.getInt((ContentResolver)contentResolver, (String)"accelerometer_rotation");
            return rotationSetting == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }
}

