/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyutils;

import android.annotation.SuppressLint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0005\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0005\u001a\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0001H\u0007\u00a8\u0006\r"}, d2={"format24HoursTime", "", "timeInSeconds", "", "timeSeconds", "", "formatDataFromSecond", "time", "getDateFromSecond", "pattern", "second", "getSecondFromDate", "date", "android-utils_release"})
public final class TimeUtilsKt {
    @NotNull
    public static final String formatDataFromSecond(long time) {
        DateFormat mDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm", Locale.getDefault());
        String string = mDateFormat.format(new Date(time * (long)1000));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mDateFormat.format(Date(time * 1000))");
        return string;
    }

    @NotNull
    public static final String format24HoursTime(int timeInSeconds) {
        return TimeUtilsKt.format24HoursTime((long)timeInSeconds);
    }

    @NotNull
    public static final String format24HoursTime(long timeSeconds) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "%02d";
        Object[] objectArray = new Object[]{timeSeconds / (long)3600};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(':');
        string = "%02d";
        objectArray = new Object[]{timeSeconds / (long)60 % (long)60};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(':');
        string = "%02d";
        objectArray = new Object[]{timeSeconds % (long)60};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        return stringBuilder3.append(string4).toString();
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static final int getSecondFromDate(@NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date baseTime = sdf.parse("00:00:00");
        Date targetTime = sdf.parse(date);
        return (int)((targetTime.getTime() - baseTime.getTime()) / (long)1000);
    }

    @NotNull
    public static final String getDateFromSecond(@NotNull String pattern, long second) {
        SimpleDateFormat simpleDateFormat;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat $this$getDateFromSecond_u24lambda_u240 = simpleDateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        boolean bl = false;
        $this$getDateFromSecond_u24lambda_u240.setTimeZone(TimeZone.getTimeZone("UTC"));
        DateFormat mDateFormat = simpleDateFormat;
        String string = mDateFormat.format(new Date(second * (long)1000));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mDateFormat.format(Date(second * 1000))");
        return string;
    }
}

