/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.toolbox.answersheet;

import com.baijiayun.playback.bean.models.LPAnswerModel;
import com.baijiayun.playback.bean.models.LPAnswerSheetOptionModel;
import com.baijiayun.videoplayer.ui.activity.PBRoomRouterListener;
import com.baijiayun.videoplayer.ui.playback.toolbox.answersheet.QuestionToolContract;
import java.util.ArrayList;
import java.util.List;

public class QuestionToolPresenter
implements QuestionToolContract.Presenter {
    private PBRoomRouterListener roomRouterListener;
    private List<LPAnswerSheetOptionModel> options = new ArrayList<LPAnswerSheetOptionModel>();
    private long countDownTime;
    private long currentTime;
    private QuestionToolContract.View view;
    private LPAnswerModel lpAnswerModel;
    private List<String> checkedOptions = new ArrayList<String>();

    @Override
    public void removeQuestionTool(boolean isEnded) {
        this.roomRouterListener.answerEnd(isEnded);
    }

    @Override
    public String getDesc() {
        return this.lpAnswerModel.getDescription();
    }

    @Override
    public void setRouter(PBRoomRouterListener pbRoomRouterListener) {
        this.roomRouterListener = pbRoomRouterListener;
    }

    public void subscribe() {
    }

    public void unSubscribe() {
    }

    public void setLpQuestionToolModel(LPAnswerModel lpAnswerModel) {
        this.lpAnswerModel = lpAnswerModel;
        this.options.clear();
        this.options.addAll(lpAnswerModel.options);
        this.countDownTime = lpAnswerModel.duration;
    }

    public void destroy() {
        this.roomRouterListener = null;
        this.view = null;
    }

    public void setView(QuestionToolContract.View view) {
        this.view = view;
    }

    @Override
    public List<LPAnswerSheetOptionModel> getOptions() {
        return this.options;
    }

    @Override
    public void addCheckedOption(int index) {
        if (!this.checkedOptions.contains(String.valueOf(index))) {
            this.checkedOptions.add(String.valueOf(index));
        }
    }

    @Override
    public void deleteCheckedOption(int index) {
        if (this.checkedOptions.contains(String.valueOf(index))) {
            this.checkedOptions.remove(String.valueOf(index));
        }
    }

    private void checkOptions() {
        if (this.lpAnswerModel == null || this.lpAnswerModel.options == null || this.lpAnswerModel.options.isEmpty()) {
            return;
        }
        List options = this.lpAnswerModel.options;
        for (int i = 0; i < options.size(); ++i) {
            LPAnswerSheetOptionModel lpAnswerSheetOptionModel = (LPAnswerSheetOptionModel)options.get(i);
            if (!this.checkedOptions.contains(String.valueOf(i))) continue;
            lpAnswerSheetOptionModel.isActive = true;
        }
    }

    @Override
    public boolean submitAnswers() {
        if (this.checkedOptions.isEmpty()) {
            return false;
        }
        this.checkOptions();
        this.roomRouterListener.setQuestionAnswerCache(this.lpAnswerModel);
        return true;
    }
}

