/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.event;

import android.os.Bundle;
import android.view.MotionEvent;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.ui.component.ComponentManager;
import com.baijiayun.videoplayer.ui.listener.IFilter;
import com.baijiayun.videoplayer.ui.listener.OnLoopListener;
import com.baijiayun.videoplayer.ui.listener.OnTouchGestureListener;

public class EventDispatcher {
    private ComponentManager componentManager;

    public EventDispatcher(ComponentManager manager) {
        this.componentManager = manager;
    }

    public void dispatchPlayEvent(int eventCode, Bundle bundle) {
        if (eventCode == -99003 || eventCode == -99002) {
            return;
        }
        this.componentManager.forEach(component -> component.onPlayerEvent(eventCode, bundle));
        this.recycleBundle(bundle);
    }

    public void dispatchPlayEvent(IFilter filter, int eventCode, Bundle bundle) {
        this.componentManager.forEach(filter, component -> component.onPlayerEvent(eventCode, bundle));
        this.recycleBundle(bundle);
    }

    public void dispatchErrorEvent(int eventCode, Bundle bundle) {
        this.componentManager.forEach(component -> component.onErrorEvent(eventCode, bundle));
        this.recycleBundle(bundle);
    }

    public void dispatchErrorEvent(IFilter filter, int eventCode, Bundle bundle) {
        this.componentManager.forEach(filter, component -> component.onErrorEvent(eventCode, bundle));
        this.recycleBundle(bundle);
    }

    public void dispatchComponentEvent(int eventCode, Bundle bundle) {
        this.componentManager.forEach(component -> component.onComponentEvent(eventCode, bundle));
        this.recycleBundle(bundle);
    }

    public void dispatchComponentEvent(IFilter filter, int eventCode, Bundle bundle) {
        this.componentManager.forEach(filter, component -> component.onComponentEvent(eventCode, bundle));
        this.recycleBundle(bundle);
    }

    public void dispatchCustomEvent(int eventCode, Bundle bundle) {
        this.componentManager.forEach(component -> component.onCustomEvent(eventCode, bundle));
        this.recycleBundle(bundle);
    }

    public void dispatchCustomEvent(IFilter filter, int eventCode, Bundle bundle) {
        this.componentManager.forEach(filter, component -> component.onCustomEvent(eventCode, bundle));
        this.recycleBundle(bundle);
    }

    public void dispatchTouchEventOnSingleTabUp(MotionEvent event) {
        this.filterImplOnTouchEventListener(component -> ((OnTouchGestureListener)((Object)component)).onSingleTapUp(event));
    }

    public void dispatchTouchEventOnDoubleTabUp(MotionEvent event) {
        this.filterImplOnTouchEventListener(component -> ((OnTouchGestureListener)((Object)component)).onDoubleTap(event));
    }

    public void dispatchTouchEventOnDown(MotionEvent event) {
        this.filterImplOnTouchEventListener(component -> ((OnTouchGestureListener)((Object)component)).onDown(event));
    }

    public void dispatchTouchEventOnScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.filterImplOnTouchEventListener(component -> ((OnTouchGestureListener)((Object)component)).onScroll(e1, e2, distanceX, distanceY));
    }

    public void dispatchTouchEventOnEndGesture() {
        this.filterImplOnTouchEventListener(component -> ((OnTouchGestureListener)((Object)component)).onEndGesture());
    }

    public void dispatchDuringDispatchTouchEvent(boolean isInTouchMode) {
        this.filterImplOnTouchEventListener(component -> ((OnTouchGestureListener)((Object)component)).duringComponentTouch(isInTouchMode));
    }

    public void dispatchTouchEventLongPress() {
        this.filterImplOnTouchEventListener(component -> ((OnTouchGestureListener)((Object)component)).onLongPress());
    }

    private void filterImplOnTouchEventListener(OnLoopListener onLoopListener) {
        this.componentManager.forEach(component -> component instanceof OnTouchGestureListener, onLoopListener::onEach);
    }

    private void recycleBundle(Bundle bundle) {
        BundlePool.recycle((Bundle)bundle);
    }
}

