/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentTransaction;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.playback.PBRoom;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.playback.chat.PBChatFragment;
import com.baijiayun.videoplayer.ui.utils.PBUIUtils;

public class ChatComponent
extends BaseComponent {
    private PBChatFragment chatFragment;
    private PBRoom pbRoom;
    private FrameLayout container;

    public ChatComponent(Context context, PBRoom pbRoom) {
        super(context);
        this.pbRoom = pbRoom;
        this.container = (FrameLayout)this.findViewById(R.id.chat_content_container);
    }

    private void addChatFragment(PBRoom pbRoom) {
        if (this.getContext() instanceof FragmentActivity) {
            FragmentActivity activity = (FragmentActivity)this.getContext();
            if (this.chatFragment == null) {
                this.chatFragment = new PBChatFragment();
                this.chatFragment.setRoom(pbRoom);
                FragmentTransaction transaction = activity.getSupportFragmentManager().beginTransaction();
                transaction.add(R.id.chat_content_container, (Fragment)this.chatFragment, "chat_fragment");
                transaction.commitAllowingStateLoss();
            }
            if (this.isLandscape && PBUIUtils.isChatFloatRight(pbRoom)) {
                this.setComponentVisibility(0);
            } else {
                this.setComponentVisibility(8);
            }
        }
    }

    @Override
    public void onComponentEvent(int eventCode, Bundle bundle) {
        super.onComponentEvent(eventCode, bundle);
        switch (eventCode) {
            case -80034: {
                boolean show = bundle.getBoolean("bool_data");
                ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.container.getLayoutParams();
                layoutParams.bottomMargin = show ? UtilsKt.getDp((int)68) : 0;
                this.container.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                break;
            }
        }
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        super.onCustomEvent(eventCode, bundle);
        if (eventCode == -80006) {
            if (this.isLandscape && PBUIUtils.isChatFloatRight(this.pbRoom)) {
                this.setComponentVisibility(0);
            } else {
                this.setComponentVisibility(8);
            }
        } else if (eventCode == -80053) {
            this.addChatFragment(this.pbRoom);
        }
    }

    @Override
    protected View onCreateComponentView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjy_pb_layout_chat_component, null);
    }

    @Override
    protected void setKey() {
        this.key = "chat_component";
    }
}

