/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.AnimationDrawable;
import android.media.projection.MediaProjectionManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.media.app.NotificationCompat;
import com.baijiahulian.common.permission.AppPermissions;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.bjyutils.ScreenRecordDetector;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livebase.utils.ScreenshotService;
import com.baijiayun.livebase.utils.ScreenshotUtil;
import com.baijiayun.livebase.widgets.dialog.RecordWarningDialog;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.VideoPlayerFactory;
import com.baijiayun.videoplayer.bean.AlbumInfoModel;
import com.baijiayun.videoplayer.listeners.OnPlayerErrorListener;
import com.baijiayun.videoplayer.listeners.OnPlayerStatusChangeListener;
import com.baijiayun.videoplayer.listeners.OnPlayingTimeChangeListener;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.bean.VideoPlayerConfig;
import com.baijiayun.videoplayer.ui.listener.CallbackManager;
import com.baijiayun.videoplayer.ui.utils.PBUIUtils;
import com.baijiayun.videoplayer.ui.widget.BaseVideoView;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.List;

public class BaseActivity
extends AppCompatActivity {
    protected boolean isLandscape;
    private Notification notification;
    private MediaSessionCompat mediaSession;
    private final String channelId = "background_play";
    private final int notificationId = 0;
    private String mContentTitle;
    private String mContentText;
    private long maxDuration;
    private long currentDuration;
    private int largeIcon;
    private int smallIcon;
    private int playIcon;
    private Class toActivity;
    protected ViewGroup rootContainer;
    private final String FRAGMENTS_TAG = "android:support:fragments";
    protected VideoPlayerConfig videoPlayerConfig;
    protected boolean isMixedPBRoom;
    protected IBJYVideoPlayer bjyVideoPlayer;
    protected BaseVideoView baseVideoView;
    protected List<AlbumInfoModel> albumItemList = new ArrayList<AlbumInfoModel>();
    protected int currentAlbumIndex;
    protected String albumID;
    private ScreenRecordDetector screenRecordDetector;
    private Disposable disposableOfPermission;
    private RecordWarningDialog warningDialog;
    protected final CompositeDisposable compositeDisposable = new CompositeDisposable();
    protected Runnable startScreenRecordRunnable = new Runnable(){

        @Override
        public void run() {
            if (Build.VERSION.SDK_INT >= 33) {
                BaseActivity.this.screenRecordDetector.startDetection();
            } else {
                BaseActivity.this.disposableOfPermission = AppPermissions.newPermissions((Activity)BaseActivity.this).request(new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"}).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
                    if (aBoolean.booleanValue()) {
                        BaseActivity.this.screenRecordDetector.startDetection();
                    }
                });
            }
        }
    };
    private ContentObserver rotationObserver;
    private OrientationEventListener orientationEventListener;
    private boolean isHandleOrientation = false;
    private int currentOrientation = 0;
    private Intent screenCapturePermissionResultData;
    private MediaProjectionManager mediaProjectionManager;
    private static final int REQUEST_CODE_SCREEN_CAPTURE = 100;
    private Disposable disposableOfScreenshot;
    private boolean isScreenshotReceiver = false;
    private boolean isActionScreenshotReceiver = false;
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (("com.bjy.ACTION_SCREENSHOT_FINISH".equals(intent.getAction()) || "com.bjy.ACTION_SCREENSHOT_ERROR".equals(intent.getAction())) && BaseActivity.this.disableScreenRecording()) {
                BaseActivity.this.getWindow().addFlags(8192);
            }
        }
    };
    private BroadcastReceiver screenshotReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.bjy.screenshot")) {
                BaseActivity.this.takeScreenshot();
            }
        }
    };
    private View layoutWifi;
    private ImageView ivWifi;
    private AnimationDrawable animationDrawable;

    public BaseActivity() {
        this.getSavedStateRegistry().unregisterSavedStateProvider("android:support:fragments");
    }

    @SuppressLint(value={"SourceLockedOrientationActivity,UnspecifiedRegisterReceiverFlag"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.remove("android:support:fragments");
            Bundle bundle = savedInstanceState.getBundle("androidx.lifecycle.BundlableSavedStateRegistry.key");
            if (bundle != null) {
                bundle.remove("android:support:fragments");
            }
        }
        super.onCreate(savedInstanceState);
        BJYPlayerSDK.isVideoList = false;
        boolean bl = this.isLandscape = this.getResources().getConfiguration().orientation == 2;
        if (DisplayUtils.isPad((Context)this)) {
            this.isLandscape = true;
        }
        if (this.isLandscape) {
            this.getWindow().addFlags(1024);
        }
        this.parseSerializableExtra();
        this.initPlayer();
        IntentFilter filter = new IntentFilter("com.bjy.screenshot");
        if (Build.VERSION.SDK_INT >= 33) {
            this.registerReceiver(this.screenshotReceiver, filter, 2);
        } else {
            this.registerReceiver(this.screenshotReceiver, filter);
        }
        this.isScreenshotReceiver = true;
        this.screenRecordDetector = new ScreenRecordDetector(this.getApplicationContext());
        this.screenRecordDetector.setOnRecordStateChangeListener(new ScreenRecordDetector.OnRecordStateChangeListener(){

            public void onRecordStart() {
                if (BaseActivity.this.warningDialog == null) {
                    BaseActivity.this.warningDialog = new RecordWarningDialog();
                }
                BaseActivity.this.warningDialog.show(BaseActivity.this.getSupportFragmentManager(), "RecordWarningDialog");
            }

            public void onRecordStop() {
                if (BaseActivity.this.warningDialog != null && BaseActivity.this.warningDialog.isAdded()) {
                    BaseActivity.this.warningDialog.dismissAllowingStateLoss();
                }
            }
        });
    }

    protected void parseSerializableExtra() {
        this.albumID = this.getIntent().getStringExtra("album_no");
        this.isMixedPBRoom = this.getIntent().getBooleanExtra("pb_room_is_mixed", false);
        this.videoPlayerConfig = (VideoPlayerConfig)this.getIntent().getSerializableExtra("videoPlayerConfig");
        if (this.videoPlayerConfig == null) {
            this.videoPlayerConfig = new VideoPlayerConfig();
        }
        this.currentAlbumIndex = this.videoPlayerConfig.defaultAlbumIndex;
        if (this.videoPlayerConfig.supportBackgroundAudio) {
            this.checkOrCreateNotificationChannel();
        }
    }

    protected void initPlayer() {
        this.initOrientationListener();
        this.bjyVideoPlayer = new VideoPlayerFactory.Builder().setMixedPlayback(this.isMixedPBRoom).setSupportBackgroundAudio(this.videoPlayerConfig.supportBackgroundAudio).setSupportLooping(this.videoPlayerConfig.supportLooping).setSupportBreakPointPlay(this.videoPlayerConfig.supportBreakPointPlay).setContext((Context)this).setUserInfo(this.videoPlayerConfig.userName, this.videoPlayerConfig.userId).setLifecycle(this.getLifecycle()).build();
        if (CallbackManager.getInstance().getOuterPlayerListener() != null) {
            this.bjyVideoPlayer.addOnPlayerErrorListener(new OnPlayerErrorListener(){

                public void onError(LPError error) {
                    CallbackManager.getInstance().getOuterPlayerListener().onPlayerError(error);
                }
            });
            this.bjyVideoPlayer.addOnPlayerStatusChangeListener(new OnPlayerStatusChangeListener(){

                public void onStatusChange(PlayerStatus status) {
                    CallbackManager.getInstance().getOuterPlayerListener().onPlayerStatusChanged(status);
                }
            });
            this.bjyVideoPlayer.addOnPlayingTimeChangeListener(new OnPlayingTimeChangeListener(){

                public void onPlayingTimeChange(int currentTime, int duration) {
                    CallbackManager.getInstance().getOuterPlayerListener().onPlayTimeChanged(currentTime, duration);
                }
            });
        }
    }

    protected void subscribe() {
        this.compositeDisposable.add(this.baseVideoView.getObservableVideoStatus().observeOn(AndroidSchedulers.mainThread()).subscribe(status -> {
            switch (status) {
                case STATE_PREPARED: {
                    if (this.videoPlayerConfig.supportBackgroundAudio) {
                        this.createNotification(this.baseVideoView.getVideoInfo().getVideoTitle(), this.videoPlayerConfig.notification.contentString, this.baseVideoView.getVideoInfo().getDuration() * 1000, 0L, this.videoPlayerConfig.notification.largeIcon, this.videoPlayerConfig.notification.smallIcon, R.drawable.bjplayer_ic_notification_pause, BaseActivity.class);
                    }
                    this.setSeekEnable(this.videoPlayerConfig.supportSeek, this.videoPlayerConfig.maxWatchTime);
                    this.setVideoRateEnable(this.videoPlayerConfig.supportVideoRate);
                    this.setToggleScreenEnable(this.videoPlayerConfig.enableToggleScreen && !this.isScreenRecorderClass());
                    break;
                }
                case STATE_STARTED: {
                    if (!this.videoPlayerConfig.supportBackgroundAudio) break;
                    this.updatePlayState(R.drawable.bjplayer_ic_notification_pause);
                    break;
                }
                default: {
                    if (!this.videoPlayerConfig.supportBackgroundAudio) break;
                    if (status == PlayerStatus.STATE_PLAYBACK_COMPLETED) {
                        this.updatePlayTime(0L, this.bjyVideoPlayer.getDuration() * 1000);
                    }
                    this.updatePlayState(R.drawable.bjplayer_ic_notification_play);
                }
            }
        }));
        this.addWifiAnimListener();
    }

    private void initOrientationListener() {
        this.rotationObserver = new ContentObserver(new Handler()){

            public void onChange(boolean selfChange, @Nullable Uri uri) {
                super.onChange(selfChange, uri);
                if ("accelerometer_rotation".equals(uri.getLastPathSegment())) {
                    if (DisplayUtils.isAutoRotationEnabled((Context)BaseActivity.this)) {
                        BaseActivity.this.setRequestedOrientation(BaseActivity.this.getScreenOrientationAllow());
                    } else {
                        BaseActivity.this.setRequestedOrientation(BaseActivity.this.isLandscape ? 0 : 1);
                    }
                }
            }
        };
        this.getContentResolver().registerContentObserver(Settings.System.getUriFor((String)"accelerometer_rotation"), false, this.rotationObserver);
    }

    protected int getScreenOrientationAllow() {
        return 4;
    }

    protected boolean isScreenRecorderClass() {
        return false;
    }

    public void onBackPressed() {
        if (this.isLandscape && !DisplayUtils.isPad((Context)this) && !this.isInMultiMode()) {
            this.setRequestedOrientation(1);
        } else {
            super.onBackPressed();
        }
    }

    protected boolean isInMultiMode() {
        return Build.VERSION.SDK_INT >= 24 && this.isInMultiWindowMode();
    }

    protected void onBackPressedExitImmediately() {
        super.onBackPressed();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == 2) {
            this.getWindow().setFlags(1024, 1024);
            this.isLandscape = true;
            this.requestLayout(true);
        } else {
            this.getWindow().clearFlags(1024);
            this.isLandscape = false;
            this.requestLayout(false);
        }
        this.changeWifiAnim();
    }

    private int getCurrentOrientation(int orientation) {
        boolean isPortrait = orientation >= 0 && orientation <= 20 || orientation >= 340;
        boolean isPortraitReverse = orientation >= 160 && orientation <= 200;
        boolean isLandscape = orientation >= 250 && orientation <= 290;
        boolean isLandscapeReverse = orientation >= 70 && orientation <= 110;
        int currentOrientation = -1;
        if (isPortrait) {
            currentOrientation = 0;
        } else if (isLandscape) {
            currentOrientation = 1;
        } else if (isPortraitReverse) {
            currentOrientation = 2;
        } else if (isLandscapeReverse) {
            currentOrientation = 3;
        }
        return currentOrientation;
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    protected void initOrientationEventListener() {
        this.orientationEventListener = new OrientationEventListener((Context)this){

            public void onOrientationChanged(int orientation) {
                boolean isLandscapeReverse;
                if (!DisplayUtils.isAutoRotationEnabled((Context)BaseActivity.this)) {
                    return;
                }
                boolean isPortrait = orientation >= 0 && orientation <= 20 || orientation >= 340;
                boolean isPortraitReverse = orientation >= 160 && orientation <= 200;
                boolean isLandscape = orientation >= 250 && orientation <= 290;
                boolean bl = isLandscapeReverse = orientation >= 70 && orientation <= 110;
                if (BaseActivity.this.isHandleOrientation) {
                    int currentOrientation1 = BaseActivity.this.getCurrentOrientation(orientation);
                    if (BaseActivity.this.currentOrientation != currentOrientation1 && currentOrientation1 != -1) {
                        BaseActivity.this.isHandleOrientation = false;
                    }
                    return;
                }
                BaseActivity.this.currentOrientation = BaseActivity.this.getCurrentOrientation(orientation);
                if (isPortrait) {
                    BaseActivity.this.setRequestedOrientation(1);
                } else if (isPortraitReverse) {
                    BaseActivity.this.setRequestedOrientation(9);
                } else if (isLandscape) {
                    BaseActivity.this.setRequestedOrientation(0);
                } else if (isLandscapeReverse) {
                    BaseActivity.this.setRequestedOrientation(8);
                }
            }
        };
        this.orientationEventListener.enable();
    }

    protected void requestedOrientation(int requestedOrientation) {
        this.isHandleOrientation = true;
        this.setRequestedOrientation(requestedOrientation);
    }

    protected void requestLayout(boolean isLandscape) {
    }

    protected void setSeekEnable(boolean isEnable, int maxWatchTime) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("bool_data", isEnable);
        bundle.putInt("int_data", maxWatchTime);
        this.baseVideoView.sendCustomEvent(-80035, bundle);
    }

    protected void setVideoRateEnable(boolean isEnable) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("bool_data", isEnable);
        this.baseVideoView.sendCustomEvent(-80038, bundle);
    }

    protected void setToggleScreenEnable(boolean isEnable) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("bool_data", isEnable);
        this.baseVideoView.sendCustomEvent(-80036, bundle);
    }

    protected void addFragment(int layoutId, Fragment fragment, boolean addToBackStack, String fragmentTag) {
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        if (fragmentTag == null) {
            transaction.add(layoutId, fragment);
        } else {
            transaction.add(layoutId, fragment, fragmentTag);
        }
        transaction.commitAllowingStateLoss();
    }

    protected void addFragment(int layoutId, Fragment fragment, boolean addToBackStack) {
        this.addFragment(layoutId, fragment, addToBackStack, null);
    }

    protected void addFragment(int layoutId, Fragment fragment, String tag) {
        this.addFragment(layoutId, fragment, false, tag);
    }

    protected void addFragment(int layoutId, Fragment fragment) {
        this.addFragment(layoutId, fragment, false);
    }

    protected void removeFragment(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        transaction.remove(fragment);
        transaction.commitAllowingStateLoss();
    }

    protected void showDialogFragment(BaseDialogFragment dialogFragment) {
        dialogFragment.show(this.getSupportFragmentManager(), dialogFragment.getClass().getSimpleName() + dialogFragment.hashCode());
        this.getSupportFragmentManager().executePendingTransactions();
        if (dialogFragment.getDialog() != null) {
            dialogFragment.getDialog().setOnDismissListener(dialog -> {
                if (this.isFinishing()) {
                    return;
                }
                FragmentTransaction ft1 = this.getSupportFragmentManager().beginTransaction();
                Fragment prev = this.getSupportFragmentManager().findFragmentByTag(dialogFragment.getClass().getSimpleName() + dialogFragment.hashCode());
                if (prev != null) {
                    ft1.remove(prev);
                }
                ft1.commitAllowingStateLoss();
            });
        }
    }

    protected void checkOrCreateNotificationChannel() {
        NotificationChannel notificationChannel;
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)this);
        boolean isAllowedNotification = notificationManagerCompat.areNotificationsEnabled();
        if (Build.VERSION.SDK_INT >= 26 && (notificationChannel = notificationManagerCompat.getNotificationChannel("background_play")) == null) {
            notificationChannel = new NotificationChannel("background_play", (CharSequence)"\u540e\u53f0\u64ad\u653e", 2);
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            notificationManager.createNotificationChannel(notificationChannel);
        }
        if (!isAllowedNotification) {
            this.showNotificationDialog();
        }
    }

    protected void createNotification(String contentTitle, String contentText, long maxDuration, long currentDuration, int largeIcon, int smallIcon, int playIcon, Class activity) {
        this.mContentTitle = contentTitle;
        this.mContentText = contentText;
        this.maxDuration = maxDuration;
        this.currentDuration = currentDuration;
        this.largeIcon = largeIcon;
        this.smallIcon = smallIcon;
        this.playIcon = playIcon;
        this.toActivity = activity;
        this.mediaSession = new MediaSessionCompat((Context)this, "bjyplayer");
        this.mediaSession.setCallback(new MediaSessionCompat.Callback(){

            public void onSeekTo(long pos) {
                BaseActivity.this.notificationSeekTo(pos);
            }
        });
        this.mediaSession.setActive(true);
        this.createNotification();
    }

    private void showNotificationDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(false).setMessage((CharSequence)this.getString(R.string.bjy_player_background_play_dialog_text)).setPositiveButton((CharSequence)this.getString(R.string.bjy_player_background_play_dialog_positive_text), (dialog, which) -> {
            Intent intent = new Intent();
            if (Build.VERSION.SDK_INT >= 26) {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("android.provider.extra.APP_PACKAGE", this.getPackageName());
                intent.putExtra("android.provider.extra.CHANNEL_ID", this.getApplicationInfo().uid);
            } else {
                intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                intent.putExtra("app_package", this.getPackageName());
                intent.putExtra("app_uid", this.getApplicationInfo().uid);
            }
            this.startActivity(intent);
            this.finish();
        }).setNegativeButton((CharSequence)this.getString(R.string.bjy_player_background_play_dialog_negative_text), (dialog, which) -> this.finish()).create().show();
    }

    private void createNotification() {
        PlaybackStateCompat.Builder stateBuilder = new PlaybackStateCompat.Builder().setActions(772L).setState(3, this.currentDuration, 1.0f, 0L);
        this.mediaSession.setPlaybackState(stateBuilder.build());
        this.mediaSession.setMetadata(new MediaMetadataCompat.Builder().putBitmap("android.media.metadata.ALBUM_ART", BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.largeIcon)).putString("android.media.metadata.TITLE", this.mContentTitle).putLong("android.media.metadata.DURATION", this.maxDuration).build());
        Intent contentIntent = new Intent((Context)this, this.toActivity);
        contentIntent.addFlags(0x30000000);
        PendingIntent contentPendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)contentIntent, (int)(Build.VERSION.SDK_INT >= 31 ? 0x4000000 : 0));
        Intent controlIntent = new Intent("action_notification_control_play");
        controlIntent.setPackage(this.getPackageName());
        PendingIntent controlPendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)controlIntent, (int)(Build.VERSION.SDK_INT >= 31 ? 0x4000000 : 0));
        this.notification = new NotificationCompat.Builder((Context)this, "background_play").setContentTitle((CharSequence)this.mContentTitle).setContentText((CharSequence)this.mContentText).setLargeIcon(BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.largeIcon)).setSmallIcon(this.smallIcon).setContentIntent(contentPendingIntent).addAction(new NotificationCompat.Action(this.playIcon, (CharSequence)"pause_or_play", controlPendingIntent)).setStyle((NotificationCompat.Style)new NotificationCompat.MediaStyle().setMediaSession(this.mediaSession.getSessionToken()).setShowActionsInCompactView(new int[]{0})).setAutoCancel(false).setShowWhen(false).build();
        this.notification.flags = 32;
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)this);
        notificationManagerCompat.notify(0, this.notification);
    }

    protected boolean disableScreenRecording() {
        return PBUIUtils.disableScreenRecording(this.bjyVideoPlayer);
    }

    @SuppressLint(value={"UnspecifiedRegisterReceiverFlag"})
    protected void takeScreenshot() {
        if (this.disableScreenRecording()) {
            this.getWindow().clearFlags(8192);
            IntentFilter filter = new IntentFilter();
            filter.addAction("com.bjy.ACTION_SCREENSHOT_FINISH");
            filter.addAction("com.bjy.ACTION_SCREENSHOT_ERROR");
            if (Build.VERSION.SDK_INT >= 33) {
                this.registerReceiver(this.receiver, filter, 2);
            } else {
                this.registerReceiver(this.receiver, filter);
            }
            this.isActionScreenshotReceiver = true;
        }
        if (this.screenCapturePermissionResultData != null && Build.VERSION.SDK_INT < 34) {
            this.captureScreen(-1, this.screenCapturePermissionResultData);
        } else {
            if (this.mediaProjectionManager == null) {
                this.mediaProjectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
            }
            Intent captureIntent = this.mediaProjectionManager.createScreenCaptureIntent();
            this.startActivityForResult(captureIntent, 100);
        }
    }

    private void captureScreen(int resultCode, Intent data) {
        String permission2 = Build.VERSION.SDK_INT >= 33 ? "android.permission.READ_MEDIA_IMAGES" : "android.permission.WRITE_EXTERNAL_STORAGE";
        RxUtils.dispose((Disposable)this.disposableOfScreenshot);
        this.disposableOfScreenshot = AppPermissions.newPermissions((Activity)this).request(new String[]{permission2}).filter(aBoolean -> {
            if (!aBoolean.booleanValue()) {
                ToastCompat.showToast((Context)this, (CharSequence)this.getString(R.string.live_no_write_permission), (int)0);
                if (this.disableScreenRecording()) {
                    this.getWindow().addFlags(8192);
                }
            }
            return aBoolean;
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            ScreenshotService.Companion.setResultCode(resultCode);
            ScreenshotService.Companion.setData(data);
            ScreenshotUtil.startService((Context)this);
        });
    }

    protected void showWifiAnim(boolean showAnim) {
        if (showAnim) {
            if (this.layoutWifi == null) {
                this.layoutWifi = this.findViewById(R.id.layout_wifi);
                this.ivWifi = (ImageView)this.layoutWifi.findViewById(R.id.iv_wifi);
                this.animationDrawable = (AnimationDrawable)this.ivWifi.getBackground();
                TextView textView = (TextView)this.layoutWifi.findViewById(R.id.tv_wifi_tp);
                String fullText = this.getString(R.string.bjy_pb_wifi_tip);
                SpannableString spannableString = new SpannableString((CharSequence)fullText);
                String changeDefinitionStr = this.getString(R.string.bjy_pb_change_definition_tip);
                String changeNetworkStr = this.getString(R.string.bjy_pb_change_network_tip);
                int startIndex1 = fullText.indexOf(changeDefinitionStr);
                int endIndex1 = startIndex1 + changeDefinitionStr.length();
                int startIndex2 = fullText.indexOf(changeNetworkStr);
                int endIndex2 = startIndex2 + changeNetworkStr.length();
                spannableString.setSpan((Object)new ForegroundColorSpan(this.getResources().getColor(R.color.base_theme_live_product)), startIndex1, endIndex1, 33);
                spannableString.setSpan((Object)new ForegroundColorSpan(this.getResources().getColor(R.color.base_theme_live_product)), startIndex2, endIndex2, 33);
                textView.setText((CharSequence)spannableString);
                this.layoutWifi.setBackground(new DrawableBuilder().solidColor(Color.parseColor((String)"#99000000")).cornerRadius(UtilsKt.getDp((int)4)).build());
            }
            this.layoutWifi.setVisibility(0);
            ViewGroup.LayoutParams layoutParams = this.layoutWifi.getLayoutParams();
            if (layoutParams instanceof RelativeLayout.LayoutParams) {
                int n = ((RelativeLayout.LayoutParams)layoutParams).bottomMargin = this.isLandscape && this.isPlayback() ? UtilsKt.getDp((int)108) : UtilsKt.getDp((int)68);
            }
            if (layoutParams instanceof ConstraintLayout.LayoutParams) {
                ((ConstraintLayout.LayoutParams)layoutParams).bottomMargin = this.isLandscape && this.isPlayback() ? UtilsKt.getDp((int)108) : UtilsKt.getDp((int)68);
            }
            this.animationDrawable.start();
        } else {
            if (this.animationDrawable != null) {
                this.animationDrawable.stop();
            }
            if (this.layoutWifi != null) {
                this.layoutWifi.setVisibility(8);
            }
        }
    }

    protected void changeWifiAnim() {
        if (this.layoutWifi != null) {
            ViewGroup.LayoutParams layoutParams = this.layoutWifi.getLayoutParams();
            if (layoutParams instanceof RelativeLayout.LayoutParams) {
                int n = ((RelativeLayout.LayoutParams)layoutParams).bottomMargin = this.isLandscape && this.isPlayback() ? UtilsKt.getDp((int)108) : UtilsKt.getDp((int)68);
            }
            if (layoutParams instanceof ConstraintLayout.LayoutParams) {
                ((ConstraintLayout.LayoutParams)layoutParams).bottomMargin = this.isLandscape && this.isPlayback() ? UtilsKt.getDp((int)108) : UtilsKt.getDp((int)68);
            }
        }
    }

    protected boolean isPlayback() {
        return false;
    }

    protected boolean supportWifiAnim() {
        return true;
    }

    private void addWifiAnimListener() {
        if (this.bjyVideoPlayer != null && this.supportWifiAnim()) {
            this.bjyVideoPlayer.addOnPlayerLagListener(error -> {
                if (error.getCode() == -88020) {
                    this.getWindow().getDecorView().post(() -> this.showWifiAnim(true));
                }
                if (error.getCode() == -88021) {
                    this.getWindow().getDecorView().post(() -> this.showWifiAnim(false));
                }
            });
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable @org.jetbrains.annotations.Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data != null && requestCode == 100 && resultCode == -1) {
            this.screenCapturePermissionResultData = data;
            this.captureScreen(resultCode, data);
        }
    }

    protected void updatePlayTime(long currentTime, long duration) {
        if (this.notification == null) {
            return;
        }
        this.currentDuration = currentTime;
        this.maxDuration = duration;
        this.createNotification();
    }

    protected void updatePlayState(int playIcon) {
        if (this.notification == null) {
            return;
        }
        this.playIcon = playIcon;
        this.createNotification();
    }

    protected void updateNotificationContent(String contentTitle, String contentText) {
        if (this.notification == null) {
            return;
        }
        this.mContentTitle = contentTitle;
        this.mContentText = contentText;
    }

    protected void notificationSeekTo(long pos) {
    }

    protected void onDestroy() {
        super.onDestroy();
        this.screenRecordDetector.stopDetection();
        if (this.baseVideoView != null) {
            this.baseVideoView.removeCallbacks(this.startScreenRecordRunnable);
        }
        RxUtils.dispose((Disposable)this.disposableOfPermission);
        RxUtils.dispose((Disposable)this.disposableOfScreenshot);
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)this);
        notificationManagerCompat.cancel(0);
        if (this.mediaSession != null) {
            this.mediaSession.release();
        }
        if (this.isScreenshotReceiver) {
            this.unregisterReceiver(this.screenshotReceiver);
        }
        if (this.isActionScreenshotReceiver) {
            this.unregisterReceiver(this.receiver);
        }
        this.compositeDisposable.clear();
        CallbackManager.getInstance().clearListener();
        if (this.orientationEventListener != null) {
            this.orientationEventListener.disable();
        }
        if (this.rotationObserver != null && this.getContentResolver() != null) {
            this.getContentResolver().unregisterContentObserver(this.rotationObserver);
        }
    }
}

