/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.ui.listener.IComponent;
import com.baijiayun.videoplayer.ui.listener.IComponentEventListener;

public abstract class BaseComponent
implements IComponent,
View.OnAttachStateChangeListener {
    private View view;
    protected String key;
    private Context mContext;
    private IComponentEventListener componentEventListener;
    private IBJYVideoPlayer videoPlayer;
    protected boolean isLandscape;

    public BaseComponent(Context context) {
        this.mContext = context;
        this.setKey();
        this.view = this.onCreateComponentView(context);
        this.view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
    }

    @Override
    public void setComponentVisibility(int visibility) {
        if (this.view.getVisibility() != visibility) {
            this.view.setVisibility(visibility);
        }
    }

    @Override
    public View getView() {
        return this.view;
    }

    protected abstract View onCreateComponentView(Context var1);

    protected final <T extends View> T findViewById(int id2) {
        return (T)this.view.findViewById(id2);
    }

    protected void notifyComponentEvent(int eventCode, Bundle bundle) {
        if (this.componentEventListener != null) {
            this.componentEventListener.onReceiverEvent(eventCode, bundle);
        }
    }

    @Override
    public void setComponentEventListener(IComponentEventListener componentEventListener) {
        this.componentEventListener = componentEventListener;
    }

    @Override
    public void bindVideoPlayer(IBJYVideoPlayer videoPlayer) {
        this.videoPlayer = videoPlayer;
    }

    @Override
    public void destroy() {
        this.view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        if (this.componentEventListener != null) {
            this.componentEventListener = null;
        }
        if (this.videoPlayer != null) {
            this.videoPlayer = null;
        }
        this.mContext = null;
    }

    @Override
    public IBJYVideoPlayer getVideoPlayer() {
        return this.videoPlayer;
    }

    public final void requestPause(Bundle bundle) {
        this.notifyComponentEvent(-80003, bundle);
    }

    public final void requestPlay(Bundle bundle) {
        this.notifyComponentEvent(-80015, bundle);
    }

    public final void requestSeek(Bundle bundle) {
        this.notifyComponentEvent(-80002, bundle);
    }

    public final void requestStop(Bundle bundle) {
        this.notifyComponentEvent(-80005, bundle);
    }

    public void onViewAttachedToWindow(View v) {
    }

    public void onViewDetachedFromWindow(View v) {
    }

    @Override
    public void onComponentEvent(int eventCode, Bundle bundle) {
    }

    @Override
    public void onPlayerEvent(int eventCode, Bundle bundle) {
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        if (eventCode == -80006) {
            this.isLandscape = bundle.getBoolean("bool_data");
        }
    }

    @Override
    public void onErrorEvent(int eventCode, Bundle bundle) {
    }

    protected abstract void setKey();

    @Override
    public String getKey() {
        return this.key;
    }

    protected final Context getContext() {
        return this.mContext;
    }
}

