/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import java.lang.reflect.Constructor;

public class DragFrameLayout
extends FrameLayout {
    private int lastX = 0;
    private int lastY = 0;
    private int screenWidth = 0;
    private int screenHeight = 0;
    private final Context context;
    private static final double DRAG_THRESHOLD = 2.0;
    private double threshold = 0.0;
    private ViewGroup.LayoutParams lpFeedback;
    private boolean isInterceptTouchEvent;

    public DragFrameLayout(Context context) {
        this(context, null);
    }

    public DragFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initScreenParam(context);
        this.context = context;
    }

    public void configurationChanged() {
        this.initScreenParam(this.context);
    }

    private void initScreenParam(Context context) {
        DisplayMetrics metric = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metric);
        this.screenWidth = metric.widthPixels;
        this.screenHeight = metric.heightPixels;
    }

    public void setInterceptTouchEvent(boolean interceptTouchEvent) {
        this.isInterceptTouchEvent = interceptTouchEvent;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.isInterceptTouchEvent;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.lastX = (int)event.getRawX();
                this.lastY = (int)event.getRawY();
                Class<?> layoutParamsClass = this.getLayoutParams().getClass();
                try {
                    Constructor<?> constructor = layoutParamsClass.getConstructor(Integer.TYPE, Integer.TYPE);
                    this.lpFeedback = (ViewGroup.LayoutParams)constructor.newInstance(this.getWidth(), this.getHeight());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!(this.lpFeedback instanceof ConstraintLayout.LayoutParams)) break;
                ((ConstraintLayout.LayoutParams)this.lpFeedback).topToTop = 0;
                ((ConstraintLayout.LayoutParams)this.lpFeedback).startToStart = 0;
                break;
            }
            case 2: {
                int dx = (int)event.getRawX() - this.lastX;
                int dy = (int)event.getRawY() - this.lastY;
                int left = this.getLeft() + dx;
                int top = this.getTop() + dy;
                int right = this.getRight() + dx;
                int bottom = this.getBottom() + dy;
                if (left < 0) {
                    left = 0;
                    right = left + this.getWidth();
                }
                if (right > this.screenWidth) {
                    right = this.screenWidth;
                    left = right - this.getWidth();
                }
                if (top < 0) {
                    top = 0;
                    bottom = top + this.getHeight();
                }
                if (bottom > this.screenHeight) {
                    bottom = this.screenHeight;
                    top = this.screenHeight - this.getHeight();
                }
                this.layout(left, top, right, bottom);
                if (this.lpFeedback instanceof ViewGroup.MarginLayoutParams) {
                    ((ViewGroup.MarginLayoutParams)this.lpFeedback).setMargins(left, top, 0, 0);
                }
                this.setLayoutParams(this.lpFeedback);
                this.lastX = (int)event.getRawX();
                this.lastY = (int)event.getRawY();
                this.threshold = Math.max(this.threshold, Math.sqrt(dx * dx + dy * dy));
                break;
            }
            case 1: {
                if (!(this.threshold > 2.0)) break;
                this.threshold = 0.0;
                return true;
            }
        }
        return super.onTouchEvent(event);
    }
}

