/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.media.AudioManager;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.constant.VideoType;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.databinding.BjyPbLayoutGuestureComponentBinding;
import com.baijiayun.videoplayer.ui.listener.OnTouchGestureListener;
import com.baijiayun.videoplayer.util.VideoPlayerUtils;

public class GestureComponent
extends BaseComponent
implements OnTouchGestureListener {
    private LinearLayout volumeLl;
    private TextView volumeTv;
    private ImageView volumeIv;
    private LinearLayout brightnessLl;
    private TextView brightnessTv;
    private LinearLayout fastForwardLl;
    private TextView fastForwardTv;
    private ImageView fastForwardIv;
    private AudioManager audioManager;
    private int mMaxVolume;
    private float brightness = -1.0f;
    private int volume = -1;
    private volatile boolean enableBrightnessCtrl = true;
    private volatile boolean enableVolumeCtrl = true;
    private volatile boolean enableSeekCtrl = true;
    private volatile int maxSeekTime = Integer.MAX_VALUE;
    private int mWidth;
    private int mHeight;
    private boolean toSeek;
    private boolean volumeControl;
    private boolean firstTouch;
    private int newPosition = -1;
    private BjyPbLayoutGuestureComponentBinding binding;
    private boolean isLongPress = false;
    private float playRate = 1.0f;
    private AnimatedVectorDrawable animatedVector;
    private VideoType videoType;
    private boolean isLock;

    public GestureComponent(Context context) {
        super(context);
        this.initView();
        this.initAudioManager(context);
        this.getView().addOnLayoutChangeListener((v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {
            if (left == oldLeft && top == oldTop && right == oldRight && bottom == oldBottom) {
                return;
            }
            this.mWidth = right - left;
            this.mHeight = bottom - top;
        });
    }

    @Override
    protected View onCreateComponentView(Context context) {
        View rootView = View.inflate((Context)context, (int)R.layout.bjy_pb_layout_guesture_component, null);
        this.binding = BjyPbLayoutGuestureComponentBinding.bind(rootView);
        return rootView;
    }

    private void initView() {
        this.volumeLl = (LinearLayout)this.findViewById(R.id.cover_player_gesture_operation_volume_box);
        this.volumeTv = (TextView)this.findViewById(R.id.cover_player_gesture_operation_volume_text);
        this.volumeIv = (ImageView)this.findViewById(R.id.cover_player_gesture_operation_volume_icon);
        this.brightnessLl = (LinearLayout)this.findViewById(R.id.cover_player_gesture_operation_brightness_box);
        this.brightnessTv = (TextView)this.findViewById(R.id.cover_player_gesture_operation_brightness_text);
        this.fastForwardLl = (LinearLayout)this.findViewById(R.id.cover_player_gesture_operation_fast_forward_box);
        this.fastForwardIv = (ImageView)this.findViewById(R.id.cover_player_gesture_operation_fast_forward_text_view_step_time);
        this.fastForwardTv = (TextView)this.findViewById(R.id.cover_player_gesture_operation_fast_forward_text_view_progress_time);
        this.binding.longPressForwardContainer.setBackground(new DrawableBuilder().solidColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.controller_bg_dark)).cornerRadius(UtilsKt.getDp((int)30)).build());
        if (this.binding.arrowIv.getDrawable() instanceof AnimatedVectorDrawable) {
            this.animatedVector = (AnimatedVectorDrawable)this.binding.arrowIv.getDrawable();
        }
    }

    @Override
    protected void setKey() {
        this.key = "gesture_component";
    }

    private void initAudioManager(Context context) {
        this.audioManager = (AudioManager)context.getSystemService("audio");
        assert (this.audioManager != null);
        this.mMaxVolume = this.audioManager.getStreamMaxVolume(3);
    }

    @Override
    public void onErrorEvent(int eventCode, Bundle bundle) {
        super.onErrorEvent(eventCode, bundle);
        this.setComponentVisibility(8);
    }

    @Override
    public void onPlayerEvent(int eventCode, Bundle bundle) {
        super.onPlayerEvent(eventCode, bundle);
        block0 : switch (eventCode) {
            case -99031: {
                PlayerStatus playerStatus = (PlayerStatus)bundle.getSerializable("serializable_data");
                if (playerStatus == null) {
                    return;
                }
                switch (playerStatus) {
                    case STATE_STARTED: {
                        this.setComponentVisibility(0);
                        break block0;
                    }
                    case STATE_ERROR: 
                    case STATE_PAUSED: 
                    case STATE_PLAYBACK_COMPLETED: {
                        this.setComponentVisibility(8);
                        break block0;
                    }
                }
                break;
            }
            case -80010: {
                this.setComponentVisibility(8);
                break;
            }
            case -80011: {
                this.setComponentVisibility(0);
                break;
            }
        }
    }

    @Override
    public void bindVideoPlayer(IBJYVideoPlayer videoPlayer) {
        super.bindVideoPlayer(videoPlayer);
        videoPlayer.addOnVideoTypeChangeListener(videoType -> {
            this.videoType = videoType;
            if (videoType != VideoType.ContentVideo) {
                this.setComponentVisibility(8);
            } else {
                this.setComponentVisibility(0);
            }
        });
        this.videoType = videoPlayer.getVideoType();
        if (videoPlayer.getVideoType() != VideoType.ContentVideo) {
            this.setComponentVisibility(8);
        } else {
            this.setComponentVisibility(0);
        }
    }

    @Override
    public void setComponentVisibility(int visibility) {
        super.setComponentVisibility(this.videoType == VideoType.StartVideo || this.videoType == VideoType.EndVideo ? 8 : visibility);
    }

    @Override
    public void onComponentEvent(int eventCode, Bundle bundle) {
        super.onComponentEvent(eventCode, bundle);
        if (eventCode == -80033) {
            this.isLock = bundle.getBoolean("bool_data");
        }
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        super.onCustomEvent(eventCode, bundle);
        if (eventCode == -80035) {
            this.enableSeekCtrl = bundle.getBoolean("bool_data");
            this.maxSeekTime = bundle.getInt("int_data", Integer.MAX_VALUE);
        }
    }

    private void onProgressSlide(float percent) {
        int position = this.getVideoPlayer().getCurrentPosition();
        if (position >= this.maxSeekTime) {
            this.setFastForwardState(false);
            this.newPosition = 0;
            return;
        }
        int duration = this.getVideoPlayer().getDuration();
        int deltaMax = Math.min(100, duration - position);
        int delta = (int)((float)deltaMax * percent);
        this.newPosition = delta + position;
        if (this.newPosition >= this.maxSeekTime) {
            this.newPosition = this.maxSeekTime;
        }
        if (this.newPosition > duration) {
            this.newPosition = duration;
        } else if (this.newPosition <= 0) {
            this.newPosition = 0;
            delta = -position;
        }
        this.setBrightnessBoxState(false);
        this.setVolumeBoxState(false);
        this.setFastForwardState(true);
        String durationText = VideoPlayerUtils.formatDuration((int)duration);
        String positionText = VideoPlayerUtils.formatDuration((int)this.newPosition, (duration >= 3600 ? 1 : 0) != 0);
        this.fastForwardIv.setImageResource(delta > 0 ? R.drawable.bjplayer_ic_kuaijin : R.drawable.bjplayer_ic_huitui);
        this.fastForwardTv.setText((CharSequence)String.format("%s/%s", positionText, durationText));
    }

    private void onBrightnessSlide(float percent) {
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (this.brightness < 0.0f) {
            this.brightness = activity.getWindow().getAttributes().screenBrightness;
            if (this.brightness <= 0.0f) {
                this.brightness = 0.5f;
            } else if (this.brightness < 0.01f) {
                this.brightness = 0.01f;
            }
        }
        WindowManager.LayoutParams lpa = activity.getWindow().getAttributes();
        lpa.screenBrightness = this.brightness + percent;
        if (lpa.screenBrightness > 1.0f) {
            lpa.screenBrightness = 1.0f;
        } else if (lpa.screenBrightness < 0.01f) {
            lpa.screenBrightness = 0.01f;
        }
        activity.getWindow().setAttributes(lpa);
        this.setVolumeBoxState(false);
        this.setFastForwardState(false);
        this.setBrightnessBoxState(true);
        this.brightnessTv.setText((CharSequence)((int)(lpa.screenBrightness * 100.0f) + "%"));
    }

    private void onVolumeSlide(float percent) {
        if (this.volume == -1) {
            this.volume = this.audioManager.getStreamVolume(3);
            this.volume = Math.max(0, this.volume);
        }
        int index = (int)(percent * (float)this.mMaxVolume) + this.volume;
        index = Math.min(Math.max(0, index), this.mMaxVolume);
        this.audioManager.setStreamVolume(3, index, 0);
        this.setVolumeBoxState(true);
        this.setBrightnessBoxState(false);
        this.setFastForwardState(false);
        int value = index * 100 / this.mMaxVolume;
        if (value == 0) {
            this.volumeTv.setText((CharSequence)"off");
            this.volumeIv.setImageResource(R.drawable.ic_volume_off_white);
        } else {
            this.volumeTv.setText((CharSequence)(value + "%"));
            this.volumeIv.setImageResource(R.drawable.ic_volume_up_white);
        }
    }

    @Override
    public void onSingleTapUp(MotionEvent event) {
    }

    @Override
    public void onDoubleTap(MotionEvent event) {
    }

    @Override
    public void onDown(MotionEvent event) {
        this.firstTouch = true;
    }

    @Override
    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.getView().getVisibility() == 8 || this.isLock) {
            return;
        }
        float oldX = e1.getX();
        float oldY = e1.getY();
        float deltaY = oldY - e2.getY();
        float deltaX = oldX - e2.getX();
        if (this.firstTouch) {
            this.toSeek = Math.abs(distanceX) >= Math.abs(distanceY);
            boolean bl = this.volumeControl = oldX > (float)this.mWidth * 0.5f;
            if (this.enableVolumeCtrl && !this.enableBrightnessCtrl) {
                this.volumeControl = true;
            } else if (!this.enableVolumeCtrl && this.enableBrightnessCtrl) {
                this.volumeControl = false;
            }
            this.firstTouch = false;
        }
        if (this.toSeek) {
            if (this.enableSeekCtrl) {
                this.onProgressSlide(-deltaX / (float)this.mWidth);
            }
        } else {
            float percent = deltaY / (float)this.mHeight;
            if (this.volumeControl) {
                if (this.enableVolumeCtrl) {
                    this.onVolumeSlide(percent);
                }
            } else if (this.enableBrightnessCtrl) {
                this.onBrightnessSlide(percent);
            }
        }
    }

    @Override
    public void onEndGesture() {
        if (this.isLongPress) {
            this.isLongPress = false;
            this.binding.longPressForwardContainer.setVisibility(8);
            this.getVideoPlayer().setPlayRate(this.playRate);
            if (this.animatedVector != null) {
                this.animatedVector.stop();
            }
        }
        this.volume = -1;
        this.brightness = -1.0f;
        this.setVolumeBoxState(false);
        this.setBrightnessBoxState(false);
        this.setFastForwardState(false);
        if (this.newPosition > 0) {
            Bundle bundle = BundlePool.obtain();
            bundle.putInt("int_data", this.newPosition);
            this.requestSeek(bundle);
            this.newPosition = 0;
        }
    }

    @Override
    public void duringComponentTouch(boolean isInTouch) {
    }

    @Override
    public void onLongPress() {
        this.isLongPress = true;
        this.playRate = this.getVideoPlayer().getPlayRate();
        this.binding.longPressForwardContainer.setVisibility(0);
        this.getVideoPlayer().setPlayRate(2.0f);
        if (this.animatedVector != null) {
            this.animatedVector.start();
        }
    }

    public void setVolumeBoxState(boolean state) {
        if (this.volumeLl != null) {
            this.volumeLl.setVisibility(state ? 0 : 8);
        }
    }

    public void setBrightnessBoxState(boolean state) {
        if (this.brightnessLl != null) {
            this.brightnessLl.setVisibility(state ? 0 : 8);
        }
    }

    private void setFastForwardState(boolean state) {
        this.fastForwardLl.setVisibility(state ? 0 : 8);
    }

    private Activity getActivity() {
        Context context = this.getContext();
        if (context instanceof Activity) {
            return (Activity)context;
        }
        return null;
    }
}

