/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.SeekBar;
import android.widget.TextView;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.constant.VideoType;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.listener.CallbackManager;
import com.baijiayun.videoplayer.ui.listener.OnTouchGestureListener;
import com.baijiayun.videoplayer.ui.subtitle.SubtitleView;
import com.baijiayun.videoplayer.ui.utils.NetworkUtils;
import com.baijiayun.videoplayer.util.VideoPlayerUtils;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ControllerComponent
extends BaseComponent
implements OnTouchGestureListener {
    private final int MSG_CODE_DELAY_HIDDEN_CONTROLLER = 101;
    private final int MSG_ARG_SINGLE_TAP_WAIT = -1;
    private final int HIDDEN_TIME = 5000;
    private View mTopContainer;
    private View mBottomContainer;
    private TextView mTopTitle;
    private ImageView mStateIcon;
    private TextView mCurrTime;
    private TextView mTotalTime;
    private ImageView mSwitchScreen;
    private SeekBar mSeekBar;
    private TextView subtitleIcon;
    private SubtitleView subtitleView;
    private TextView mFrameView;
    private TextView mCdnView;
    private TextView mRatioView;
    private TextView mRoomOutlineView;
    private ImageView lockView;
    private ImageView mBackIv;
    private ImageView gestureSwitchIv;
    private ImageView mPiPIv;
    private ImageView mPreviewIv;
    private ImageView mNextIv;
    private ImageView mScreenshotIv;
    private ImageView mScreenshotIvV;
    private TextView mAlbumTv;
    private ViewGroup seekContainer;
    private ImageView ivRewind;
    private ImageView ivForward;
    private TextView tvSeekTime;
    private Disposable disposableOfRewind;
    private Disposable disposableOfForward;
    private int seekTime = 30;
    private ListPopupWindow popupWindow;
    private int mBufferPercentage;
    private int mSeekProgress = -1;
    private boolean hasRoomOutline = false;
    private boolean isShowingRoomOutline = false;
    private ObjectAnimator mBottomAnimator;
    private ObjectAnimator mTopAnimator;
    private boolean forbidLockView;
    private boolean isLock;
    private NotificationControlBroadcastReceiver broadcastReceiver;
    private boolean seekEnable = true;
    private int maxSeekTime = Integer.MAX_VALUE;
    private boolean enableToggleScreen = true;
    private boolean showBackButton = true;
    private boolean enableVideoRate = true;
    private boolean isUserDragging;
    private Disposable disposableOfCDNCountChange;
    private String title = "";
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 101) {
                if (msg.arg1 == -1) {
                    ControllerComponent.this.setControllerState(!ControllerComponent.this.isControllerShow());
                    ControllerComponent.this.mHandler.sendEmptyMessageDelayed(101, 5000L);
                } else {
                    ControllerComponent.this.setControllerState(false);
                }
            }
        }
    };
    private Runnable mSeekEventRunnable = () -> {
        if (this.mSeekProgress < 0) {
            return;
        }
        Bundle bundle = BundlePool.obtain();
        bundle.putInt("int_data", this.mSeekProgress);
        this.requestSeek(bundle);
    };
    private boolean hasSubtitle = false;

    public ControllerComponent(Context context) {
        super(context);
        this.broadcastReceiver = new NotificationControlBroadcastReceiver();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("action_notification_control_play");
        if (Build.VERSION.SDK_INT >= 33) {
            context.registerReceiver((BroadcastReceiver)this.broadcastReceiver, intentFilter, 4);
        } else {
            context.registerReceiver((BroadcastReceiver)this.broadcastReceiver, intentFilter);
        }
        this.initView();
        this.setComponentVisibility(8);
    }

    @Override
    protected View onCreateComponentView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjy_pb_layout_controller_component, null);
    }

    @Override
    public void onPlayerEvent(int eventCode, Bundle bundle) {
        block0 : switch (eventCode) {
            case -99031: {
                PlayerStatus status = (PlayerStatus)bundle.getSerializable("serializable_data");
                if (status == null) break;
                switch (status) {
                    case STATE_PAUSED: {
                        this.mStateIcon.setSelected(true);
                        break block0;
                    }
                    case STATE_STARTED: {
                        this.mStateIcon.setSelected(false);
                        this.sendDelayHiddenMessage();
                        this.updateSubtitleIcon();
                        this.updateScreenshotIcon();
                        break block0;
                    }
                    case STATE_INITIALIZED: {
                        this.mBufferPercentage = 0;
                        int duration = this.getVideoPlayer().getDuration();
                        if (duration < 0) {
                            duration = 0;
                        }
                        this.updateUI(0, duration);
                        if (this.getVideoPlayer().getVideoInfo() != null && TextUtils.isEmpty((CharSequence)this.title)) {
                            this.setTitle(this.getVideoPlayer().getVideoInfo().getVideoTitle());
                            break block0;
                        }
                        this.setTitle(this.title);
                        break block0;
                    }
                    case STATE_IDLE: {
                        this.setTitle("");
                        break block0;
                    }
                    case STATE_PREPARED: {
                        if (this.getVideoPlayer().getVideoInfo() != null) {
                            int videoDuration = this.getVideoPlayer().getDuration();
                            int memoryPoint = this.getVideoPlayer().getVideoMemoryPoint();
                            this.updateUI(memoryPoint, videoDuration);
                        }
                        this.subtitleView.setCues(null);
                        break block0;
                    }
                }
                break;
            }
            case -99019: {
                int currentTime = bundle.getInt("int_data");
                if (currentTime >= this.maxSeekTime) {
                    this.mSeekBar.setEnabled(false);
                    this.isUserDragging = false;
                }
                if (!this.isUserDragging) {
                    this.updateUI(currentTime, this.getVideoPlayer().getDuration());
                }
                if (this.getVideoPlayer().getPlayerStatus() != PlayerStatus.STATE_PLAYBACK_COMPLETED || currentTime != this.getVideoPlayer().getDuration()) break;
                this.mStateIcon.setSelected(true);
                this.mSeekProgress = 0;
                this.mHandler.removeCallbacks(this.mSeekEventRunnable);
                this.mHandler.postDelayed(this.mSeekEventRunnable, 300L);
                break;
            }
            case -99012: {
                this.setSecondProgress(bundle.getInt("int_data"));
                break;
            }
        }
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        super.onCustomEvent(eventCode, bundle);
        block0 : switch (eventCode) {
            case -80006: {
                this.setSwitchScreenIcon(this.isLandscape);
                this.sendDelayHiddenMessage();
                this.updateSubtitleIcon();
                this.updateScreenshotIcon();
                this.updateSwitchPosition(this.isLandscape);
                this.setControllerState(!this.isLandscape || !this.isLock);
                this.lockView.setSelected(this.isLock && this.isLandscape);
                this.notifyComponentEvent(-80033, BundlePool.obtain((this.isLock && this.isLandscape ? 1 : 0) != 0));
                break;
            }
            case -80012: {
                this.mStateIcon.setSelected(false);
                break;
            }
            case -80016: {
                this.toggleController();
                break;
            }
            case -80014: {
                if (bundle.getBoolean("bool_data")) break;
                this.setControllerState(false);
                break;
            }
            case -80019: {
                this.subtitleView.setCues(bundle.getParcelableArrayList("subtitle"));
                break;
            }
            case -80028: {
                this.hasRoomOutline = bundle.getBoolean("bool_data");
                this.mRoomOutlineView.post(() -> this.mRoomOutlineView.setVisibility(this.hasRoomOutline && this.isLandscape ? 0 : 8));
                break;
            }
            case -80032: {
                this.forbidLockView = true;
                this.lockView.setVisibility(8);
                break;
            }
            case -80035: {
                this.seekEnable = bundle.getBoolean("bool_data");
                this.maxSeekTime = bundle.getInt("int_data", Integer.MAX_VALUE);
                if (this.seekEnable && this.mSeekBar.getProgress() < this.maxSeekTime) {
                    this.mSeekBar.setEnabled(true);
                    this.seekContainer.setVisibility(0);
                    break;
                }
                this.mSeekBar.setEnabled(false);
                this.seekContainer.setVisibility(4);
                if (this.popupWindow != null) {
                    this.popupWindow.dismiss();
                }
                this.isUserDragging = false;
                break;
            }
            case -80038: {
                this.enableVideoRate = bundle.getBoolean("bool_data");
                if (this.enableVideoRate) break;
                this.mRatioView.setVisibility(8);
                break;
            }
            case -80036: {
                this.enableToggleScreen = bundle.getBoolean("bool_data");
                this.mSwitchScreen.setVisibility(this.enableToggleScreen ? 0 : 8);
                break;
            }
            case -80037: {
                this.showBackButton = bundle.getBoolean("bool_data");
                this.mBackIv.setVisibility(this.showBackButton ? 0 : 8);
                break;
            }
            case -80042: {
                if (bundle.getBoolean("bool_data")) {
                    this.gestureSwitchIv.setVisibility(0);
                    this.notifyComponentEvent(-80041, BundlePool.obtain((boolean)this.gestureSwitchIv.isSelected()));
                    break;
                }
                this.gestureSwitchIv.setVisibility(8);
                break;
            }
            case -80052: {
                boolean isSelected = bundle.getBoolean("bool_data");
                this.gestureSwitchIv.setSelected(isSelected);
                break;
            }
            case -80047: {
                boolean enableAlbum = bundle.getBoolean("bool_data");
                this.mAlbumTv.setVisibility(enableAlbum ? 0 : 8);
                this.mAlbumTv.setText((CharSequence)bundle.getString("string_data"));
                break;
            }
            case -80002: {
                int seekToPos = bundle.getInt("int_data");
                this.updateUI(seekToPos, this.getVideoPlayer().getDuration());
                this.subtitleView.setCues(null);
                break;
            }
            case -80045: {
                switch (bundle.getInt("int_data", -1)) {
                    case 0: {
                        this.updateChangeVideoEnable(true, false, true);
                        break block0;
                    }
                    case 1: {
                        this.updateChangeVideoEnable(true, true, true);
                        break block0;
                    }
                    case 2: {
                        this.updateChangeVideoEnable(true, true, false);
                        break block0;
                    }
                }
                this.updateChangeVideoEnable(false, false, false);
                break;
            }
            case -80050: {
                this.title = bundle.getString("string_data");
                this.setTitle(this.title);
                break;
            }
        }
    }

    private void updateScreenshotIcon() {
        if (BJYPlayerSDK.enableScreenshot == null) {
            this.mScreenshotIv.setVisibility(8);
            this.mScreenshotIvV.setVisibility(8);
        } else {
            this.mScreenshotIv.setVisibility(BJYPlayerSDK.enableScreenshot != false && this.isLandscape ? 0 : 8);
            this.mScreenshotIvV.setVisibility(BJYPlayerSDK.enableScreenshot != false && !this.isLandscape && this.isControllerShow() ? 0 : 8);
            if (BJYPlayerSDK.enableScreenshot.booleanValue() && !this.isLandscape) {
                this.mScreenshotIvV.setImageResource(R.drawable.bjy_pb_ic_screenshot_shadow);
            }
            if (BJYPlayerSDK.enableScreenshot.booleanValue() && this.isLandscape) {
                this.mScreenshotIvV.setImageResource(R.drawable.bjy_pb_ic_screenshot);
            }
        }
    }

    private void updateChangeVideoEnable(boolean isVisibility, boolean preEnable, boolean nextEnable) {
        if (isVisibility) {
            this.mPreviewIv.setVisibility(0);
            this.mPreviewIv.setEnabled(preEnable);
            this.mPreviewIv.setAlpha(preEnable ? 1.0f : 0.6f);
            this.mNextIv.setVisibility(0);
            this.mNextIv.setEnabled(nextEnable);
            this.mNextIv.setAlpha(nextEnable ? 1.0f : 0.6f);
        } else {
            this.mPreviewIv.setVisibility(8);
            this.mNextIv.setVisibility(8);
        }
    }

    @Override
    public void onComponentEvent(int eventCode, Bundle bundle) {
        block0 : switch (eventCode) {
            case -80002: {
                int seekToPos = bundle.getInt("int_data");
                this.updateUI(seekToPos, this.getVideoPlayer().getDuration());
                this.subtitleView.setCues(null);
                break;
            }
            case -80022: 
            case -80021: {
                this.subtitleView.setCues(null);
                break;
            }
            case -80024: {
                if (this.getVideoPlayer() == null) {
                    return;
                }
                if (this.getVideoPlayer().getCDNCount() == 0) {
                    this.mCdnView.setVisibility(8);
                } else {
                    this.mCdnView.setVisibility(0);
                    this.mCdnView.setText((CharSequence)this.getContext().getString(R.string.bjy_pb_cdn, new Object[]{this.getVideoPlayer().getCDNIndex() + 1}));
                }
                int type = bundle.getInt("type", -1);
                switch (type) {
                    case 0: {
                        String definition = bundle.getString("definition");
                        if (definition == null) {
                            this.mFrameView.setVisibility(8);
                            break block0;
                        }
                        this.mFrameView.setVisibility(0);
                        this.mFrameView.setText((CharSequence)definition);
                        break block0;
                    }
                    case 1: {
                        String ratio = bundle.getString("ratio");
                        this.mRatioView.setText((CharSequence)ratio);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void initView() {
        this.mTopContainer = this.findViewById(R.id.cover_player_controller_top_container);
        this.mBottomContainer = this.findViewById(R.id.cover_player_controller_bottom_container);
        this.mBackIv = (ImageView)this.findViewById(R.id.cover_player_controller_image_view_back_icon);
        this.mTopTitle = (TextView)this.findViewById(R.id.cover_player_controller_text_view_video_title);
        this.mStateIcon = (ImageView)this.findViewById(R.id.cover_player_controller_image_view_play_state);
        this.mCurrTime = (TextView)this.findViewById(R.id.cover_player_controller_text_view_curr_time);
        this.mTotalTime = (TextView)this.findViewById(R.id.cover_player_controller_text_view_total_time);
        this.mSwitchScreen = (ImageView)this.findViewById(R.id.cover_player_controller_image_view_switch_screen);
        this.mSeekBar = (SeekBar)this.findViewById(R.id.cover_player_controller_seek_bar);
        this.subtitleIcon = (TextView)this.findViewById(R.id.cover_player_controller_subtitle);
        this.subtitleView = (SubtitleView)((Object)this.findViewById(R.id.cover_player_controller_subtitle_view));
        this.mFrameView = (TextView)this.findViewById(R.id.cover_player_controller_frame);
        this.mCdnView = (TextView)this.findViewById(R.id.cover_player_controller_cdn);
        this.mRatioView = (TextView)this.findViewById(R.id.cover_player_controller_rate);
        this.mRoomOutlineView = (TextView)this.findViewById(R.id.cover_player_controller_room_outline);
        this.lockView = (ImageView)this.findViewById(R.id.controller_lock_iv);
        this.gestureSwitchIv = (ImageView)this.findViewById(R.id.cover_player_controller_gesture_switch);
        this.mPiPIv = (ImageView)this.findViewById(R.id.cover_player_controller_pip);
        this.mPreviewIv = (ImageView)this.findViewById(R.id.cover_player_controller_image_view_play_previous);
        this.mNextIv = (ImageView)this.findViewById(R.id.cover_player_controller_image_view_play_next);
        this.mAlbumTv = (TextView)this.findViewById(R.id.cover_player_controller_album);
        this.mScreenshotIv = (ImageView)this.findViewById(R.id.cover_player_controller_image_view_screenshot);
        this.mScreenshotIvV = (ImageView)this.findViewById(R.id.cover_player_controller_image_view_screenshot_v);
        this.mPiPIv.setVisibility(BJYPlayerSDK.supportPiP ? 0 : 8);
        this.seekContainer = (ViewGroup)this.findViewById(R.id.cover_player_controller_seek_container);
        this.ivRewind = (ImageView)this.findViewById(R.id.cover_player_controller_iv_rewind);
        this.ivForward = (ImageView)this.findViewById(R.id.cover_player_controller_iv_forward);
        this.tvSeekTime = (TextView)this.findViewById(R.id.cover_player_controller_tv_seek_time);
        this.seekContainer.setBackground(new DrawableBuilder().solidColor(Color.parseColor((String)"#66000000")).cornerRadius(UtilsKt.getDp((int)30)).build());
        this.tvSeekTime.setBackground(new DrawableBuilder().solidColor(Color.parseColor((String)"#66000000")).solidColorPressed(Integer.valueOf(Color.parseColor((String)"#FF1795FF"))).cornerRadius(UtilsKt.getDp((int)30)).build());
        this.disposableOfRewind = RxUtils.clicks((View)this.ivRewind).throttleFirst(1000L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(integer -> {
            int currentPosition = this.getVideoPlayer().getCurrentPosition();
            int position = Math.max(currentPosition - this.seekTime, 0);
            Bundle bundle = BundlePool.obtain();
            bundle.putInt("int_data", position);
            this.requestSeek(bundle);
        });
        this.disposableOfForward = RxUtils.clicks((View)this.ivForward).throttleFirst(1000L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(integer -> {
            int currentPosition = this.getVideoPlayer().getCurrentPosition();
            int duration = this.getVideoPlayer().getDuration();
            int position = Math.min(currentPosition + this.seekTime, duration);
            Bundle bundle = BundlePool.obtain();
            bundle.putInt("int_data", position);
            this.requestSeek(bundle);
        });
        this.tvSeekTime.setText((CharSequence)this.getContext().getString(R.string.bjy_pb_countdown, new Object[]{this.seekTime}));
        this.tvSeekTime.setOnClickListener(v -> {
            ArrayList<String> seekTimeStringList = new ArrayList<String>();
            List<Integer> seekTimeList = Arrays.asList(60, 50, 40, 30, 20, 10);
            for (int time : seekTimeList) {
                seekTimeStringList.add(this.getContext().getString(R.string.bjy_pb_countdown, new Object[]{time}));
            }
            int selectedPosition = seekTimeList.indexOf(this.seekTime);
            HighlightAdapter adapter2 = new HighlightAdapter(this.getContext(), seekTimeStringList, selectedPosition);
            this.popupWindow = new ListPopupWindow(this.getContext());
            this.popupWindow.setBackgroundDrawable(new DrawableBuilder().solidColor(Color.parseColor((String)"#66000000")).cornerRadius(UtilsKt.getDp((int)6)).build());
            this.popupWindow.setAdapter((ListAdapter)adapter2);
            this.popupWindow.setWidth(UtilsKt.getDp((int)80));
            this.popupWindow.setHeight(UtilsKt.getDp((int)180));
            this.popupWindow.setAnchorView((View)this.tvSeekTime);
            this.popupWindow.setHorizontalOffset(-(UtilsKt.getDp((int)80) - this.tvSeekTime.getMeasuredWidth()) / 2);
            if (this.isLandscape) {
                this.popupWindow.setVerticalOffset(-(UtilsKt.getDp((int)184) + this.tvSeekTime.getMeasuredHeight()));
            } else {
                this.popupWindow.setVerticalOffset(UtilsKt.getDp((int)8));
            }
            this.popupWindow.setOnItemClickListener((parent, view, position, id2) -> {
                this.tvSeekTime.setText((CharSequence)seekTimeStringList.get(position));
                this.seekTime = (Integer)seekTimeList.get(position);
                adapter2.updateIndex(position);
                this.popupWindow.dismiss();
            });
            this.popupWindow.show();
            if (this.popupWindow.getListView() != null) {
                this.popupWindow.getListView().setVerticalScrollBarEnabled(false);
            }
        });
        this.setBottomPaddingFraction(true);
        this.updateSwitchPosition(this.isLandscape);
        this.mBackIv.setOnClickListener(v -> this.notifyComponentEvent(-80007, null));
        this.mStateIcon.setOnClickListener(v -> {
            boolean selected = this.mStateIcon.isSelected();
            if (selected) {
                this.requestPlay(null);
            } else {
                this.requestPause(null);
            }
            this.mStateIcon.setSelected(!selected);
        });
        this.mSwitchScreen.setOnClickListener(v -> {
            this.isLandscape = !this.isLandscape;
            this.notifyComponentEvent(-80006, BundlePool.obtain((boolean)this.isLandscape));
        });
        this.mScreenshotIv.setOnClickListener(v -> this.notifyComponentEvent(-80053, BundlePool.obtain()));
        this.mScreenshotIvV.setOnClickListener(v -> this.notifyComponentEvent(-80053, BundlePool.obtain()));
        this.mSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    progress = Math.min(progress, ControllerComponent.this.maxSeekTime);
                    ControllerComponent.this.updateUI(progress, seekBar.getMax());
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                ControllerComponent.this.isUserDragging = true;
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                ControllerComponent.this.isUserDragging = false;
                ControllerComponent.this.mSeekProgress = seekBar.getProgress();
                if (ControllerComponent.this.mSeekProgress >= ControllerComponent.this.maxSeekTime) {
                    seekBar.setEnabled(false);
                }
                ControllerComponent.this.mHandler.removeCallbacks(ControllerComponent.this.mSeekEventRunnable);
                ControllerComponent.this.mHandler.postDelayed(ControllerComponent.this.mSeekEventRunnable, 300L);
            }
        });
        this.subtitleIcon.setOnClickListener(v -> {
            this.setSubtitleSelectViewState(true);
            Bundle bundle = new Bundle();
            bundle.putInt("req_toggle_menu", -80027);
            this.notifyComponentEvent(-80023, bundle);
        });
        this.mRatioView.setOnClickListener(v -> {
            this.setSubtitleSelectViewState(false);
            Bundle bundle = new Bundle();
            bundle.putInt("req_toggle_menu", -80027);
            this.notifyComponentEvent(-80023, bundle);
            Bundle bundle1 = new Bundle();
            bundle1.putInt("req_toggle_menu", -80025);
            bundle1.putInt("controller_button_x", (this.mRatioView.getLeft() + this.mRatioView.getRight()) / 2);
            bundle1.putInt("controller_button_y", UtilsKt.getDp((int)36));
            this.notifyComponentEvent(-80023, bundle1);
        });
        this.mFrameView.setOnClickListener(v -> {
            this.setSubtitleSelectViewState(false);
            Bundle bundle = new Bundle();
            bundle.putInt("req_toggle_menu", -80027);
            this.notifyComponentEvent(-80023, bundle);
            Bundle bundle1 = new Bundle();
            bundle1.putInt("req_toggle_menu", -80026);
            bundle1.putInt("controller_button_x", (this.mFrameView.getLeft() + this.mFrameView.getRight()) / 2);
            bundle1.putInt("controller_button_y", UtilsKt.getDp((int)36));
            this.notifyComponentEvent(-80023, bundle1);
        });
        this.mCdnView.setOnClickListener(v -> {
            this.setSubtitleSelectViewState(false);
            Bundle bundle = new Bundle();
            bundle.putInt("req_toggle_menu", -80027);
            this.notifyComponentEvent(-80023, bundle);
            Bundle bundle1 = new Bundle();
            bundle1.putInt("req_toggle_menu", -80051);
            bundle1.putInt("controller_button_x", (this.mCdnView.getLeft() + this.mCdnView.getRight()) / 2);
            bundle1.putInt("controller_button_y", UtilsKt.getDp((int)36));
            this.notifyComponentEvent(-80023, bundle1);
        });
        this.mRoomOutlineView.setOnClickListener(v -> {
            if (!this.isShowingRoomOutline && this.hasRoomOutline) {
                this.setSubtitleSelectViewState(false);
                Bundle bundle = new Bundle();
                bundle.putInt("req_toggle_menu", -80027);
                this.notifyComponentEvent(-80023, bundle);
                Bundle bundle1 = new Bundle();
                bundle1.putInt("req_toggle_menu", -80030);
                this.notifyComponentEvent(-80023, bundle1);
                this.isShowingRoomOutline = true;
            } else {
                Bundle bundle = new Bundle();
                bundle.putInt("req_toggle_menu", -80027);
                this.notifyComponentEvent(-80023, bundle);
                this.isShowingRoomOutline = false;
            }
        });
        this.lockView.setOnClickListener(v -> {
            boolean isSelected = this.lockView.isSelected();
            this.lockView.setSelected(!isSelected);
            this.setControllerState(isSelected);
            this.isLock = !isSelected;
            this.notifyComponentEvent(-80033, BundlePool.obtain((boolean)this.isLock));
        });
        this.gestureSwitchIv.setOnClickListener(v -> {
            this.gestureSwitchIv.setSelected(!this.gestureSwitchIv.isSelected());
            this.notifyComponentEvent(-80041, BundlePool.obtain((boolean)this.gestureSwitchIv.isSelected()));
        });
        this.mPiPIv.setOnClickListener(v -> {
            this.mPiPIv.setSelected(!this.mPiPIv.isSelected());
            this.notifyComponentEvent(-80048, BundlePool.obtain((boolean)this.mPiPIv.isSelected()));
        });
        this.mPreviewIv.setOnClickListener(v -> this.notifyComponentEvent(-80043, null));
        this.mNextIv.setOnClickListener(v -> this.notifyComponentEvent(-80044, null));
        this.mAlbumTv.setOnClickListener(v -> {
            if (CallbackManager.getInstance().getExternalAlbumListener() != null) {
                CallbackManager.getInstance().getExternalAlbumListener().onExternalAlbumClick();
            } else {
                this.notifyComponentEvent(-80046, null);
            }
        });
        this.notifyComponentEvent(-80020, BundlePool.obtain((boolean)this.gestureSwitchIv.isSelected()));
        this.mSeekBar.setEnabled(this.seekEnable && this.mSeekBar.getProgress() < this.maxSeekTime);
        this.isUserDragging = false;
        this.mSwitchScreen.setVisibility(this.enableToggleScreen ? 0 : 8);
        if (CallbackManager.getInstance().getShareListener() != null) {
            ImageView shareIv = (ImageView)this.findViewById(R.id.cover_player_controller_share_iv);
            shareIv.setVisibility(0);
            shareIv.setOnClickListener(v -> CallbackManager.getInstance().getShareListener().onShareClicked(String.valueOf(this.getVideoPlayer().getVideoInfo().getVideoId())));
        }
    }

    @Override
    public void bindVideoPlayer(IBJYVideoPlayer videoPlayer) {
        super.bindVideoPlayer(videoPlayer);
        this.disposableOfCDNCountChange = videoPlayer.getObservableOfCDNCountChange().observeOn(AndroidSchedulers.mainThread()).subscribe(index -> this.mCdnView.setText((CharSequence)this.getContext().getString(R.string.bjy_pb_cdn, new Object[]{this.getVideoPlayer().getCDNIndex() + 1})));
        videoPlayer.addOnVideoTypeChangeListener(videoType -> {
            if (videoType != VideoType.ContentVideo) {
                this.setComponentVisibility(8);
                this.mPiPIv.setSelected(true);
                this.notifyComponentEvent(-80048, BundlePool.obtain((boolean)false));
            } else {
                this.setComponentVisibility(0);
            }
        });
        if (videoPlayer.getVideoType() != VideoType.ContentVideo) {
            this.setComponentVisibility(8);
        } else {
            this.setComponentVisibility(0);
        }
    }

    @Override
    protected void setKey() {
        this.key = "controller_component";
    }

    private void setSubtitleSelectViewState(boolean state) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("req_toggle_subtitle", state);
        this.notifyComponentEvent(-80020, bundle);
    }

    private void setControllerState(boolean show) {
        if (show) {
            this.sendDelayHiddenMessage();
        } else {
            if (this.isShowingRoomOutline) {
                this.isShowingRoomOutline = false;
            }
            this.removeDelayHiddenMessage();
        }
        this.setTopContainerState(show);
        this.setBottomContainerState(show);
        this.lockView.setVisibility(!this.forbidLockView && this.isLandscape && show ? 0 : 8);
        this.notifyComponentEvent(-80034, BundlePool.obtain((boolean)show));
        this.setBottomPaddingFraction(show);
    }

    private boolean isControllerShow() {
        return this.mBottomContainer.getVisibility() == 0;
    }

    private void toggleController() {
        if (!this.getVideoPlayer().isPlayLocalVideo() && !NetworkUtils.isNetConnected(this.getContext())) {
            return;
        }
        Message message = new Message();
        message.what = 101;
        message.arg1 = -1;
        this.mHandler.sendMessageDelayed(message, 300L);
    }

    private void sendDelayHiddenMessage() {
        this.removeDelayHiddenMessage();
        this.mHandler.sendEmptyMessageDelayed(101, 5000L);
    }

    private void removeDelayHiddenMessage() {
        this.mHandler.removeMessages(101);
    }

    private void setCurrTime(int curr, int duration) {
        this.mCurrTime.setText((CharSequence)VideoPlayerUtils.formatDuration((int)curr, (duration >= 3600 ? 1 : 0) != 0));
    }

    private void setTotalTime(int duration) {
        this.mTotalTime.setText((CharSequence)VideoPlayerUtils.formatDuration((int)duration));
    }

    private void setSeekProgress(int curr, int duration) {
        this.mSeekBar.setMax(duration);
        this.mSeekBar.setProgress(curr);
        float secondProgress = (float)this.mBufferPercentage * 1.0f / 100.0f * (float)duration;
        this.mSeekBar.setSecondaryProgress((int)secondProgress);
    }

    private void setSecondProgress(int bufferPercent) {
        this.mBufferPercentage = bufferPercent;
        float secondProgress = (float)this.mBufferPercentage * 1.0f / 100.0f * (float)this.mSeekBar.getMax();
        this.mSeekBar.setSecondaryProgress((int)secondProgress);
    }

    private void setTitle(String text) {
        this.mTopTitle.setText((CharSequence)text);
    }

    private void setSwitchScreenIcon(boolean isFullScreen) {
        this.mSwitchScreen.setImageResource(isFullScreen ? R.drawable.icon_exit_full_screen : R.drawable.icon_full_screen);
    }

    private void updateSwitchPosition(boolean isLandscape) {
        this.mRatioView.setVisibility(this.enableVideoRate ? 0 : 8);
        this.subtitleIcon.setVisibility(this.hasSubtitle ? 0 : 8);
        this.mRoomOutlineView.setVisibility(this.hasRoomOutline && isLandscape ? 0 : 8);
        this.lockView.setVisibility(!this.forbidLockView && isLandscape ? 0 : 8);
    }

    private void updateUI(int curr, int duration) {
        if (this.seekEnable && curr < this.maxSeekTime) {
            this.mSeekBar.setEnabled(true);
        }
        this.setSeekProgress(curr, duration);
        this.setCurrTime(curr, duration);
        this.setTotalTime(duration);
    }

    private void setTopContainerState(final boolean show) {
        this.mTopContainer.clearAnimation();
        this.cancelTopAnimation();
        this.mTopAnimator = ObjectAnimator.ofFloat((Object)this.mTopContainer, (String)"alpha", (float[])new float[]{show ? 0.0f : 1.0f, show ? 1.0f : 0.0f}).setDuration(300L);
        this.mTopAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (show) {
                    ControllerComponent.this.mTopContainer.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (!show) {
                    ControllerComponent.this.mTopContainer.setVisibility(8);
                }
            }
        });
        this.mTopAnimator.start();
    }

    private void cancelBottomAnimation() {
        if (this.mBottomAnimator != null) {
            this.mBottomAnimator.cancel();
            this.mBottomAnimator.removeAllListeners();
            this.mBottomAnimator.removeAllUpdateListeners();
        }
    }

    private void cancelTopAnimation() {
        if (this.mTopAnimator != null) {
            this.mTopAnimator.cancel();
            this.mTopAnimator.removeAllListeners();
            this.mTopAnimator.removeAllUpdateListeners();
        }
    }

    private void setBottomContainerState(final boolean show) {
        this.mBottomContainer.clearAnimation();
        this.cancelBottomAnimation();
        this.mBottomAnimator = ObjectAnimator.ofFloat((Object)this.mBottomContainer, (String)"alpha", (float[])new float[]{show ? 0.0f : 1.0f, show ? 1.0f : 0.0f}).setDuration(300L);
        this.mBottomAnimator.addUpdateListener(animation -> this.mSeekBar.setAlpha(((Float)animation.getAnimatedValue()).floatValue()));
        this.mBottomAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (show) {
                    ControllerComponent.this.mBottomContainer.setVisibility(0);
                    ControllerComponent.this.mSeekBar.setVisibility(0);
                    ControllerComponent.this.seekContainer.setVisibility(0);
                    ControllerComponent.this.updateScreenshotIcon();
                }
                ControllerComponent.this.mRoomOutlineView.setClickable(false);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (!show) {
                    ControllerComponent.this.mBottomContainer.setVisibility(4);
                    ControllerComponent.this.mSeekBar.setVisibility(4);
                    ControllerComponent.this.seekContainer.setVisibility(4);
                    if (ControllerComponent.this.popupWindow != null) {
                        ControllerComponent.this.popupWindow.dismiss();
                    }
                    ControllerComponent.this.mScreenshotIvV.setVisibility(8);
                }
                ControllerComponent.this.mRoomOutlineView.setClickable(true);
            }
        });
        this.mBottomAnimator.start();
    }

    @Override
    public void onSingleTapUp(MotionEvent event) {
        if (this.isLock) {
            this.lockView.setVisibility(this.lockView.getVisibility() == 0 ? 8 : 0);
        } else {
            this.toggleController();
        }
    }

    @Override
    public void onDoubleTap(MotionEvent event) {
        if (this.isLock) {
            return;
        }
        if (this.getVideoPlayer().getVideoType() != VideoType.ContentVideo) {
            return;
        }
        PlayerStatus status = this.getVideoPlayer().getPlayerStatus();
        if (status == PlayerStatus.STATE_PAUSED || status == PlayerStatus.STATE_PLAYBACK_COMPLETED) {
            this.requestPlay(null);
            this.setControllerState(false);
            this.removeDelayHiddenMessage();
            return;
        }
        if (status == PlayerStatus.STATE_STARTED) {
            this.requestPause(null);
            this.setControllerState(true);
            this.removeDelayHiddenMessage();
        }
    }

    @Override
    public void onDown(MotionEvent event) {
    }

    @Override
    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
    }

    @Override
    public void onEndGesture() {
    }

    @Override
    public void duringComponentTouch(boolean isInTouch) {
        if (this.isControllerShow()) {
            if (isInTouch) {
                this.removeDelayHiddenMessage();
            } else {
                this.sendDelayHiddenMessage();
            }
        }
    }

    @Override
    public void onLongPress() {
    }

    private void updateSubtitleIcon() {
        this.hasSubtitle = !VideoPlayerUtils.isEmptyList((List)this.getVideoPlayer().getVideoInfo().getSubtitleItemList());
        this.subtitleIcon.setVisibility(this.hasSubtitle ? 0 : 8);
    }

    @Override
    public void destroy() {
        if (this.broadcastReceiver != null) {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.broadcastReceiver);
        }
        super.destroy();
        RxUtils.dispose((Disposable)this.disposableOfCDNCountChange);
        RxUtils.dispose((Disposable)this.disposableOfForward);
        RxUtils.dispose((Disposable)this.disposableOfRewind);
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public void setBottomPaddingFraction(boolean showController) {
        float bottomPaddingFraction;
        float f = bottomPaddingFraction = showController ? 0.1f : 0.02f;
        if (!this.isLandscape) {
            bottomPaddingFraction *= 2.0f;
        }
        this.subtitleView.setBottomPaddingFraction(bottomPaddingFraction);
    }

    public class NotificationControlBroadcastReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("action_notification_control_play".equals(action)) {
                if (ControllerComponent.this.mStateIcon.isSelected()) {
                    ControllerComponent.this.requestPlay(null);
                } else {
                    ControllerComponent.this.requestPause(null);
                }
            }
        }
    }

    public static class HighlightAdapter
    extends ArrayAdapter<String> {
        private int selectedPosition;

        public HighlightAdapter(Context context, List<String> data, int selectedPos) {
            super(context, R.layout.bjy_pb_layout_seek_time, data);
            this.selectedPosition = selectedPos;
        }

        public void updateIndex(int selectedPosition) {
            this.selectedPosition = selectedPosition;
            this.notifyDataSetChanged();
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View view = super.getView(position, convertView, parent);
            TextView textView = (TextView)view.findViewById(R.id.tv);
            if (position == this.selectedPosition) {
                textView.setBackgroundColor(Color.parseColor((String)"#99000000"));
                textView.setTextColor(Color.parseColor((String)"#FF1795FF"));
            } else {
                textView.setBackgroundColor(0);
                textView.setTextColor(-1);
            }
            return view;
        }
    }
}

