/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.baijiayun.download.DownloadModel;
import com.baijiayun.playback.util.PBJsonUtils;
import com.baijiayun.videoplayer.ui.activity.PBRoomActivity;
import com.baijiayun.videoplayer.ui.activity.VideoListActivity;
import com.baijiayun.videoplayer.ui.activity.VideoPlayActivity;
import com.baijiayun.videoplayer.ui.activity.VideoPlayTripleActivity;
import com.baijiayun.videoplayer.ui.bean.VideoInfoModel;
import com.baijiayun.videoplayer.ui.bean.VideoPlayerConfig;
import java.io.Serializable;
import java.util.List;

public class PBRoomUI {
    public static void enterPBRoom(Context context, String roomId, String roomToken, String sessionId, OnEnterPBRoomFailedListener onEnterPBRoomFailedListener) {
        PBRoomUI.enterPBRoom(context, roomId, roomToken, sessionId, new VideoPlayerConfig(), onEnterPBRoomFailedListener);
    }

    public static void enterPBRoom(Context context, String roomId, String roomToken, String sessionId, VideoPlayerConfig playerConfig, OnEnterPBRoomFailedListener onEnterPBRoomFailedListener) {
        PBRoomUI.enterPBRoom(context, roomId, roomToken, sessionId, -1, playerConfig, onEnterPBRoomFailedListener);
    }

    public static void enterPBRoom(Context context, String roomId, String roomToken, String sessionId, int version, VideoPlayerConfig playerConfig, OnEnterPBRoomFailedListener onEnterPBRoomFailedListener) {
        try {
            if (Long.parseLong(roomId) <= 0L) {
                if (onEnterPBRoomFailedListener != null) {
                    onEnterPBRoomFailedListener.onEnterPBRoomFailed("invalid room id");
                }
                return;
            }
        }
        catch (Exception e) {
            if (onEnterPBRoomFailedListener != null) {
                onEnterPBRoomFailedListener.onEnterPBRoomFailed("invalid room id");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)roomToken)) {
            if (onEnterPBRoomFailedListener != null) {
                onEnterPBRoomFailedListener.onEnterPBRoomFailed("invalid room token");
            }
            return;
        }
        Intent intent = new Intent(context, PBRoomActivity.class);
        intent.putExtra("pb_room_id", roomId);
        intent.putExtra("pb_room_token", roomToken);
        intent.putExtra("pb_room_session_id", sessionId);
        intent.putExtra("pb_room_version", version);
        if (playerConfig == null) {
            playerConfig = new VideoPlayerConfig();
        }
        intent.putExtra("videoPlayerConfig", (Serializable)playerConfig);
        context.startActivity(intent);
    }

    public static void enterPBRoom(Context context, String mixedId, String mixedToken, OnEnterPBRoomFailedListener onEnterPBRoomFailedListener) {
        PBRoomUI.enterPBRoom(context, mixedId, mixedToken, new VideoPlayerConfig(), onEnterPBRoomFailedListener);
    }

    public static void enterPBRoom(Context context, String mixedId, String mixedToken, VideoPlayerConfig playerConfig, OnEnterPBRoomFailedListener onEnterPBRoomFailedListener) {
        if (TextUtils.isEmpty((CharSequence)mixedId)) {
            if (onEnterPBRoomFailedListener != null) {
                onEnterPBRoomFailedListener.onEnterPBRoomFailed("invalid mixed id");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)mixedToken)) {
            if (onEnterPBRoomFailedListener != null) {
                onEnterPBRoomFailedListener.onEnterPBRoomFailed("invalid mixed token");
            }
            return;
        }
        Intent intent = new Intent(context, PBRoomActivity.class);
        intent.putExtra("pb_room_mixed_id", mixedId);
        intent.putExtra("pb_room_mixed_token", mixedToken);
        intent.putExtra("pb_room_is_mixed", true);
        intent.putExtra("videoPlayerConfig", (Serializable)playerConfig);
        context.startActivity(intent);
    }

    public static void enterPBRoom(Context context, String albumNo, VideoPlayerConfig playerConfig, OnEnterPBRoomFailedListener onEnterPBRoomFailedListener) {
        if (TextUtils.isEmpty((CharSequence)albumNo)) {
            if (onEnterPBRoomFailedListener != null) {
                onEnterPBRoomFailedListener.onEnterPBRoomFailed("invalid albumNo");
            }
            return;
        }
        Intent intent = new Intent(context, PBRoomActivity.class);
        intent.putExtra("album_no", albumNo);
        intent.putExtra("videoPlayerConfig", (Serializable)playerConfig);
        context.startActivity(intent);
    }

    public static void enterLocalPBRoom(Context context, DownloadModel videoModel, DownloadModel signalModel) {
        PBRoomUI.enterLocalPBRoom(context, videoModel, signalModel, new VideoPlayerConfig());
    }

    public static void enterLocalPBRoom(Context context, DownloadModel videoModel, DownloadModel signalModel, VideoPlayerConfig playerConfig) {
        Intent intent = new Intent(context, PBRoomActivity.class);
        intent.putExtra("isOffline", true);
        intent.putExtra("pb_room_record_type", videoModel.recordType);
        intent.putExtra("pb_room_small_course_record_type", videoModel.smallCourseRecordType);
        intent.putExtra("videoDownloadModel", (Serializable)videoModel);
        intent.putExtra("signalDownloadModel", (Serializable)signalModel);
        if (playerConfig == null) {
            playerConfig = new VideoPlayerConfig();
        }
        intent.putExtra("videoPlayerConfig", (Serializable)playerConfig);
        context.startActivity(intent);
    }

    public static void startPlayVideo(Context context, long videoId, String token, VideoPlayerConfig playerConfig) {
        Intent intent = new Intent(context, VideoPlayActivity.class);
        intent.putExtra("isOffline", false);
        intent.putExtra("videoId", videoId);
        intent.putExtra("token", token);
        if (playerConfig == null) {
            playerConfig = new VideoPlayerConfig();
        }
        intent.putExtra("videoPlayerConfig", (Serializable)playerConfig);
        context.startActivity(intent);
    }

    public static void startPlayVideoTriple(Context context, long videoId, String token, VideoPlayerConfig playerConfig) {
        Intent intent = new Intent(context, VideoPlayTripleActivity.class);
        intent.putExtra("isOffline", false);
        intent.putExtra("videoId", videoId);
        intent.putExtra("token", token);
        if (playerConfig == null) {
            playerConfig = new VideoPlayerConfig();
        }
        intent.putExtra("videoPlayerConfig", (Serializable)playerConfig);
        context.startActivity(intent);
    }

    public static void startPlayVideo(Context context, String albumId, VideoPlayerConfig playerConfig) {
        Intent intent = new Intent(context, VideoPlayActivity.class);
        intent.putExtra("isOffline", false);
        intent.putExtra("album_no", albumId);
        if (playerConfig == null) {
            playerConfig = new VideoPlayerConfig();
        }
        intent.putExtra("videoPlayerConfig", (Serializable)playerConfig);
        context.startActivity(intent);
    }

    public static void startPlayVideoTriple(Context context, String albumId, VideoPlayerConfig playerConfig) {
        Intent intent = new Intent(context, VideoPlayTripleActivity.class);
        intent.putExtra("isOffline", false);
        intent.putExtra("album_no", albumId);
        if (playerConfig == null) {
            playerConfig = new VideoPlayerConfig();
        }
        intent.putExtra("videoPlayerConfig", (Serializable)playerConfig);
        context.startActivity(intent);
    }

    public static void startPlayLocalVideo(Context context, DownloadModel downloadModel, VideoPlayerConfig playerConfig) {
        Intent intent = new Intent(context, VideoPlayActivity.class);
        intent.putExtra("isOffline", true);
        intent.putExtra("videoDownloadModel", (Serializable)downloadModel);
        if (playerConfig == null) {
            playerConfig = new VideoPlayerConfig();
        }
        intent.putExtra("videoPlayerConfig", (Serializable)playerConfig);
        context.startActivity(intent);
    }

    public static void startPlayVideoList(Context context, List<VideoInfoModel> videoInfoModelList, VideoPlayerConfig playerConfig, int position) {
        Intent intent = new Intent(context, VideoListActivity.class);
        if (playerConfig == null) {
            playerConfig = new VideoPlayerConfig();
        }
        intent.putExtra("videoPlayerConfig", (Serializable)playerConfig);
        intent.putExtra("pb_room_video_position", position);
        intent.putExtra("pb_room_video_model_list", PBJsonUtils.toString(videoInfoModelList));
        context.startActivity(intent);
    }

    public static interface OnEnterPBRoomFailedListener {
        public void onEnterPBRoomFailed(String var1);
    }
}

