/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.chat;

import android.content.res.Configuration;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.playback.PBRoom;
import com.baijiayun.playback.bean.models.imodels.IMessageModel;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.playback.adapters.PBMessageAdapter;
import com.baijiayun.videoplayer.ui.playback.adapters.RightAlignItemDecoration;
import com.baijiayun.videoplayer.ui.playback.chat.preview.IChatMessageCallback;
import com.baijiayun.videoplayer.ui.utils.PBUIUtils;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PBChatFragment
extends Fragment {
    private RecyclerView rvChat;
    private PBRoom mRoom;
    private PBMessageAdapter messageAdapter;
    private Disposable chatDisposable;
    private RecyclerView.ItemDecoration decoration;

    public void setRoom(PBRoom room) {
        this.mRoom = room;
        this.mRoom.getChatVM();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.bjy_pb_fragment_pb_chat, container, false);
        this.init(view);
        return view;
    }

    private void init(View view) {
        this.messageAdapter = new PBMessageAdapter(this.getContext(), (IChatMessageCallback)this.getActivity());
        this.messageAdapter.setChatVM(this.mRoom.getChatVM());
        if (this.getContext() != null) {
            this.messageAdapter.setOrientation(this.getContext().getResources().getConfiguration().orientation);
        }
        this.messageAdapter.setOrientation(this.requireActivity().getResources().getConfiguration().orientation);
        this.rvChat = (RecyclerView)view.findViewById(R.id.rv_pb_fragment_chat);
        this.rvChat.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.rvChat.setAdapter((RecyclerView.Adapter)this.messageAdapter);
        if (PBUIUtils.isChatFloatRight(this.mRoom)) {
            if (this.decoration == null) {
                this.decoration = new RightAlignItemDecoration();
            }
            if (this.requireActivity().getResources().getConfiguration().orientation == 2) {
                this.rvChat.addItemDecoration(this.decoration);
            }
        }
        this.messageAdapter.setChatFloatRight(PBUIUtils.isChatFloatRight(this.mRoom));
        this.messageAdapter.setImageViewLoadListener(() -> {
            if (this.rvChat.getScrollState() == 0) {
                if (!this.rvChat.isComputingLayout()) {
                    this.rvChat.invalidateItemDecorations();
                }
            } else {
                this.rvChat.addOnScrollListener(new RecyclerView.OnScrollListener(){

                    public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                        super.onScrollStateChanged(recyclerView, newState);
                        if (newState == 0 && !recyclerView.isComputingLayout()) {
                            recyclerView.invalidateItemDecorations();
                            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
                        }
                    }
                });
            }
        });
        if (this.mRoom != null) {
            this.chatDisposable = this.mRoom.getChatVM().getObservableOfNotifyDataChange().observeOn(AndroidSchedulers.mainThread()).subscribe(iMessageModels -> {
                for (IMessageModel messageModel : iMessageModels) {
                    this.checkPhoneNumber(messageModel);
                }
                this.messageAdapter.setMessageModelList((List<IMessageModel>)iMessageModels);
                this.messageAdapter.notifyDataSetChanged();
                this.rvChat.scrollToPosition(this.messageAdapter.getItemCount() - 1);
            });
        }
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.rvChat != null && PBUIUtils.isChatFloatRight(this.mRoom)) {
            if (this.decoration == null) {
                this.decoration = new RightAlignItemDecoration();
            }
            if (newConfig.orientation == 2) {
                this.rvChat.addItemDecoration(this.decoration);
            } else {
                this.rvChat.removeItemDecoration(this.decoration);
            }
        }
        if (this.messageAdapter != null) {
            this.messageAdapter.setOrientation(newConfig.orientation);
            this.messageAdapter.notifyDataSetChanged();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        RxUtils.dispose((Disposable)this.chatDisposable);
        this.messageAdapter.destroy();
    }

    private void checkPhoneNumber(IMessageModel messageModel) {
        if (!this.mRoom.getPartnerConfig().enableHideStudentPhoneNumber) {
            return;
        }
        Pattern pattern = Pattern.compile("(1[3-9][0-9])\\d{8}");
        String messageContent = messageModel.getContent();
        Matcher m = pattern.matcher(messageContent);
        while (m.find()) {
            String group = m.group();
            StringBuilder sb = new StringBuilder(group);
            sb.replace(3, 7, "****");
            messageContent = messageContent.replace(group, sb);
        }
        messageModel.setContent(messageContent);
    }
}

