/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.repository.support.value.ElasticsearchQueryValueConversionService;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

public final class QueryStringPlaceholderReplacer {
    private static final Pattern PARAMETER_PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    private final ConversionService conversionService;

    public QueryStringPlaceholderReplacer(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        this.conversionService = ElasticsearchQueryValueConversionService.getInstance(conversionService);
    }

    public String replacePlaceholders(String input, ParameterAccessor accessor) {
        Matcher matcher = PARAMETER_PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String placeholder = Pattern.quote(matcher.group()) + "(?!\\d+)";
            int index = (Integer)NumberUtils.parseNumber((String)matcher.group(1), Integer.class);
            String replacement = Matcher.quoteReplacement(this.getParameterWithIndex(accessor, index, input));
            result = result.replaceAll(placeholder, replacement);
            result = result.replaceAll("\\\\([^\"'])", "\\\\\\\\$1");
        }
        return result;
    }

    private String getParameterWithIndex(ParameterAccessor accessor, int index, String input) {
        Object parameter = accessor.getBindableValue(index);
        String value = (String)this.conversionService.convert(parameter, String.class);
        if (value == null) {
            throw new ConversionException(String.format("Parameter value can't be null for placeholder at index '%s' in query '%s' when querying elasticsearch", index, input));
        }
        return value;
    }
}

