/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.micrometer;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import java.util.Date;
import java.util.concurrent.TimeUnit;

@JsonPropertyOrder(value={"id", "timestamp", "sum", "count", "mean", "upper", "total"})
class Metric<T extends Number> {
    private final Date timestamp = new Date();
    private final Meter.Id id;
    private final Number sum;
    private final Number count;
    private final Number mean;
    private final Number upper;
    private final Number total;

    Metric(Meter.Id id, HistogramSnapshot snapshot) {
        this.id = id;
        this.sum = snapshot.total(TimeUnit.MILLISECONDS);
        this.count = snapshot.count();
        this.mean = snapshot.mean(TimeUnit.MILLISECONDS);
        this.upper = snapshot.max(TimeUnit.MILLISECONDS);
        this.total = snapshot.total(TimeUnit.MILLISECONDS);
    }

    public Meter.Id getId() {
        return this.id;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="UTC")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public Number getSum() {
        return this.sum;
    }

    public Number getCount() {
        return this.count;
    }

    public Number getMean() {
        return this.mean;
    }

    public Number getUpper() {
        return this.upper;
    }

    public Number getTotal() {
        return this.total;
    }

    public String toString() {
        return "Metric [id=" + this.id + ", sum=" + this.sum + ", count=" + this.count + ", mean=" + this.mean + ", upper=" + this.upper + ", total=" + this.total + ", timestamp=" + this.timestamp + "]";
    }
}

