/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config.conditional;

import org.springframework.cloud.gateway.config.conditional.ConditionalOnEnabledGlobalFilter;
import org.springframework.cloud.gateway.config.conditional.OnEnabledComponent;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.NameUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class OnEnabledGlobalFilter
extends OnEnabledComponent<GlobalFilter> {
    @Override
    protected String normalizeComponentName(Class<? extends GlobalFilter> filterClass) {
        return "global-filter." + NameUtils.normalizeGlobalFilterNameAsProperty(filterClass);
    }

    @Override
    protected Class<?> annotationClass() {
        return ConditionalOnEnabledGlobalFilter.class;
    }

    @Override
    protected Class<? extends GlobalFilter> defaultValueClass() {
        return DefaultValue.class;
    }

    static class DefaultValue
    implements GlobalFilter {
        DefaultValue() {
        }

        @Override
        public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
            throw new UnsupportedOperationException("class DefaultValue is never meant to be intantiated");
        }
    }
}

