/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class Error
implements MessageSourceResolvable {
    private final MessageSourceResolvable cause;

    private Error(MessageSourceResolvable cause) {
        Assert.notNull((Object)cause, (String)"'cause' must not be null");
        this.cause = cause;
    }

    public String[] getCodes() {
        return this.cause.getCodes();
    }

    public Object[] getArguments() {
        return this.cause.getArguments();
    }

    public String getDefaultMessage() {
        return this.cause.getDefaultMessage();
    }

    public MessageSourceResolvable getCause() {
        return this.cause;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.cause, ((Error)obj).cause);
    }

    public int hashCode() {
        return Objects.hash(this.cause);
    }

    public String toString() {
        return this.cause.toString();
    }

    public static List<Error> wrap(List<? extends MessageSourceResolvable> errors) {
        if (CollectionUtils.isEmpty(errors)) {
            return Collections.emptyList();
        }
        ArrayList<Error> result = new ArrayList<Error>(errors.size());
        for (MessageSourceResolvable messageSourceResolvable : errors) {
            result.add(new Error(messageSourceResolvable));
        }
        return List.copyOf(result);
    }
}

