/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.restdocs;

import io.restassured.specification.RequestSpecification;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsProperties;
import org.springframework.util.StringUtils;

class RestDocsRestAssuredBuilderCustomizer
implements InitializingBean {
    private final RestDocsProperties properties;
    private final RequestSpecification delegate;

    RestDocsRestAssuredBuilderCustomizer(RestDocsProperties properties, RequestSpecification delegate) {
        this.properties = properties;
        this.delegate = delegate;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyMapper map = PropertyMapper.get();
        String host = this.properties.getUriHost();
        map.from(this.properties::getUriScheme).when(scheme -> StringUtils.hasText((String)scheme) && StringUtils.hasText((String)host)).to(scheme -> this.delegate.baseUri(scheme + "://" + host));
        map.from(this.properties::getUriPort).whenNonNull().to(arg_0 -> ((RequestSpecification)this.delegate).port(arg_0));
    }
}

