/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.maven.artifact.Artifact;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.BuildpackReference;
import org.springframework.boot.buildpack.platform.build.Cache;
import org.springframework.boot.buildpack.platform.build.PullPolicy;
import org.springframework.boot.buildpack.platform.docker.type.Binding;
import org.springframework.boot.buildpack.platform.docker.type.ImageName;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.boot.maven.CacheInfo;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class Image {
    @Nullable String name;
    @Nullable String builder;
    @Nullable Boolean trustBuilder;
    @Nullable String runImage;
    @Nullable Map<String, String> env;
    @Nullable Boolean cleanCache;
    boolean verboseLogging;
    @Nullable PullPolicy pullPolicy;
    @Nullable Boolean publish;
    @Nullable List<String> buildpacks;
    @Nullable List<String> bindings;
    @Nullable String network;
    @Nullable List<String> tags;
    @Nullable CacheInfo buildWorkspace;
    @Nullable CacheInfo buildCache;
    @Nullable CacheInfo launchCache;
    @Nullable String createdDate;
    @Nullable String applicationDirectory;
    @Nullable List<String> securityOptions;
    @Nullable String imagePlatform;

    public @Nullable String getName() {
        return this.name;
    }

    void setName(@Nullable String name) {
        this.name = name;
    }

    public @Nullable String getBuilder() {
        return this.builder;
    }

    void setBuilder(@Nullable String builder) {
        this.builder = builder;
    }

    public @Nullable Boolean getTrustBuilder() {
        return this.trustBuilder;
    }

    void setTrustBuilder(@Nullable Boolean trustBuilder) {
        this.trustBuilder = trustBuilder;
    }

    public @Nullable String getRunImage() {
        return this.runImage;
    }

    void setRunImage(@Nullable String runImage) {
        this.runImage = runImage;
    }

    public @Nullable Map<String, String> getEnv() {
        return this.env;
    }

    public @Nullable Boolean getCleanCache() {
        return this.cleanCache;
    }

    void setCleanCache(@Nullable Boolean cleanCache) {
        this.cleanCache = cleanCache;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public @Nullable PullPolicy getPullPolicy() {
        return this.pullPolicy;
    }

    void setPullPolicy(@Nullable PullPolicy pullPolicy) {
        this.pullPolicy = pullPolicy;
    }

    public @Nullable Boolean getPublish() {
        return this.publish;
    }

    void setPublish(@Nullable Boolean publish) {
        this.publish = publish;
    }

    public @Nullable String getNetwork() {
        return this.network;
    }

    public void setNetwork(@Nullable String network) {
        this.network = network;
    }

    public @Nullable String getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(@Nullable String createdDate) {
        this.createdDate = createdDate;
    }

    public @Nullable String getApplicationDirectory() {
        return this.applicationDirectory;
    }

    public void setApplicationDirectory(@Nullable String applicationDirectory) {
        this.applicationDirectory = applicationDirectory;
    }

    public @Nullable String getImagePlatform() {
        return this.imagePlatform;
    }

    public void setImagePlatform(@Nullable String imagePlatform) {
        this.imagePlatform = imagePlatform;
    }

    BuildRequest getBuildRequest(Artifact artifact, Function<Owner, TarArchive> applicationContent) {
        return this.customize(BuildRequest.of((ImageReference)this.getOrDeduceName(artifact), applicationContent));
    }

    private ImageReference getOrDeduceName(Artifact artifact) {
        if (StringUtils.hasText((String)this.name)) {
            return ImageReference.of((String)this.name);
        }
        ImageName imageName = ImageName.of((String)artifact.getArtifactId());
        return ImageReference.of((ImageName)imageName, (String)artifact.getVersion());
    }

    private BuildRequest customize(BuildRequest request) {
        Cache cache;
        if (StringUtils.hasText((String)this.builder)) {
            request = request.withBuilder(ImageReference.of((String)this.builder));
        }
        if (this.trustBuilder != null) {
            request = request.withTrustBuilder(this.trustBuilder.booleanValue());
        }
        if (StringUtils.hasText((String)this.runImage)) {
            request = request.withRunImage(ImageReference.of((String)this.runImage));
        }
        if (!CollectionUtils.isEmpty(this.env)) {
            request = request.withEnv(this.env);
        }
        if (this.cleanCache != null) {
            request = request.withCleanCache(this.cleanCache.booleanValue());
        }
        request = request.withVerboseLogging(this.verboseLogging);
        if (this.pullPolicy != null) {
            request = request.withPullPolicy(this.pullPolicy);
        }
        if (this.publish != null) {
            request = request.withPublish(this.publish.booleanValue());
        }
        if (!CollectionUtils.isEmpty(this.buildpacks)) {
            request = request.withBuildpacks(this.buildpacks.stream().map(BuildpackReference::of).toList());
        }
        if (!CollectionUtils.isEmpty(this.bindings)) {
            request = request.withBindings(this.bindings.stream().map(Binding::of).toList());
        }
        request = request.withNetwork(this.network);
        if (!CollectionUtils.isEmpty(this.tags)) {
            request = request.withTags(this.tags.stream().map(ImageReference::of).toList());
        }
        if (this.buildWorkspace != null) {
            cache = this.buildWorkspace.asCache();
            Assert.state((cache != null ? 1 : 0) != 0, (String)"'cache' must not be null");
            request = request.withBuildWorkspace(cache);
        }
        if (this.buildCache != null) {
            cache = this.buildCache.asCache();
            Assert.state((cache != null ? 1 : 0) != 0, (String)"'cache' must not be null");
            request = request.withBuildCache(cache);
        }
        if (this.launchCache != null) {
            cache = this.launchCache.asCache();
            Assert.state((cache != null ? 1 : 0) != 0, (String)"'cache' must not be null");
            request = request.withLaunchCache(cache);
        }
        if (StringUtils.hasText((String)this.createdDate)) {
            request = request.withCreatedDate(this.createdDate);
        }
        if (StringUtils.hasText((String)this.applicationDirectory)) {
            request = request.withApplicationDirectory(this.applicationDirectory);
        }
        if (this.securityOptions != null) {
            request = request.withSecurityOptions(this.securityOptions);
        }
        if (StringUtils.hasText((String)this.imagePlatform)) {
            request = request.withImagePlatform(this.imagePlatform);
        }
        return request;
    }
}

