/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jooq;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jooq.SQLDialect;
import org.jooq.tools.jdbc.JDBCUtils;

final class SqlDialectLookup {
    private static final Log logger = LogFactory.getLog(SqlDialectLookup.class);

    private SqlDialectLookup() {
    }

    static SQLDialect getDialect(DataSource dataSource) {
        SQLDialect sQLDialect;
        block8: {
            Connection connection = dataSource != null ? dataSource.getConnection() : null;
            try {
                sQLDialect = JDBCUtils.dialect((Connection)connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    logger.warn((Object)"Unable to determine dialect from datasource", (Throwable)ex);
                    return SQLDialect.DEFAULT;
                }
            }
            connection.close();
        }
        return sQLDialect;
    }
}

