/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.ldap;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.ldap.LdapHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ldap.LdapAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.ldap.core.LdapOperations;

@AutoConfiguration(after={LdapAutoConfiguration.class})
@ConditionalOnClass(value={LdapOperations.class})
@ConditionalOnBean(value={LdapOperations.class})
@ConditionalOnEnabledHealthIndicator(value="ldap")
public class LdapHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<LdapHealthIndicator, LdapOperations> {
    public LdapHealthContributorAutoConfiguration() {
        super(LdapHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"ldapHealthIndicator", "ldapHealthContributor"})
    public HealthContributor ldapHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, LdapOperations.class);
    }
}

