/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.moonshot.autoconfigure;

import io.micrometer.observation.ObservationRegistry;
import org.springaicommunity.moonshot.MoonshotChatModel;
import org.springaicommunity.moonshot.api.MoonshotApi;
import org.springaicommunity.moonshot.autoconfigure.MoonshotChatProperties;
import org.springaicommunity.moonshot.autoconfigure.MoonshotCommonProperties;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.autoconfigure.ToolCallingAutoConfiguration;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, WebClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class, ToolCallingAutoConfiguration.class})
@ConditionalOnClass(value={MoonshotApi.class})
@EnableConfigurationProperties(value={MoonshotCommonProperties.class, MoonshotChatProperties.class})
@ImportAutoConfiguration(classes={SpringAiRetryAutoConfiguration.class, RestClientAutoConfiguration.class, WebClientAutoConfiguration.class, ToolCallingAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.ai.model.chat"}, havingValue="Moonshot", matchIfMissing=true)
public class MoonshotChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MoonshotChatModel moonshotChatModel(MoonshotCommonProperties commonProperties, MoonshotChatProperties chatProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention, ObjectProvider<ToolExecutionEligibilityPredicate> toolExecutionEligibilityPredicate) {
        MoonshotApi moonshotApi = this.moonshotApi(chatProperties, commonProperties, (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), (WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder), responseErrorHandler);
        MoonshotChatModel chatModel = MoonshotChatModel.builder().moonshotApi(moonshotApi).defaultOptions(chatProperties.getOptions()).toolCallingManager(toolCallingManager).toolExecutionEligibilityPredicate((ToolExecutionEligibilityPredicate)toolExecutionEligibilityPredicate.getIfUnique(DefaultToolExecutionEligibilityPredicate::new)).retryTemplate(retryTemplate).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).build();
        observationConvention.ifAvailable(arg_0 -> ((MoonshotChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }

    @Bean
    @ConditionalOnMissingBean
    public RetryTemplate retryTemplate() {
        return new RetryTemplate();
    }

    private MoonshotApi moonshotApi(MoonshotChatProperties chatProperties, MoonshotCommonProperties commonProperties, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        String resolvedBaseUrl = StringUtils.hasText((String)chatProperties.getBaseUrl()) ? chatProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)resolvedBaseUrl, (String)"Moonshot base URL must be set");
        String resolvedApiKey = StringUtils.hasText((String)chatProperties.getApiKey()) ? chatProperties.getApiKey() : commonProperties.getApiKey();
        Assert.hasText((String)resolvedApiKey, (String)"Moonshot API key must be set");
        return MoonshotApi.builder().baseUrl(resolvedBaseUrl).apiKey((ApiKey)new SimpleApiKey(resolvedApiKey)).completionsPath(chatProperties.getCompletionsPath()).restClientBuilder(restClientBuilder).webClientBuilder(webClientBuilder).responseErrorHandler(responseErrorHandler).build();
    }
}

