/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.qianfan.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springaicommunity.qianfan.api.QianFanUtils;
import org.springaicommunity.qianfan.api.auth.AuthApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class QianFanImageApi
extends AuthApi {
    public static final String DEFAULT_IMAGE_MODEL = ImageModel.Stable_Diffusion_XL.getValue();
    private final RestClient restClient;

    public QianFanImageApi(String apiKey, String secretKey) {
        this("https://aip.baidubce.com/rpc/2.0/ai_custom", apiKey, secretKey, RestClient.builder());
    }

    public QianFanImageApi(String baseUrl, String apiKey, String secretKey, RestClient.Builder restClientBuilder) {
        this(baseUrl, apiKey, secretKey, restClientBuilder, RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public QianFanImageApi(String baseUrl, String apiKey, String secretKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        super(apiKey, secretKey);
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(QianFanUtils.defaultHeaders()).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<QianFanImageResponse> createImage(QianFanImageRequest qianFanImageRequest) {
        Assert.notNull((Object)qianFanImageRequest, (String)"Image request cannot be null.");
        Assert.hasLength((String)qianFanImageRequest.prompt(), (String)"Prompt cannot be empty.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/wenxinworkshop/text2image/{model}?access_token={token}", new Object[]{qianFanImageRequest.model(), this.getAccessToken()})).body((Object)qianFanImageRequest).retrieve().toEntity(QianFanImageResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record QianFanImageRequest(@JsonProperty(value="model") String model, @JsonProperty(value="prompt") String prompt, @JsonProperty(value="negative_prompt") String negativePrompt, @JsonProperty(value="size") String size, @JsonProperty(value="n") Integer n, @JsonProperty(value="steps") Integer steps, @JsonProperty(value="seed") Integer seed, @JsonProperty(value="style") String style, @JsonProperty(value="user_id") String user) {
        public QianFanImageRequest(String prompt, String model) {
            this(model, prompt, null, null, null, null, null, null, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record QianFanImageResponse(@JsonProperty(value="id") String id, @JsonProperty(value="created") Long created, @JsonProperty(value="data") List<Data> data) {
    }

    public static enum ImageModel {
        Stable_Diffusion_XL("sd_xl");

        private final String value;

        private ImageModel(String model) {
            this.value = model;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Data(@JsonProperty(value="index") Integer index, @JsonProperty(value="b64_image") String b64Image) {
    }
}

