/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.moonshot.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springaicommunity.moonshot.api.MoonshotStreamFunctionCallingHelper;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MoonshotApi {
    public static final String DEFAULT_CHAT_MODEL = ChatModel.MOONSHOT_V1_8K.getValue();
    private static final Predicate<String> SSE_DONE_PREDICATE = "[DONE]"::equals;
    private final String completionsPath;
    private final RestClient restClient;
    private final WebClient webClient;
    private final MoonshotStreamFunctionCallingHelper chunkMerger = new MoonshotStreamFunctionCallingHelper();

    public MoonshotApi(String baseUrl, ApiKey apiKey, MultiValueMap<String, String> headers, String completionsPath, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Assert.hasText((String)completionsPath, (String)"Completions Path must not be null");
        Assert.notNull(headers, (String)"Headers must not be null");
        this.completionsPath = completionsPath;
        Consumer<HttpHeaders> finalHeaders = h -> {
            h.setBearerAuth(apiKey.getValue());
            h.setContentType(MediaType.APPLICATION_JSON);
            h.addAll(headers);
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(finalHeaders).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.baseUrl(baseUrl).defaultHeaders(finalHeaders).build();
    }

    public ResponseEntity<ChatCompletion> chatCompletionEntity(ChatCompletionRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((chatRequest.stream() == false ? 1 : 0) != 0, (String)"Request must set the stream property to false.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri(this.completionsPath, new Object[0])).body((Object)chatRequest).retrieve().toEntity(ChatCompletion.class);
    }

    public Flux<ChatCompletionChunk> chatCompletionStream(ChatCompletionRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((boolean)chatRequest.stream(), (String)"Request must set the steam property to true.");
        AtomicBoolean isInsideTool = new AtomicBoolean(false);
        return ((WebClient.RequestBodySpec)this.webClient.post().uri(this.completionsPath, new Object[0])).body((Publisher)Mono.just((Object)chatRequest), ChatCompletionRequest.class).retrieve().bodyToFlux(String.class).takeUntil(SSE_DONE_PREDICATE).filter(SSE_DONE_PREDICATE.negate()).map(content -> (ChatCompletionChunk)ModelOptionsUtils.jsonToObject((String)content, ChatCompletionChunk.class)).map(chunk -> {
            if (this.chunkMerger.isStreamingToolFunctionCall((ChatCompletionChunk)chunk)) {
                isInsideTool.set(true);
            }
            return chunk;
        }).windowUntil(chunk -> {
            if (isInsideTool.get() && this.chunkMerger.isStreamingToolFunctionCallFinish((ChatCompletionChunk)chunk)) {
                isInsideTool.set(false);
                return true;
            }
            return !isInsideTool.get();
        }).concatMapIterable(window -> {
            Mono monoChunk = window.reduce((Object)new ChatCompletionChunk(null, null, null, null, null), (previous, current) -> this.chunkMerger.merge((ChatCompletionChunk)previous, (ChatCompletionChunk)current));
            return List.of(monoChunk);
        }).flatMap(mono -> mono);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequest(@JsonProperty(value="messages") List<ChatCompletionMessage> messages, @JsonProperty(value="model") String model, @JsonProperty(value="max_tokens") Integer maxTokens, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="top_p") Double topP, @JsonProperty(value="n") Integer n, @JsonProperty(value="frequency_penalty") Double frequencyPenalty, @JsonProperty(value="presence_penalty") Double presencePenalty, @JsonProperty(value="stop") List<String> stop, @JsonProperty(value="stream") Boolean stream, @JsonProperty(value="tools") List<FunctionTool> tools, @JsonProperty(value="tool_choice") Object toolChoice) {
        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model) {
            this(messages, model, null, 0.3, 1.0, null, null, null, null, false, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Double temperature, boolean stream) {
            this(messages, model, null, temperature, 1.0, null, null, null, null, stream, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Double temperature) {
            this(messages, model, null, temperature, 1.0, null, null, null, null, false, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, List<FunctionTool> tools, Object toolChoice) {
            this(messages, model, null, null, 1.0, null, null, null, null, false, tools, toolChoice);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, Boolean stream) {
            this(messages, DEFAULT_CHAT_MODEL, null, 0.7, 1.0, null, null, null, null, stream, null, null);
        }

        public static class ToolChoiceBuilder {
            public static final String AUTO = "auto";
            public static final String NONE = "none";

            public static Object function(String functionName) {
                return Map.of("type", "function", "function", Map.of("name", functionName));
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletion(@JsonProperty(value="id") String id, @JsonProperty(value="choices") List<Choice> choices, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="object") String object, @JsonProperty(value="usage") Usage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Choice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="index") Integer index, @JsonProperty(value="message") ChatCompletionMessage message, @JsonProperty(value="usage") Usage usage) {
        }
    }

    public static class Builder {
        private String baseUrl = "https://api.moonshot.cn";
        private ApiKey apiKey;
        private MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        private String completionsPath = "/v1/chat/completions";
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private WebClient.Builder webClientBuilder = WebClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder baseUrl(String baseUrl) {
            Assert.hasText((String)baseUrl, (String)"baseUrl cannot be null or empty");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(ApiKey apiKey) {
            Assert.notNull((Object)apiKey, (String)"apiKey cannot be null");
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"simpleApiKey cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder headers(MultiValueMap<String, String> headers) {
            Assert.notNull(headers, (String)"headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder completionsPath(String completionsPath) {
            Assert.hasText((String)completionsPath, (String)"completionsPath cannot be null or empty");
            this.completionsPath = completionsPath;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder webClientBuilder(WebClient.Builder webClientBuilder) {
            Assert.notNull((Object)webClientBuilder, (String)"webClientBuilder cannot be null");
            this.webClientBuilder = webClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"responseErrorHandler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public MoonshotApi build() {
            Assert.notNull((Object)this.apiKey, (String)"apiKey must be set");
            return new MoonshotApi(this.baseUrl, this.apiKey, this.headers, this.completionsPath, this.restClientBuilder, this.webClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionChunk(@JsonProperty(value="id") String id, @JsonProperty(value="object") String object, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="choices") List<ChunkChoice> choices) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ChunkChoice(@JsonProperty(value="index") Integer index, @JsonProperty(value="delta") ChatCompletionMessage delta, @JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="usage") Usage usage) {
        }
    }

    public static enum ChatModel implements ChatModelDescription
    {
        MOONSHOT_V1_8K("moonshot-v1-8k"),
        MOONSHOT_V1_32K("moonshot-v1-32k"),
        MOONSHOT_V1_128K("moonshot-v1-128k");

        private final String value;

        private ChatModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record FunctionTool(@JsonProperty(value="type") Type type, @JsonProperty(value="function") Function function) {
        public FunctionTool(Function function) {
            this(Type.FUNCTION, function);
        }

        public static enum Type {
            FUNCTION;

        }

        public record Function(@JsonProperty(value="description") String description, @JsonProperty(value="name") String name, @JsonProperty(value="parameters") Map<String, Object> parameters) {
            public Function(String description, String name, String jsonSchema) {
                this(description, name, ModelOptionsUtils.jsonToMap((String)jsonSchema));
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionMessage(@JsonProperty(value="content") Object rawContent, @JsonProperty(value="role") Role role, @JsonProperty(value="name") String name, @JsonProperty(value="tool_call_id") String toolCallId, @JsonProperty(value="tool_calls") List<ToolCall> toolCalls) {
        public ChatCompletionMessage(Object content, Role role) {
            this(content, role, null, null, null);
        }

        public String content() {
            if (this.rawContent == null) {
                return null;
            }
            Object object = this.rawContent;
            if (object instanceof String) {
                String text = (String)object;
                return text;
            }
            throw new IllegalStateException("The content is not a string!");
        }

        public static enum Role {
            SYSTEM,
            USER,
            ASSISTANT,
            TOOL;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ChatCompletionFunction(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") String arguments) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ToolCall(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="function") ChatCompletionFunction function) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Usage(@JsonProperty(value="prompt_tokens") Integer promptTokens, @JsonProperty(value="total_tokens") Integer totalTokens, @JsonProperty(value="completion_tokens") Integer completionTokens) {
    }

    public static enum ChatCompletionFinishReason {
        STOP,
        LENGTH,
        CONTENT_FILTER,
        TOOL_CALLS,
        TOOL_CALL;

    }
}

