/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client;

import org.pac4j.core.client.Mechanism;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.BaseHttpClient;
import org.pac4j.http.credentials.UsernamePasswordAuthenticator;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.profile.UsernameProfileCreator;

public class FormClient
extends BaseHttpClient<UsernamePasswordCredentials> {
    private String loginUrl;
    public static final String ERROR_PARAMETER = "error";
    public static final String MISSING_FIELD_ERROR = "missing_field";
    public static final String DEFAULT_USERNAME_PARAMETER = "username";
    private String usernameParameter = "username";
    public static final String DEFAULT_PASSWORD_PARAMETER = "password";
    private String passwordParameter = "password";

    public FormClient() {
    }

    public FormClient(String loginUrl, UsernamePasswordAuthenticator usernamePasswordAuthenticator) {
        this.setLoginUrl(loginUrl);
        this.setAuthenticator(usernamePasswordAuthenticator);
    }

    public FormClient(String loginUrl, UsernamePasswordAuthenticator usernamePasswordAuthenticator, UsernameProfileCreator profileCreator) {
        this(loginUrl, usernamePasswordAuthenticator);
        this.setProfileCreator(profileCreator);
    }

    protected BaseHttpClient<UsernamePasswordCredentials> newClient() {
        FormClient newClient = new FormClient();
        newClient.setLoginUrl(this.loginUrl);
        newClient.setUsernameParameter(this.usernameParameter);
        newClient.setPasswordParameter(this.passwordParameter);
        return newClient;
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        CommonHelper.assertNotBlank((String)"loginUrl", (String)this.loginUrl);
    }

    protected RedirectAction retrieveRedirectAction(WebContext context) {
        return RedirectAction.redirect((String)this.loginUrl);
    }

    protected UsernamePasswordCredentials retrieveCredentials(WebContext context) throws RequiresHttpAction {
        String username = context.getRequestParameter(this.usernameParameter);
        String password = context.getRequestParameter(this.passwordParameter);
        if (CommonHelper.isNotBlank((String)username) && CommonHelper.isNotBlank((String)password)) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password, this.getName());
            logger.debug("usernamePasswordCredentials : {}", (Object)credentials);
            try {
                this.getAuthenticator().validate((Credentials)credentials);
            }
            catch (TechnicalException e) {
                String redirectionUrl = CommonHelper.addParameter((String)this.loginUrl, (String)this.usernameParameter, (String)username);
                String errorMessage = this.computeErrorMessage(e);
                redirectionUrl = CommonHelper.addParameter((String)redirectionUrl, (String)ERROR_PARAMETER, (String)errorMessage);
                logger.debug("redirectionUrl : {}", (Object)redirectionUrl);
                String message = "Credentials validation fails -> return to the form with error";
                logger.debug("Credentials validation fails -> return to the form with error");
                throw RequiresHttpAction.redirect((String)"Credentials validation fails -> return to the form with error", (WebContext)context, (String)redirectionUrl);
            }
            return credentials;
        }
        String redirectionUrl = CommonHelper.addParameter((String)this.loginUrl, (String)this.usernameParameter, (String)username);
        redirectionUrl = CommonHelper.addParameter((String)redirectionUrl, (String)ERROR_PARAMETER, (String)MISSING_FIELD_ERROR);
        logger.debug("redirectionUrl : {}", (Object)redirectionUrl);
        String message = "Username and password cannot be blank -> return to the form with error";
        logger.debug("Username and password cannot be blank -> return to the form with error");
        throw RequiresHttpAction.redirect((String)"Username and password cannot be blank -> return to the form with error", (WebContext)context, (String)redirectionUrl);
    }

    protected String computeErrorMessage(TechnicalException e) {
        return ((Object)((Object)e)).getClass().getSimpleName();
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "name", this.getName(), "loginUrl", this.loginUrl, "usernameParameter", this.usernameParameter, "passwordParameter", this.passwordParameter, "usernamePasswordAuthenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }

    protected boolean isDirectRedirection() {
        return true;
    }

    public Mechanism getMechanism() {
        return Mechanism.FORM_MECHANISM;
    }
}

