/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.index.impl.lucene.CommitContext;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.LuceneCommand;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.LuceneIndex;
import org.neo4j.index.impl.lucene.RelationshipId;
import org.neo4j.index.impl.lucene.TxDataHolder;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;

class LuceneTransaction
extends XaTransaction {
    private final Map<IndexIdentifier, TxDataBoth> txData = new HashMap<IndexIdentifier, TxDataBoth>();
    private final LuceneDataSource dataSource;
    private final Map<IndexIdentifier, CommandList> commandMap = new HashMap<IndexIdentifier, CommandList>();

    LuceneTransaction(int identifier, XaLogicalLog xaLog, LuceneDataSource luceneDs) {
        super(identifier, xaLog);
        this.dataSource = luceneDs;
    }

    <T extends PropertyContainer> void add(LuceneIndex<T> index, T entity, String key, Object value) {
        value = value instanceof ValueContext ? ((ValueContext)value).getCorrectValue() : value.toString();
        TxDataBoth data = this.getTxData(index, true);
        this.insert(index, entity, key, value, data.added(true), data.removed(false));
        this.queueCommand(index.newAddCommand(entity, key, value));
    }

    private Object getEntityId(PropertyContainer entity) {
        return entity instanceof Node ? Long.valueOf(((Node)entity).getId()) : RelationshipId.of((Relationship)entity);
    }

    <T extends PropertyContainer> TxDataBoth getTxData(LuceneIndex<T> index, boolean createIfNotExists) {
        IndexIdentifier identifier = index.getIdentifier();
        TxDataBoth data = this.txData.get(identifier);
        if (data == null && createIfNotExists) {
            data = new TxDataBoth(index);
            this.txData.put(identifier, data);
        }
        return data;
    }

    <T extends PropertyContainer> void remove(LuceneIndex<T> index, T entity, String key, Object value) {
        value = value instanceof ValueContext ? ((ValueContext)value).getCorrectValue() : value.toString();
        TxDataBoth data = this.getTxData(index, true);
        this.insert(index, entity, key, value, data.removed(true), data.added(false));
        this.queueCommand(index.newRemoveCommand(entity, key, value));
    }

    <T extends PropertyContainer> void remove(LuceneIndex<T> index, T entity, String key) {
        TxDataBoth data = this.getTxData(index, true);
        this.insert(index, entity, key, null, data.removed(true), data.added(false));
        this.queueCommand(index.newRemoveCommand(entity, key, null));
    }

    <T extends PropertyContainer> void remove(LuceneIndex<T> index, T entity) {
        TxDataBoth data = this.getTxData(index, true);
        this.insert(index, entity, null, null, data.removed(true), data.added(false));
        this.queueCommand(index.newRemoveCommand(entity, null, null));
    }

    <T extends PropertyContainer> void delete(LuceneIndex<T> index) {
        this.txData.put(index.getIdentifier(), new DeletedTxDataBoth(index));
        this.queueCommand(new LuceneCommand.DeleteCommand(index.getIdentifier()));
    }

    private CommandList queueCommand(LuceneCommand command) {
        IndexIdentifier indexId = command.indexId;
        CommandList commands = this.commandMap.get(indexId);
        if (commands == null) {
            commands = new CommandList();
            this.commandMap.put(indexId, commands);
        }
        if (command instanceof LuceneCommand.DeleteCommand) {
            commands.clear();
        }
        commands.add(command);
        commands.incCounter(command);
        return commands;
    }

    private <T extends PropertyContainer> void insert(LuceneIndex<T> index, T entity, String key, Object value, TxDataHolder insertInto, TxDataHolder removeFrom) {
        Object id = this.getEntityId(entity);
        if (removeFrom != null) {
            removeFrom.remove(id, key, value);
        }
        insertInto.add(id, key, value);
    }

    <T extends PropertyContainer> Collection<Long> getRemovedIds(LuceneIndex<T> index, Query query) {
        TxDataHolder removed = this.removedTxDataOrNull(index);
        if (removed == null) {
            return Collections.emptySet();
        }
        Collection<Long> ids = removed.query(query, null);
        return ids != null ? ids : Collections.emptySet();
    }

    <T extends PropertyContainer> Collection<Long> getRemovedIds(LuceneIndex<T> index, String key, Object value) {
        TxDataHolder removed = this.removedTxDataOrNull(index);
        if (removed == null) {
            return Collections.emptySet();
        }
        Collection<Long> ids = removed.get(key, value);
        Collection<Long> orphanIds = removed.getOrphans(key);
        return LuceneTransaction.merge(ids, orphanIds);
    }

    static Collection<Long> merge(Collection<Long> c1, Collection<Long> c2) {
        if (c1 == null && c2 == null) {
            return Collections.emptySet();
        }
        if (c1 != null && c2 != null) {
            if (c1.isEmpty()) {
                return c2;
            }
            if (c2.isEmpty()) {
                return c1;
            }
            HashSet<Long> result = new HashSet<Long>(c1.size() + c2.size(), 1.0f);
            result.addAll(c1);
            result.addAll(c2);
            return result;
        }
        return c1 != null ? c1 : c2;
    }

    <T extends PropertyContainer> Collection<Long> getAddedIds(LuceneIndex<T> index, Query query, QueryContext contextOrNull) {
        TxDataHolder added = this.addedTxDataOrNull(index);
        if (added == null) {
            return Collections.emptySet();
        }
        Collection<Long> ids = added.query(query, contextOrNull);
        return ids != null ? ids : Collections.emptySet();
    }

    <T extends PropertyContainer> Collection<Long> getAddedIds(LuceneIndex<T> index, String key, Object value) {
        TxDataHolder added = this.addedTxDataOrNull(index);
        if (added == null) {
            return Collections.emptySet();
        }
        Collection<Long> ids = added.get(key, value);
        return ids != null ? ids : Collections.emptySet();
    }

    private <T extends PropertyContainer> TxDataHolder addedTxDataOrNull(LuceneIndex<T> index) {
        TxDataBoth data = this.getTxData(index, false);
        return data != null ? data.added(false) : null;
    }

    private <T extends PropertyContainer> TxDataHolder removedTxDataOrNull(LuceneIndex<T> index) {
        TxDataBoth data = this.getTxData(index, false);
        return data != null ? data.removed(false) : null;
    }

    protected void doAddCommand(XaCommand command) {
    }

    protected void injectCommand(XaCommand command) {
        this.queueCommand((LuceneCommand)command).incCounter((LuceneCommand)command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit() {
        this.dataSource.getWriteLock();
        try {
            for (Map.Entry<IndexIdentifier, CommandList> entry : this.commandMap.entrySet()) {
                IndexType type;
                if (entry.getValue().isEmpty()) continue;
                IndexIdentifier identifier = entry.getKey();
                CommandList commandList = entry.getValue();
                IndexType indexType = type = identifier == LuceneCommand.CreateIndexCommand.FAKE_IDENTIFIER || !commandList.containsWrites() ? null : this.dataSource.getType(identifier, this.isRecovered());
                if (type == null && this.isRecovered()) {
                    if (commandList.isDeletion()) {
                        this.dataSource.removeExpectedFutureDeletion(identifier);
                        continue;
                    }
                    if (commandList.containsWrites()) {
                        this.dataSource.addExpectedFutureDeletion(identifier);
                        continue;
                    }
                }
                CommitContext context = null;
                try {
                    context = new CommitContext(this.dataSource, identifier, type, commandList);
                    for (LuceneCommand command : commandList.commands) {
                        command.perform(context);
                    }
                    this.applyDocuments(context.writer, type, context.documents);
                    if (context.writer == null) continue;
                    this.dataSource.invalidateIndexSearcher(identifier);
                }
                finally {
                    if (context == null) continue;
                    context.close();
                }
            }
            this.dataSource.setLastCommittedTxId(this.getCommitTxId());
            this.closeTxData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.dataSource.releaseWriteLock();
        }
    }

    private void applyDocuments(IndexWriter writer, IndexType type, Map<Long, CommitContext.DocumentContext> documents) throws IOException {
        for (Map.Entry<Long, CommitContext.DocumentContext> entry : documents.entrySet()) {
            CommitContext.DocumentContext context = entry.getValue();
            if (context.exists) {
                if (LuceneDataSource.documentIsEmpty(context.document)) {
                    writer.deleteDocuments(type.idTerm(context.entityId));
                    continue;
                }
                writer.updateDocument(type.idTerm(context.entityId), context.document);
                continue;
            }
            writer.addDocument(context.document);
        }
    }

    private void closeTxData() {
        for (TxDataBoth data : this.txData.values()) {
            data.close();
        }
        this.txData.clear();
    }

    protected void doPrepare() {
        boolean containsDeleteCommand = false;
        for (CommandList list : this.commandMap.values()) {
            for (LuceneCommand command : list.commands) {
                if (command instanceof LuceneCommand.DeleteCommand) {
                    containsDeleteCommand = true;
                }
                this.addCommand(command);
            }
        }
        if (!containsDeleteCommand) {
            this.addAbandonedEntitiesToTheTx();
        }
    }

    private void addAbandonedEntitiesToTheTx() {
        for (Map.Entry<IndexIdentifier, TxDataBoth> entry : this.txData.entrySet()) {
            Collection<Long> abandonedIds = entry.getValue().index.abandonedIds;
            if (abandonedIds.isEmpty()) continue;
            CommandList commands = this.commandMap.get(entry.getKey());
            for (Long id : abandonedIds) {
                LuceneCommand.RemoveCommand command = new LuceneCommand.RemoveCommand(entry.getKey(), entry.getKey().entityTypeByte, id, null, null);
                this.addCommand(command);
                commands.add(command);
            }
            abandonedIds.clear();
        }
    }

    protected void doRollback() {
        this.commandMap.clear();
        this.closeTxData();
    }

    public boolean isReadOnly() {
        return this.commandMap.isEmpty();
    }

    void createIndex(Class<? extends PropertyContainer> entityType, String name, Map<String, String> config) {
        byte entityTypeByte = 0;
        if (entityType == Node.class) {
            entityTypeByte = 1;
        } else if (entityType == Relationship.class) {
            entityTypeByte = 2;
        } else {
            throw new IllegalArgumentException("Unknown entity typee " + entityType);
        }
        this.queueCommand(new LuceneCommand.CreateIndexCommand(entityTypeByte, name, config));
    }

    <T extends PropertyContainer> IndexSearcher getAdditionsAsSearcher(LuceneIndex<T> index, QueryContext context) {
        TxDataHolder data = this.addedTxDataOrNull(index);
        return data != null ? data.asSearcher(context) : null;
    }

    static class CommandList {
        private final List<LuceneCommand> commands = new ArrayList<LuceneCommand>();
        private boolean containsWrites;

        CommandList() {
        }

        void add(LuceneCommand command) {
            this.commands.add(command);
        }

        boolean containsWrites() {
            return this.containsWrites;
        }

        boolean isDeletion() {
            return this.commands.size() == 1 && this.commands.get(0) instanceof LuceneCommand.DeleteCommand;
        }

        void clear() {
            this.commands.clear();
            this.containsWrites = false;
        }

        void incCounter(LuceneCommand command) {
            if (command.isConsideredNormalWriteCommand()) {
                this.containsWrites = true;
            }
        }

        boolean isEmpty() {
            return this.commands.isEmpty();
        }

        boolean isRecovery() {
            return this.commands.get(0).isRecovered();
        }
    }

    private class DeletedTxDataBoth
    extends TxDataBoth {
        public DeletedTxDataBoth(LuceneIndex index) {
            super(index);
        }

        @Override
        TxDataHolder added(boolean createIfNotExists) {
            throw this.illegalStateException();
        }

        @Override
        TxDataHolder removed(boolean createIfNotExists) {
            throw this.illegalStateException();
        }

        private IllegalStateException illegalStateException() {
            throw new IllegalStateException("This index (" + this.index.getIdentifier() + ") has been marked as deleted in this transaction");
        }
    }

    private class TxDataBoth {
        private TxDataHolder add;
        private TxDataHolder remove;
        final LuceneIndex index;

        public TxDataBoth(LuceneIndex index) {
            this.index = index;
        }

        TxDataHolder added(boolean createIfNotExists) {
            if (this.add == null && createIfNotExists) {
                this.add = new TxDataHolder(this.index, this.index.type.newTxData(this.index));
            }
            return this.add;
        }

        TxDataHolder removed(boolean createIfNotExists) {
            if (this.remove == null && createIfNotExists) {
                this.remove = new TxDataHolder(this.index, this.index.type.newTxData(this.index));
            }
            return this.remove;
        }

        void close() {
            this.safeClose(this.add);
            this.safeClose(this.remove);
        }

        private void safeClose(TxDataHolder data) {
            if (data != null) {
                data.close();
            }
        }
    }
}

