/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer.factory;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.factory.DataBufferFactory;
import org.nd4j.linalg.jcublas.buffer.CudaDoubleDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaFloatDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaHalfDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaIntDataBuffer;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaDataBufferFactory
implements DataBufferFactory {
    protected DataBuffer.AllocationMode allocationMode;
    private static Logger log = LoggerFactory.getLogger(CudaDataBufferFactory.class);

    public void setAllocationMode(DataBuffer.AllocationMode allocationMode) {
        this.allocationMode = allocationMode;
    }

    public DataBuffer.AllocationMode allocationMode() {
        if (this.allocationMode == null) {
            String otherAlloc = System.getProperty("alloc");
            if (otherAlloc.equals("heap")) {
                this.setAllocationMode(DataBuffer.AllocationMode.HEAP);
            } else if (otherAlloc.equals("direct")) {
                this.setAllocationMode(DataBuffer.AllocationMode.DIRECT);
            } else if (otherAlloc.equals("javacpp")) {
                this.setAllocationMode(DataBuffer.AllocationMode.JAVACPP);
            }
        }
        return this.allocationMode;
    }

    public DataBuffer create(DataBuffer underlyingBuffer, long offset, long length) {
        if (underlyingBuffer.dataType() == DataBuffer.Type.DOUBLE) {
            return new CudaDoubleDataBuffer(underlyingBuffer, length, offset);
        }
        if (underlyingBuffer.dataType() == DataBuffer.Type.FLOAT) {
            return new CudaFloatDataBuffer(underlyingBuffer, length, offset);
        }
        if (underlyingBuffer.dataType() == DataBuffer.Type.INT) {
            return new CudaIntDataBuffer(underlyingBuffer, length, offset);
        }
        if (underlyingBuffer.dataType() == DataBuffer.Type.HALF) {
            return new CudaHalfDataBuffer(underlyingBuffer, length, offset);
        }
        return null;
    }

    public DataBuffer createInt(int offset, ByteBuffer buffer, int length) {
        return new CudaIntDataBuffer(buffer, length, offset);
    }

    public DataBuffer createFloat(int offset, ByteBuffer buffer, int length) {
        return new CudaFloatDataBuffer(buffer, (long)length, offset);
    }

    public DataBuffer createDouble(int offset, ByteBuffer buffer, int length) {
        return new CudaDoubleDataBuffer(buffer, (long)length, (long)offset);
    }

    public DataBuffer createDouble(int offset, int length) {
        return new CudaDoubleDataBuffer((long)length, 8, (long)offset);
    }

    public DataBuffer createFloat(int offset, int length) {
        return new CudaFloatDataBuffer((long)length, 4, (long)length);
    }

    public DataBuffer createInt(int offset, int length) {
        return new CudaIntDataBuffer((long)length, 4, offset);
    }

    public DataBuffer createDouble(int offset, int[] data) {
        return new CudaDoubleDataBuffer(data, true, (long)offset);
    }

    public DataBuffer createFloat(int offset, int[] data) {
        return new CudaFloatDataBuffer(data, true, offset);
    }

    public DataBuffer createInt(int offset, int[] data) {
        return new CudaIntDataBuffer(data, true, offset);
    }

    public DataBuffer createDouble(int offset, double[] data) {
        return new CudaDoubleDataBuffer(data, true, (long)offset);
    }

    public DataBuffer createDouble(int offset, byte[] data, int length) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubleArray((byte[])data), true, (long)offset);
    }

    public DataBuffer createFloat(int offset, byte[] data, int length) {
        return new CudaFloatDataBuffer(ArrayUtil.toDoubleArray((byte[])data), true, offset);
    }

    public DataBuffer createFloat(int offset, double[] data) {
        return new CudaFloatDataBuffer(data, true, offset);
    }

    public DataBuffer createInt(int offset, double[] data) {
        return new CudaIntDataBuffer(data, true, offset);
    }

    public DataBuffer createDouble(int offset, float[] data) {
        return new CudaDoubleDataBuffer(data, true, (long)offset);
    }

    public DataBuffer createFloat(int offset, float[] data) {
        return new CudaFloatDataBuffer(data, true, offset);
    }

    public DataBuffer createInt(int offset, float[] data) {
        return new CudaIntDataBuffer(data, true, offset);
    }

    public DataBuffer createDouble(int offset, int[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data, true, (long)offset);
    }

    public DataBuffer createFloat(int offset, int[] data, boolean copy) {
        return new CudaFloatDataBuffer(data, copy, offset);
    }

    public DataBuffer createInt(int offset, int[] data, boolean copy) {
        return new CudaIntDataBuffer(data, copy, offset);
    }

    public DataBuffer createDouble(int offset, double[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data, copy, (long)offset);
    }

    public DataBuffer createFloat(int offset, double[] data, boolean copy) {
        return new CudaFloatDataBuffer(data, copy, offset);
    }

    public DataBuffer createInt(int offset, double[] data, boolean copy) {
        return new CudaIntDataBuffer(data, copy, offset);
    }

    public DataBuffer createDouble(int offset, float[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data, copy, (long)offset);
    }

    public DataBuffer createFloat(int offset, float[] data, boolean copy) {
        return new CudaFloatDataBuffer(data, copy, offset);
    }

    public DataBuffer createInt(int offset, float[] data, boolean copy) {
        return new CudaIntDataBuffer(data, copy, offset);
    }

    public DataBuffer createInt(ByteBuffer buffer, int length) {
        return new CudaIntDataBuffer(buffer, length);
    }

    public DataBuffer createFloat(ByteBuffer buffer, int length) {
        return new CudaFloatDataBuffer(buffer, (long)length);
    }

    public DataBuffer createDouble(ByteBuffer buffer, int length) {
        return new CudaDoubleDataBuffer(buffer, (long)length);
    }

    public DataBuffer createDouble(long length) {
        return new CudaDoubleDataBuffer(length);
    }

    public DataBuffer createDouble(long length, boolean initialize) {
        return new CudaDoubleDataBuffer(length, initialize);
    }

    public DataBuffer createFloat(long length) {
        return new CudaFloatDataBuffer(length);
    }

    public DataBuffer createFloat(long length, boolean initialize) {
        return new CudaFloatDataBuffer(length, initialize);
    }

    public DataBuffer createInt(long length) {
        return new CudaIntDataBuffer(length);
    }

    public DataBuffer createInt(long length, boolean initialize) {
        return new CudaIntDataBuffer(length, initialize);
    }

    public DataBuffer createDouble(int[] data) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubles((int[])data));
    }

    public DataBuffer createFloat(int[] data) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats((int[])data));
    }

    public DataBuffer createInt(int[] data) {
        return new CudaIntDataBuffer(data);
    }

    public DataBuffer createDouble(double[] data) {
        return new CudaDoubleDataBuffer(data);
    }

    public DataBuffer createDouble(byte[] data, int length) {
        return new CudaDoubleDataBuffer(data, (long)length);
    }

    public DataBuffer createFloat(byte[] data, int length) {
        return new CudaFloatDataBuffer(data, (long)length);
    }

    public DataBuffer createFloat(double[] data) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats((double[])data));
    }

    public DataBuffer createInt(double[] data) {
        return new CudaIntDataBuffer(ArrayUtil.toInts((double[])data));
    }

    public DataBuffer createDouble(float[] data) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubles((float[])data));
    }

    public DataBuffer createFloat(float[] data) {
        return new CudaFloatDataBuffer(data);
    }

    public DataBuffer createInt(float[] data) {
        return new CudaIntDataBuffer(ArrayUtil.toInts((float[])data));
    }

    public DataBuffer createDouble(int[] data, boolean copy) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDouble((int[])data));
    }

    public DataBuffer createFloat(int[] data, boolean copy) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats((int[])data));
    }

    public DataBuffer createInt(int[] data, boolean copy) {
        return new CudaIntDataBuffer(data);
    }

    public DataBuffer createDouble(double[] data, boolean copy) {
        return new CudaDoubleDataBuffer(data);
    }

    public DataBuffer createFloat(double[] data, boolean copy) {
        return new CudaFloatDataBuffer(ArrayUtil.toFloats((double[])data));
    }

    public DataBuffer createInt(double[] data, boolean copy) {
        return new CudaIntDataBuffer(ArrayUtil.toInts((double[])data));
    }

    public DataBuffer createDouble(float[] data, boolean copy) {
        return new CudaDoubleDataBuffer(ArrayUtil.toDoubles((float[])data));
    }

    public DataBuffer createFloat(float[] data, boolean copy) {
        return new CudaFloatDataBuffer(data);
    }

    public DataBuffer createInt(float[] data, boolean copy) {
        return new CudaIntDataBuffer(ArrayUtil.toInts((float[])data));
    }

    public DataBuffer create(Pointer pointer, DataBuffer.Type type, long length, Indexer indexer) {
        switch (type) {
            case INT: {
                return new CudaIntDataBuffer(pointer, indexer, length);
            }
            case DOUBLE: {
                return new CudaDoubleDataBuffer(pointer, indexer, length);
            }
            case FLOAT: {
                return new CudaFloatDataBuffer(pointer, indexer, length);
            }
            case HALF: {
                return new CudaHalfDataBuffer(pointer, indexer, length);
            }
        }
        throw new IllegalArgumentException("Illegal type " + type);
    }

    public DataBuffer createHalf(long length) {
        return new CudaHalfDataBuffer(length);
    }

    public DataBuffer createHalf(long length, boolean initialize) {
        return new CudaHalfDataBuffer(length, initialize);
    }

    public DataBuffer createHalf(float[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy);
    }

    public DataBuffer createHalf(double[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy);
    }

    public DataBuffer createHalf(int offset, double[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy, offset);
    }

    public DataBuffer createHalf(int offset, float[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy, offset);
    }

    public DataBuffer createHalf(int offset, int[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy, offset);
    }

    public DataBuffer createHalf(int offset, double[] data) {
        return new CudaHalfDataBuffer(data, true, offset);
    }

    public DataBuffer createHalf(int offset, float[] data) {
        return new CudaHalfDataBuffer(data, true, offset);
    }

    public DataBuffer createHalf(int offset, int[] data) {
        return new CudaHalfDataBuffer(data, true, offset);
    }

    public DataBuffer createHalf(int offset, byte[] data, boolean copy) {
        return new CudaHalfDataBuffer(ArrayUtil.toFloatArray((byte[])data), copy, offset);
    }

    public DataBuffer createHalf(int[] data, boolean copy) {
        return new CudaHalfDataBuffer(data, copy);
    }

    public DataBuffer createHalf(float[] data) {
        return new CudaHalfDataBuffer(data);
    }

    public DataBuffer createHalf(double[] data) {
        return new CudaHalfDataBuffer(data);
    }

    public DataBuffer createHalf(int[] data) {
        return new CudaHalfDataBuffer(data);
    }

    public DataBuffer createHalf(int offset, byte[] data, int length) {
        return new CudaHalfDataBuffer(ArrayUtil.toFloatArray((byte[])data), true, offset);
    }

    public DataBuffer createHalf(int offset, int length) {
        return new CudaHalfDataBuffer(length);
    }

    public DataBuffer createHalf(ByteBuffer buffer, int length) {
        return new CudaHalfDataBuffer(buffer, (long)length);
    }

    public DataBuffer createHalf(byte[] data, int length) {
        return new CudaHalfDataBuffer(data, (long)length);
    }
}

