/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import jodd.core.JoddCore;
import jodd.exception.UncheckedException;
import jodd.io.findfile.ClassScanner;
import jodd.props.PropertiesToProps;
import jodd.props.Props;
import jodd.util.StringUtil;

public class PropsUtil {
    public static void loadFromClasspath(Props p, String ... patterns) {
        ClassScanner.get().onEntry(entryData -> {
            String usedEncoding = JoddCore.get().defaults().getEncoding();
            if (StringUtil.endsWithIgnoreCase((String)entryData.name(), (String)".properties")) {
                usedEncoding = "ISO-8859-1";
            }
            String encoding = usedEncoding;
            UncheckedException.runAndWrapException(() -> p.load(entryData.openInputStream(), encoding));
        }).includeResources(true).ignoreException(true).excludeAllEntries(true).includeEntries(patterns).scanDefaultClasspath();
    }

    public static Props createFromClasspath(String ... patterns) {
        Props p = new Props();
        PropsUtil.loadFromClasspath(p, patterns);
        return p;
    }

    public static void convert(Writer writer, Properties properties) throws IOException {
        Map<String, Properties> emptyProfiles = Collections.emptyMap();
        PropsUtil.convert(writer, properties, emptyProfiles);
    }

    public static void convert(Writer writer, Properties properties, Map<String, Properties> profiles) throws IOException {
        PropertiesToProps toProps = new PropertiesToProps();
        toProps.convertToWriter(writer, properties, profiles);
    }
}

