/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rmi;

import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rmi.RmiRegistry;
import com.jme3.network.service.rpc.RpcClientService;
import java.util.ArrayList;
import java.util.List;

public class RmiClientService
extends AbstractClientService {
    private RpcClientService rpc;
    private byte defaultChannel;
    private short rmiObjectId;
    private RmiRegistry rmi;
    private volatile boolean isStarted = false;
    private final List<ObjectInfo> pending = new ArrayList<ObjectInfo>();

    public RmiClientService() {
        this(-1, -2);
    }

    public RmiClientService(short rmiObjectId, byte defaultChannel) {
        this.defaultChannel = defaultChannel;
        this.rmiObjectId = rmiObjectId;
    }

    public <T> void share(T object, Class<? super T> type) {
        this.share(this.defaultChannel, object, type);
    }

    public <T> void share(byte channel, T object, Class<? super T> type) {
        this.share(channel, type.getName(), object, type);
    }

    public <T> void share(String name, T object, Class<? super T> type) {
        this.share(this.defaultChannel, name, object, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void share(byte channel, String name, T object, Class<? super T> type) {
        if (!this.isStarted) {
            List<ObjectInfo> list = this.pending;
            synchronized (list) {
                if (!this.isStarted) {
                    this.pending.add(new ObjectInfo(channel, name, object, type));
                    return;
                }
            }
        }
        this.rmi.share(channel, name, object, type);
    }

    public <T> T getRemoteObject(Class<T> type) {
        return this.rmi.getRemoteObject(type);
    }

    public <T> T getRemoteObject(String name, Class<T> type) {
        return this.rmi.getRemoteObject(name, type);
    }

    @Override
    protected void onInitialize(ClientServiceManager s) {
        this.rpc = this.getService(RpcClientService.class);
        if (this.rpc == null) {
            throw new RuntimeException("RmiClientService requires RpcClientService");
        }
        this.rmi = new RmiRegistry(this.rpc.getRpcConnection(), this.rmiObjectId, this.defaultChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        super.start();
        List<ObjectInfo> list = this.pending;
        synchronized (list) {
            for (ObjectInfo info : this.pending) {
                this.rmi.share(info.channel, info.name, info.object, info.type);
            }
            this.pending.clear();
            this.isStarted = true;
        }
    }

    private class ObjectInfo {
        byte channel;
        String name;
        Object object;
        Class type;

        public ObjectInfo(byte channel, String name, Object object, Class type) {
            this.channel = channel;
            this.name = name;
            this.object = object;
            this.type = type;
        }

        public String toString() {
            return "ObjectInfo[" + this.channel + ", " + this.name + ", " + this.object + ", " + this.type + "]";
        }
    }
}

