/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rmi;

import com.jme3.network.serializing.Serializable;
import com.jme3.network.service.rmi.Asynchronous;
import com.jme3.network.service.rmi.CallType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jws.Oneway;

@Serializable
public final class MethodInfo {
    public static final MethodInfo NULL_INFO = new MethodInfo();
    private String representation;
    private short id;
    private CallType callType;
    private transient Method method;

    public MethodInfo() {
    }

    public MethodInfo(short id, Method m) {
        this.id = id;
        this.method = m;
        this.representation = MethodInfo.methodToString(m);
        this.callType = MethodInfo.getCallType(m);
    }

    public Object invoke(Object target, Object ... parms) {
        try {
            return this.method.invoke(target, parms);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error invoking:" + this.method + " on:" + target, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error invoking:" + this.method + " on:" + target, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error invoking:" + this.method + " on:" + target, e);
        }
    }

    public short getId() {
        return this.id;
    }

    public CallType getCallType() {
        return this.callType;
    }

    public boolean matches(Method m) {
        return this.representation.equals(MethodInfo.methodToString(m));
    }

    public static String methodToString(Method m) {
        StringBuilder sb = new StringBuilder();
        for (Class<?> t : m.getParameterTypes()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(t.getName());
        }
        return m.getReturnType().getName() + " " + m.getName() + "(" + sb + ")";
    }

    public static CallType getCallType(Method m) {
        if (m.getReturnType() != Void.TYPE) {
            return CallType.Synchronous;
        }
        if (m.getAnnotation(Oneway.class) != null) {
            return CallType.Asynchronous;
        }
        if (m.getAnnotation(Asynchronous.class) == null) {
            return CallType.Synchronous;
        }
        Asynchronous async = m.getAnnotation(Asynchronous.class);
        return async.reliable() ? CallType.Asynchronous : CallType.Unreliable;
    }

    public int hashCode() {
        return this.representation.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        MethodInfo other = (MethodInfo)o;
        return this.representation.equals(other.representation);
    }

    public String toString() {
        return "MethodInfo[#" + this.getId() + ", callType=" + (Object)((Object)this.callType) + ", " + this.representation + "]";
    }
}

